/*
 * Copyright (c) 1998, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     Oracle - initial API and implementation from Oracle TopLink
package org.eclipse.persistence.testing.jaxb.xmladapter.direct;

import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="calendar")
public class MyCalendarException {
    @XmlElement(name="date")
    @XmlJavaTypeAdapter(MyCalendarExceptionAdapter.class)
    public MyCalendarType date;

    public boolean equals(Object obj) {
        if (!(obj instanceof MyCalendarException)) {
            return false;
        }
        MyCalendarType mcType = ((MyCalendarException) obj).date;
        if(date == null){
            return mcType == null;
        }
        return mcType.equals(date);
    }
}
