/*
 * Copyright (c) 2012, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     Denise Smith - 2.4 - January 2012
package org.eclipse.persistence.testing.jaxb.unmarshaller.space;

import java.util.List;

import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class TestObject {

    public String theString;
    @XmlAnyElement
    public List<Object> theAny;

    public boolean equals(Object theObject){
        if(theObject instanceof TestObject){
            if(theString == null){
                return ((TestObject)theObject).theString == null;
            }
            return theString.equals(((TestObject)theObject).theString);
        }
        return false;
    }
}
