/*
 * Copyright (c) 1998, 2021 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     Oracle - initial API and implementation from Oracle TopLink
package org.eclipse.persistence.testing.models.interfaces;

import java.util.*;

/**
 * TopLink generated Project class.
 * <b>WARNING</b>: This code was generated by an automated tool.
 * Any changes will be lost when the code is re-generated
 */
public class InterfaceWithoutTablesProject extends org.eclipse.persistence.sessions.Project {

    public InterfaceWithoutTablesProject() {
        applyPROJECT();
        applyLOGIN();
        buildActorDescriptor();
        buildAdministrativeJobDescriptor();
        buildAssetDescriptor();
        buildCompanyDescriptor();
        buildCompanyAssetDescriptor();
        buildComputerDescriptor();
        buildContactDescriptor();
        buildContactHolderDescriptor();
        buildCourseDeveloperDescriptor();
        buildDevelopmentJobDescriptor();
        buildDocumentaryDescriptor();
        buildEmailDescriptor();
        buildEmployeeDescriptor();
        buildFilmDescriptor();
        buildJobDescriptor();
        buildManagerialJobDescriptor();
        buildPersonnelManagerDescriptor();
        buildPhoneDescriptor();
        buildProductDeveloperDescriptor();
        buildProductManagerDescriptor();
        buildProgramIntDescriptor();
        buildReceptionistDescriptor();
        buildSecretaryDescriptor();
        buildUnionizedDescriptor();
        buildVehicleDescriptor();
        buildVIPDescriptor();
    }

    protected void applyLOGIN() {
        org.eclipse.persistence.sessions.DatabaseLogin login = new org.eclipse.persistence.sessions.DatabaseLogin();
        setLogin(login);
    }

    protected void applyPROJECT() {
        setName("InterfaceWithOutTablesSystem");
    }

    protected void buildActorDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(Actor.class);
        Vector vector = new Vector();
        vector.addElement("ACTOR");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("ACTOR.ID");
        descriptor.addPrimaryKeyFieldName("ACTOR.PROGRAM_ID");
        descriptor.addPrimaryKeyFieldName("ACTOR.PROGRAM_TYPE");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setSequenceNumberName("SEQ_ACTOR");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("fname");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("ACTOR.FNAME");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("id");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("ACTOR.ID");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping2 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("lname");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("ACTOR.LNAME");
        descriptor.addMapping(directtofieldmapping2);

        // SECTION: VARIABLEONETOONEMAPPING
        org.eclipse.persistence.mappings.VariableOneToOneMapping variableonetoonemapping =
            new org.eclipse.persistence.mappings.VariableOneToOneMapping();
        variableonetoonemapping.setAttributeName("program");
        variableonetoonemapping.setIsReadOnly(false);
        variableonetoonemapping.setUsesIndirection(false);
        variableonetoonemapping.setReferenceClass(ProgramInt.class);
        variableonetoonemapping.setIsPrivateOwned(false);
        variableonetoonemapping.addForeignQueryKeyName("ACTOR.PROGRAM_ID", "id");
        variableonetoonemapping.setTypeFieldName("ACTOR.PROGRAM_TYPE");
        variableonetoonemapping.addClassIndicator(Documentary.class, "D");
        variableonetoonemapping.addClassIndicator(Film.class, "F");
        descriptor.addMapping(variableonetoonemapping);
        addDescriptor(descriptor);
    }

    protected void buildAdministrativeJobDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(AdministrativeJob.class);
        Vector vector = new Vector();
        vector.addElement("ADM_JOB");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("ADM_JOB.CODE");

        // SECTION: PROPERTIES
        descriptor.setSequenceNumberName("ADM_SEQ");
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setSequenceNumberFieldName("CODE");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.addDirectQueryKey("id", "ADM_JOB.CODE");
        descriptor.getInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.getInheritancePolicy().setClassIndicatorFieldName("TYPE");
        descriptor.getInheritancePolicy().setShouldUseClassNameAsIndicator(false);
        descriptor.getInheritancePolicy().addClassIndicator(Receptionist.class,
                                                            "R");
        descriptor.getInheritancePolicy().addClassIndicator(Secretary.class,
                                                            "S");
        descriptor.getInterfacePolicy().addParentInterface(Unionized.class);
        descriptor.getInterfacePolicy().addParentInterface(Job.class);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("jobCode");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("ADM_JOB.CODE");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("minimumSalary");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("ADM_JOB.MIN_SAL");
        descriptor.addMapping(directtofieldmapping1);
        addDescriptor(descriptor);
    }

    protected void buildAssetDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(Asset.class);
        Vector vector = new Vector();
        vector.addElement("INT_EMP");
        descriptor.setTableNames(vector);

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.addDirectQueryKey("ID", "INT_EMP.ASSET_ID");
        descriptor.descriptorIsAggregate();
        descriptor.getInterfacePolicy().addParentInterface(CompanyAsset.class);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: VARIABLEONETOONEMAPPING
        org.eclipse.persistence.mappings.VariableOneToOneMapping variableonetoonemapping =
            new org.eclipse.persistence.mappings.VariableOneToOneMapping();
        variableonetoonemapping.setAttributeName("asset");
        variableonetoonemapping.setIsReadOnly(false);
        variableonetoonemapping.setUsesIndirection(false);
        variableonetoonemapping.setReferenceClass(CompanyAsset.class);
        variableonetoonemapping.setIsPrivateOwned(true);
        variableonetoonemapping.addForeignQueryKeyName("INT_EMP.ASSET_ID", "ID");
        variableonetoonemapping.setTypeFieldName("INT_EMP.ASSET_TYPE");
        variableonetoonemapping.addClassIndicator(Computer.class, "C");
        variableonetoonemapping.addClassIndicator(Vehicle.class, "V");
        descriptor.addMapping(variableonetoonemapping);
        addDescriptor(descriptor);
    }

    protected void buildCompanyAssetDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(CompanyAsset.class);

        // SECTION: PROPERTIES
        descriptor.addAbstractQueryKey("ID");
        descriptor.setJavaInterface(CompanyAsset.class);
        addDescriptor(descriptor);
    }

    protected void buildCompanyDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(Company.class);
        Vector vector = new Vector();
        vector.addElement("INT_CMP");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("INT_CMP.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setSequenceNumberName("CMP_SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.addDirectQueryKey("C_ID", "INT_CMP.CON_ID");
        descriptor.setIdentityMapSize(100);
        descriptor.getInterfacePolicy().addParentInterface(ContactHolder.class);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("INT_CMP.ID");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("name");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("INT_CMP.NAME");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: VARIABLEONETOONEMAPPING
        org.eclipse.persistence.mappings.VariableOneToOneMapping variableonetoonemapping =
            new org.eclipse.persistence.mappings.VariableOneToOneMapping();
        variableonetoonemapping.setWeight(Integer.valueOf(3));
        variableonetoonemapping.setAttributeName("contact");
        variableonetoonemapping.setIsReadOnly(false);
        variableonetoonemapping.setUsesIndirection(false);
        variableonetoonemapping.setReferenceClass(Contact.class);
        variableonetoonemapping.setIsPrivateOwned(true);
        variableonetoonemapping.addForeignQueryKeyName("INT_CMP.CON_ID", "id");
        variableonetoonemapping.setTypeFieldName("INT_CMP.TYPE");
        variableonetoonemapping.addClassIndicator(Email.class, "E");
        variableonetoonemapping.addClassIndicator(Phone.class, "P");
        descriptor.addMapping(variableonetoonemapping);

        org.eclipse.persistence.mappings.OneToOneMapping onetoonemapping = new org.eclipse.persistence.mappings.OneToOneMapping();
        onetoonemapping.setAttributeName("email");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(false);
        onetoonemapping.setReferenceClass(Email.class);
        onetoonemapping.setIsPrivateOwned(false);
        onetoonemapping.addForeignKeyFieldName("INT_CMP.EMAIL_ID", "INT_EML.E_ID");

        descriptor.addMapping(onetoonemapping);

        addDescriptor(descriptor);
    }

    protected void buildComputerDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(Computer.class);
        Vector vector = new Vector();
        vector.addElement("INT_COMP");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("INT_COMP.SERNUM");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setSequenceNumberName("ASSET_SEQ");
        descriptor.setSequenceNumberFieldName("SERNUM");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.addDirectQueryKey("ID", "INT_COMP.SERNUM");
        descriptor.getInterfacePolicy().addParentInterface(CompanyAsset.class);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("description");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("INT_COMP.DESCRIP");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("serNum");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("INT_COMP.SERNUM");
        descriptor.addMapping(directtofieldmapping1);
        addDescriptor(descriptor);
    }

    /**
 * TopLink generated method.
 * <b>WARNING</b>: This code was generated by an automated tool.
 * Any changes will be lost when the code is re-generated
 */
    protected void buildContactDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(Contact.class);

        // SECTION: PROPERTIES
        descriptor.addAbstractQueryKey("id");
        descriptor.setJavaInterface(Contact.class);
        addDescriptor(descriptor);
    }

    protected void buildContactHolderDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(ContactHolder.class);

        // SECTION: PROPERTIES
        descriptor.addAbstractQueryKey("C_ID");
        descriptor.setJavaInterface(ContactHolder.class);
        addDescriptor(descriptor);
    }

    protected void buildCourseDeveloperDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(CourseDeveloper.class);
        descriptor.getInheritancePolicy().setParentClass(DevelopmentJob.class);
        Vector vector = new Vector();
        vector.addElement("CRS_DEV");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("CRS_DEV.CODE");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInheritancePolicy().setShouldReadSubclasses(false);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("course");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("CRS_DEV.COURSE");
        descriptor.addMapping(directtofieldmapping);
        addDescriptor(descriptor);
    }

    protected void buildDevelopmentJobDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(DevelopmentJob.class);
        Vector vector = new Vector();
        vector.addElement("DEV_JOB");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("DEV_JOB.CODE");

        // SECTION: PROPERTIES
        descriptor.setSequenceNumberName("DEV_SEQ");
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setSequenceNumberFieldName("CODE");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.addDirectQueryKey("id", "DEV_JOB.CODE");
        descriptor.getInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.getInheritancePolicy().setClassIndicatorFieldName("TYPE");
        descriptor.getInheritancePolicy().setShouldUseClassNameAsIndicator(false);
        descriptor.getInheritancePolicy().addClassIndicator(CourseDeveloper.class,
                                                            "C");
        descriptor.getInheritancePolicy().addClassIndicator(ProductDeveloper.class,
                                                            "P");
        descriptor.getInterfacePolicy().addParentInterface(Job.class);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("jobCode");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("DEV_JOB.CODE");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("salary");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("DEV_JOB.SALARY");
        descriptor.addMapping(directtofieldmapping1);
        addDescriptor(descriptor);
    }

    protected void buildDocumentaryDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(Documentary.class);
        Vector vector = new Vector();
        vector.addElement("DOCUMENTARY");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("DOCUMENTARY.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setSequenceNumberName("SEQ_PROGRAM");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInterfacePolicy().addParentInterface(ProgramInt.class);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("description");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("DOCUMENTARY.DESCRIPTION");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("duration");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("DOCUMENTARY.DURATION");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping2 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("id");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("DOCUMENTARY.ID");
        descriptor.addMapping(directtofieldmapping2);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping3 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping3.setAttributeName("name");
        directtofieldmapping3.setIsReadOnly(false);
        directtofieldmapping3.setFieldName("DOCUMENTARY.NAME");
        descriptor.addMapping(directtofieldmapping3);

        // SECTION: ONETOMANYMAPPING
        org.eclipse.persistence.mappings.OneToManyMapping onetomanymapping = new org.eclipse.persistence.mappings.OneToManyMapping();
        onetomanymapping.setAttributeName("actors");
        onetomanymapping.setIsReadOnly(false);
        onetomanymapping.setUsesIndirection(false);
        onetomanymapping.setReferenceClass(Actor.class);
        onetomanymapping.setIsPrivateOwned(true);
        onetomanymapping.addTargetForeignKeyFieldName("ACTOR.PROGRAM_ID", "DOCUMENTARY.ID");
        descriptor.addMapping(onetomanymapping);
        addDescriptor(descriptor);
    }

    protected void buildEmailDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(Email.class);
        Vector vector = new Vector();
        vector.addElement("INT_EML");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("INT_EML.E_ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setSequenceNumberName("Email_SEQ");
        descriptor.setSequenceNumberFieldName("E_ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInterfacePolicy().addParentInterface(Contact.class);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("address");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("INT_EML.ADDR");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("id");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("INT_EML.E_ID");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: VARIABLEONETOONEMAPPING
        org.eclipse.persistence.mappings.VariableOneToOneMapping variableonetoonemapping =
            new org.eclipse.persistence.mappings.VariableOneToOneMapping();
        variableonetoonemapping.setAttributeName("employee");
        variableonetoonemapping.setIsReadOnly(false);
        variableonetoonemapping.setUsesIndirection(false);
        variableonetoonemapping.setReferenceClass(ContactHolder.class);
        variableonetoonemapping.setIsPrivateOwned(false);
        variableonetoonemapping.addTargetForeignQueryKeyName("C_ID", "INT_EML.E_ID");
        variableonetoonemapping.setTypeFieldName("INT_EML.TYPE");
        variableonetoonemapping.addClassIndicator(Company.class, "C");
        variableonetoonemapping.addClassIndicator(Employee.class, "E");
        descriptor.addMapping(variableonetoonemapping);
        addDescriptor(descriptor);
    }

    protected void buildEmployeeDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(Employee.class);
        Vector vector = new Vector();
        vector.addElement("INT_EMP");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("INT_EMP.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setSequenceNumberName("EMP_SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.addDirectQueryKey("C_ID", "INT_EMP.CON_ID");
        descriptor.getInterfacePolicy().addParentInterface(ContactHolder.class);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: AGGREGATEOBJECTMAPPING
        org.eclipse.persistence.mappings.AggregateObjectMapping aggregateobjectmapping =
            new org.eclipse.persistence.mappings.AggregateObjectMapping();
        aggregateobjectmapping.setAttributeName("asset1");
        aggregateobjectmapping.setIsReadOnly(false);
        aggregateobjectmapping.setReferenceClass(Asset.class);
        aggregateobjectmapping.setIsNullAllowed(false);
        descriptor.addMapping(aggregateobjectmapping);

        // SECTION: AGGREGATEOBJECTMAPPING
        org.eclipse.persistence.mappings.AggregateObjectMapping aggregateobjectmapping1 =
            new org.eclipse.persistence.mappings.AggregateObjectMapping();
        aggregateobjectmapping1.setAttributeName("asset2");
        aggregateobjectmapping1.setIsReadOnly(false);
        aggregateobjectmapping1.setReferenceClass(Asset.class);
        aggregateobjectmapping1.setIsNullAllowed(false);
        aggregateobjectmapping1.addFieldNameTranslation("INT_EMP.ASSET2_ID", "INT_EMP.ASSET_ID");
        descriptor.addMapping(aggregateobjectmapping1);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("INT_EMP.ID");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("name");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("INT_EMP.NAME");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: VARIABLEONETOONEMAPPING
        org.eclipse.persistence.mappings.VariableOneToOneMapping variableonetoonemapping =
            new org.eclipse.persistence.mappings.VariableOneToOneMapping();
        variableonetoonemapping.setAttributeName("contact");
        variableonetoonemapping.setIsReadOnly(false);
        variableonetoonemapping.setUsesIndirection(false);
        variableonetoonemapping.setReferenceClass(Contact.class);
        variableonetoonemapping.setIsPrivateOwned(true);
        variableonetoonemapping.addForeignQueryKeyName("INT_EMP.CON_ID", "id");
        variableonetoonemapping.setTypeFieldName("INT_EMP.CONTACT_TYPE");
        //variableonetoonemapping.addClassIndicator(Email.class, "E");
        //variableonetoonemapping.addClassIndicator(Phone.class, "P");
        variableonetoonemapping.addClassIndicator(Email.class,
                                                  Float.valueOf(1)); // TO TEST NUMERIC TYPE INDICATOR
        variableonetoonemapping.addClassIndicator(Phone.class, Float.valueOf(2));
        descriptor.addMapping(variableonetoonemapping);

        // SECTION: VARIABLEONETOONEMAPPING
        org.eclipse.persistence.mappings.VariableOneToOneMapping variableonetoonemapping2 =
            new org.eclipse.persistence.mappings.VariableOneToOneMapping();
        variableonetoonemapping2.setAttributeName("secondaryContact");
        variableonetoonemapping2.setIsReadOnly(false);
        variableonetoonemapping2.setUsesIndirection(true);
        variableonetoonemapping2.setReferenceClass(Contact.class);
        variableonetoonemapping2.setIsPrivateOwned(true);
        variableonetoonemapping2.addForeignQueryKeyName("INT_EMP.SEC_CON_ID", "id");
        variableonetoonemapping2.setTypeFieldName("INT_EMP.SEC_CONTACT_TYPE");
        //variableonetoonemapping2.addClassIndicator(Email.class, "E");
        //variableonetoonemapping2.addClassIndicator(Phone.class, "P");
        variableonetoonemapping2.addClassIndicator(Email.class,
                                                   Float.valueOf(1)); // TO TEST NUMERIC TYPE INDICATOR
        variableonetoonemapping2.addClassIndicator(Phone.class, Float.valueOf(2));
        descriptor.addMapping(variableonetoonemapping2);

        Employee.addToDescriptor(descriptor);
        addDescriptor(descriptor);
    }

    protected void buildFilmDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(Film.class);
        Vector vector = new Vector();
        vector.addElement("FILM");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("FILM.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setSequenceNumberName("SEQ_PROGRAM");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInterfacePolicy().addParentInterface(ProgramInt.class);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("description");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("FILM.DESCRIPTION");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("duration");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("FILM.DURATION");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping2 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("id");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("FILM.ID");
        descriptor.addMapping(directtofieldmapping2);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping3 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping3.setAttributeName("name");
        directtofieldmapping3.setIsReadOnly(false);
        directtofieldmapping3.setFieldName("FILM.NAME");
        descriptor.addMapping(directtofieldmapping3);

        // SECTION: ONETOMANYMAPPING
        org.eclipse.persistence.mappings.OneToManyMapping onetomanymapping = new org.eclipse.persistence.mappings.OneToManyMapping();
        onetomanymapping.setAttributeName("actors");
        onetomanymapping.setIsReadOnly(false);
        onetomanymapping.setUsesIndirection(false);
        onetomanymapping.setReferenceClass(Actor.class);
        onetomanymapping.setIsPrivateOwned(true);
        onetomanymapping.addTargetForeignKeyFieldName("ACTOR.PROGRAM_ID", "FILM.ID");
        descriptor.addMapping(onetomanymapping);
        addDescriptor(descriptor);
    }

    protected void buildJobDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(Job.class);

        // SECTION: PROPERTIES
        descriptor.addAbstractQueryKey("id");
        descriptor.setJavaInterface(Job.class);
        addDescriptor(descriptor);
    }

    protected void buildManagerialJobDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(ManagerialJob.class);

        // SECTION: PROPERTIES
        descriptor.setJavaInterface(ManagerialJob.class);
        addDescriptor(descriptor);
    }

    protected void buildPersonnelManagerDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(PersonnelManager.class);
        Vector vector = new Vector();
        vector.addElement("PER_MGR");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("PER_MGR.CODE");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setSequenceNumberName("MGR_SEQ");
        descriptor.setSequenceNumberFieldName("CODE");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.addDirectQueryKey("id", "PER_MGR.CODE");
        descriptor.getInterfacePolicy().addParentInterface(ManagerialJob.class);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("department");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("PER_MGR.DEPT");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("jobCode");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("PER_MGR.CODE");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping2 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("salary");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("PER_MGR.SALARY");
        descriptor.addMapping(directtofieldmapping2);
        addDescriptor(descriptor);
    }

    protected void buildPhoneDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(Phone.class);
        Vector vector = new Vector();
        vector.addElement("INT_PHN");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("INT_PHN.P_ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setSequenceNumberName("Phone_SEQ");
        descriptor.setSequenceNumberFieldName("P_ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInterfacePolicy().addParentInterface(Contact.class);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("INT_PHN.P_ID");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("number");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("INT_PHN.P_NUM");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: VARIABLEONETOONEMAPPING
        org.eclipse.persistence.mappings.VariableOneToOneMapping variableonetoonemapping =
            new org.eclipse.persistence.mappings.VariableOneToOneMapping();
        variableonetoonemapping.setAttributeName("employee");
        variableonetoonemapping.setIsReadOnly(false);
        variableonetoonemapping.setUsesIndirection(false);
        variableonetoonemapping.setReferenceClass(ContactHolder.class);
        variableonetoonemapping.setIsPrivateOwned(false);
        variableonetoonemapping.addTargetForeignQueryKeyName("C_ID", "INT_PHN.P_ID");
        variableonetoonemapping.setTypeFieldName("INT_PHN.TYPE");
        variableonetoonemapping.addClassIndicator(Company.class, "C");
        variableonetoonemapping.addClassIndicator(Employee.class, "E");
        descriptor.addMapping(variableonetoonemapping);
        addDescriptor(descriptor);
    }

    protected void buildProductDeveloperDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(ProductDeveloper.class);
        descriptor.getInheritancePolicy().setParentClass(DevelopmentJob.class);
        Vector vector = new Vector();
        vector.addElement("PRD_DEV");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("PRD_DEV.CODE");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInheritancePolicy().setShouldReadSubclasses(false);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("product");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("PRD_DEV.PRODUCT");
        descriptor.addMapping(directtofieldmapping);
        addDescriptor(descriptor);
    }

    protected void buildProductManagerDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(ProductManager.class);
        Vector vector = new Vector();
        vector.addElement("PRD_MGR");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("PRD_MGR.CODE");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setSequenceNumberName("MGR_SEQ");
        descriptor.setSequenceNumberFieldName("CODE");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.addDirectQueryKey("id", "PRD_MGR.CODE");
        descriptor.getInterfacePolicy().addParentInterface(VIP.class);
        descriptor.getInterfacePolicy().addParentInterface(ManagerialJob.class);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("goldCardNumber");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("PRD_MGR.GOLD_CARD");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("jobCode");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("PRD_MGR.CODE");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping2 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("product");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("PRD_MGR.PRODUCT");
        descriptor.addMapping(directtofieldmapping2);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping3 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping3.setAttributeName("salary");
        directtofieldmapping3.setIsReadOnly(false);
        directtofieldmapping3.setFieldName("PRD_MGR.SALARY");
        descriptor.addMapping(directtofieldmapping3);
        addDescriptor(descriptor);
    }

    protected void buildProgramIntDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(ProgramInt.class);

        // SECTION: PROPERTIES
        descriptor.addAbstractQueryKey("id");
        descriptor.setJavaInterface(ProgramInt.class);
        addDescriptor(descriptor);
    }

    protected void buildReceptionistDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(Receptionist.class);
        descriptor.getInheritancePolicy().setParentClass(AdministrativeJob.class);
        Vector vector = new Vector();
        vector.addElement("RECEP");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("RECEP.CODE");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInheritancePolicy().setShouldReadSubclasses(false);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("jobCode");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("RECEP.CODE");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("salary");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("RECEP.SALARY");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping2 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("wordsPerMinute");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("RECEP.WPM");
        descriptor.addMapping(directtofieldmapping2);
        addDescriptor(descriptor);
    }

    protected void buildSecretaryDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(Secretary.class);
        descriptor.getInheritancePolicy().setParentClass(AdministrativeJob.class);
        Vector vector = new Vector();
        vector.addElement("SECRTRY");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("SECRTRY.CODE");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInheritancePolicy().setShouldReadSubclasses(false);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("department");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("SECRTRY.DEPT");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("jobCode");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("SECRTRY.CODE");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping2 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("salary");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("SECRTRY.SALARY");
        descriptor.addMapping(directtofieldmapping2);
        addDescriptor(descriptor);
    }

    protected void buildUnionizedDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(Unionized.class);

        // SECTION: PROPERTIES
        descriptor.addAbstractQueryKey("id");
        descriptor.setJavaInterface(Unionized.class);
        addDescriptor(descriptor);
    }

    protected void buildVehicleDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(Vehicle.class);
        Vector vector = new Vector();
        vector.addElement("INT_VEH");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("INT_VEH.SERNUM");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setSequenceNumberName("ASSET_SEQ");
        descriptor.setSequenceNumberFieldName("SERNUM");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.addDirectQueryKey("ID", "INT_VEH.SERNUM");
        descriptor.getInterfacePolicy().addParentInterface(CompanyAsset.class);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("colour");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("INT_VEH.COLOUR");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("make");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("INT_VEH.MAKE");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping2 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("model");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("INT_VEH.MODEL");
        descriptor.addMapping(directtofieldmapping2);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping3 =
            new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping3.setAttributeName("serNum");
        directtofieldmapping3.setIsReadOnly(false);
        directtofieldmapping3.setFieldName("INT_VEH.SERNUM");
        descriptor.addMapping(directtofieldmapping3);
        addDescriptor(descriptor);
    }

    protected void buildVIPDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();


        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(VIP.class);

        // SECTION: PROPERTIES
        descriptor.setJavaInterface(VIP.class);
        descriptor.getInterfacePolicy().setImplementorDescriptor(ProductManager.class);
        addDescriptor(descriptor);
    }
}
