/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.performance;

import jakarta.persistence.EntityManager;
import jakarta.persistence.spi.PersistenceProvider;
import java.lang.reflect.Field;
import java.sql.Date;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.LoadBuildSystem;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.performance.Address;
import org.eclipse.persistence.testing.models.jpa.performance.Employee;
import org.eclipse.persistence.testing.models.jpa.performance.EmployeeTableCreator;
import org.eclipse.persistence.testing.models.jpa.performance.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.performance.LargeProject;
import org.eclipse.persistence.testing.models.jpa.performance.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.performance.SmallProject;
import org.eclipse.persistence.testing.tests.jpa.performance.misc.JPABootstrapPerformanceTest;
import org.eclipse.persistence.testing.tests.jpa.performance.misc.JPAMetadataPerformanceTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadAllAddressNamedQueryPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadAllAddressPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadAllAddressSimpleExpressionPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadAllEmployeeCompletelyJoinedPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadAllEmployeeCompletelyPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadAllEmployeeComplexDynamicExpressionPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadAllEmployeeComplexExpressionPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadAllEmployeePerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadAllLargeProjectPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadAllProjectPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadAllSmallProjectPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadObjectAddressExpressionPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadObjectAddressNamedQueryPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadObjectAddressPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadObjectCompletelyEmployeePerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadObjectEmployeePerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadObjectGetAddressPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.writing.JPAComplexUpdateEmployeePerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.writing.JPAInsertAddressPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.writing.JPAInsertDeleteAddressPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.writing.JPAInsertDeleteEmployeePerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.writing.JPAInsertEmployeePerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.writing.JPAMassInsertAddressPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.writing.JPAMassInsertEmployeePerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.writing.JPAMassInsertOrMergeEmployeeWithManagementLevelsPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.writing.JPAUpdateAddressPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.writing.JPAUpdateEmployeePerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.performance.emulateddb.EmulatedDriver;

public class JPAPerformanceRegressionModel
extends TestModel {
    public boolean isEmulated;

    public JPAPerformanceRegressionModel() {
        this.setDescription("Performance tests that compare JPA performance.");
    }

    public void addTests() {
        this.addTest((Test)this.getReadingTestSuite());
        this.addTest((Test)this.getWritingTestSuite());
        this.addTest((Test)this.getMiscTestSuite());
        TestSuite suite = new TestSuite();
        suite.setName("ChangeTrackingSuite");
        suite.addTest((Test)this.buildChangeTrackingTest());
        suite.addTest((Test)this.buildFieldAccessChangeTrackingTest());
        suite.addTest((Test)this.buildEmployeeChangeTrackingTest());
        suite.addTest((Test)this.buildDateChangeTrackingTest());
        this.addTest((Test)suite);
    }

    public TestSuite getReadingTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("JPAReadingTestSuite");
        suite.setDescription("This suite tests reading performance.");
        suite.addTest((Test)new JPAReadAllAddressPerformanceComparisonTest(true));
        suite.addTest((Test)new JPAReadAllAddressPerformanceComparisonTest(false));
        suite.addTest((Test)new JPAReadAllAddressSimpleExpressionPerformanceComparisonTest(true));
        suite.addTest((Test)new JPAReadAllAddressSimpleExpressionPerformanceComparisonTest(false));
        suite.addTest((Test)new JPAReadAllAddressNamedQueryPerformanceComparisonTest(true));
        suite.addTest((Test)new JPAReadAllAddressNamedQueryPerformanceComparisonTest(false));
        suite.addTest((Test)new JPAReadAllEmployeePerformanceComparisonTest(true));
        suite.addTest((Test)new JPAReadAllEmployeePerformanceComparisonTest(false));
        suite.addTest((Test)new JPAReadAllEmployeeComplexExpressionPerformanceComparisonTest(true));
        suite.addTest((Test)new JPAReadAllEmployeeComplexExpressionPerformanceComparisonTest(false));
        suite.addTest((Test)new JPAReadAllEmployeeComplexDynamicExpressionPerformanceComparisonTest(true));
        suite.addTest((Test)new JPAReadAllEmployeeCompletelyPerformanceComparisonTest(true));
        suite.addTest((Test)new JPAReadAllEmployeeCompletelyPerformanceComparisonTest(false));
        suite.addTest((Test)new JPAReadAllEmployeeCompletelyJoinedPerformanceComparisonTest(true));
        suite.addTest((Test)new JPAReadAllEmployeeCompletelyJoinedPerformanceComparisonTest(false));
        suite.addTest((Test)new JPAReadAllProjectPerformanceComparisonTest(true));
        suite.addTest((Test)new JPAReadAllProjectPerformanceComparisonTest(false));
        suite.addTest((Test)new JPAReadAllSmallProjectPerformanceComparisonTest(true));
        suite.addTest((Test)new JPAReadAllSmallProjectPerformanceComparisonTest(false));
        suite.addTest((Test)new JPAReadAllLargeProjectPerformanceComparisonTest(true));
        suite.addTest((Test)new JPAReadAllLargeProjectPerformanceComparisonTest(false));
        suite.addTest((Test)new JPAReadObjectAddressPerformanceComparisonTest());
        suite.addTest((Test)new JPAReadObjectGetAddressPerformanceComparisonTest());
        suite.addTest((Test)new JPAReadObjectAddressExpressionPerformanceComparisonTest(true));
        suite.addTest((Test)new JPAReadObjectAddressExpressionPerformanceComparisonTest(false));
        suite.addTest((Test)new JPAReadObjectAddressNamedQueryPerformanceComparisonTest());
        suite.addTest((Test)new JPAReadObjectEmployeePerformanceComparisonTest());
        suite.addTest((Test)new JPAReadObjectCompletelyEmployeePerformanceComparisonTest());
        return suite;
    }

    public TestSuite getWritingTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("JPAWritingTestSuite");
        suite.setDescription("This suite tests uow/writing performance.");
        suite.addTest((Test)new JPAInsertAddressPerformanceComparisonTest());
        suite.addTest((Test)new JPAInsertDeleteAddressPerformanceComparisonTest());
        suite.addTest((Test)new JPAMassInsertAddressPerformanceComparisonTest());
        suite.addTest((Test)new JPAUpdateAddressPerformanceComparisonTest());
        suite.addTest((Test)new JPAInsertEmployeePerformanceComparisonTest());
        suite.addTest((Test)new JPAInsertDeleteEmployeePerformanceComparisonTest());
        suite.addTest((Test)new JPAUpdateEmployeePerformanceComparisonTest());
        suite.addTest((Test)new JPAComplexUpdateEmployeePerformanceComparisonTest());
        suite.addTest((Test)new JPAMassInsertEmployeePerformanceComparisonTest());
        int nLevels = 2;
        int nDirects = 10;
        suite.addTest((Test)new JPAMassInsertOrMergeEmployeeWithManagementLevelsPerformanceComparisonTest(true, false, nLevels, nDirects));
        suite.addTest((Test)new JPAMassInsertOrMergeEmployeeWithManagementLevelsPerformanceComparisonTest(true, true, nLevels, nDirects));
        suite.addTest((Test)new JPAMassInsertOrMergeEmployeeWithManagementLevelsPerformanceComparisonTest(false, false, nLevels, nDirects));
        suite.addTest((Test)new JPAMassInsertOrMergeEmployeeWithManagementLevelsPerformanceComparisonTest(false, true, nLevels, nDirects));
        return suite;
    }

    public void setupDatabase(EntityManager manager) {
        try {
            new EmployeeTableCreator().replaceTables((DatabaseSession)((JpaEntityManager)manager).getServerSession());
        }
        catch (ClassCastException cast) {
            new EmployeeTableCreator().replaceTables(this.getDatabaseSession());
        }
    }

    public TestSuite getMiscTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("JPAMiscTestSuite");
        suite.setDescription("This suite tests miscellaneous performance.");
        suite.addTest((Test)new JPABootstrapPerformanceTest());
        suite.addTest((Test)new JPAMetadataPerformanceTest());
        return suite;
    }

    public void setup() {
        int j;
        this.setupProvider();
        this.getSession().logMessage(this.getExecutor().getEntityManagerFactory().getClass().toString());
        System.out.println(this.getExecutor().getEntityManagerFactory().getClass().toString());
        EmulatedDriver.emulate = false;
        EntityManager manager = this.getExecutor().createEntityManager();
        this.setupDatabase(manager);
        manager.getTransaction().begin();
        for (j = 0; j < 100; ++j) {
            Employee empInsert = new Employee();
            empInsert.setFirstName("Brendan");
            empInsert.setMale();
            empInsert.setLastName("" + j + "");
            empInsert.setSalary(100000);
            EmploymentPeriod employmentPeriod = new EmploymentPeriod();
            Date startDate = Helper.dateFromString((String)"1901-12-31");
            Date endDate = Helper.dateFromString((String)"1895-01-01");
            employmentPeriod.setEndDate(startDate);
            employmentPeriod.setStartDate(endDate);
            empInsert.setPeriod(employmentPeriod);
            empInsert.setAddress(new Address());
            empInsert.getAddress().setCity("Nepean");
            empInsert.getAddress().setPostalCode("N5J2N5");
            empInsert.getAddress().setProvince("ON");
            empInsert.getAddress().setStreet("1111 Mountain Blvd. Floor 13, suite " + j);
            empInsert.getAddress().setCountry("Canada");
            empInsert.addPhoneNumber(new PhoneNumber("Work Fax", "613", "2255943"));
            empInsert.addPhoneNumber(new PhoneNumber("Home", "613", "2224599"));
            manager.persist((Object)empInsert);
        }
        for (j = 0; j < 50; ++j) {
            SmallProject project = new SmallProject();
            project.setName("Tracker");
            manager.persist((Object)project);
            project = new LargeProject();
            project.setName("Tracker");
            manager.persist((Object)project);
        }
        manager.getTransaction().commit();
        manager.close();
        EmulatedDriver.emulate = true;
    }

    public void setupProvider() {
        if (JUnitTestCase.isOnServer()) {
            return;
        }
        String providerClass = "org.eclipse.persistence.jpa.PersistenceProvider";
        PersistenceProvider provider = null;
        try {
            provider = (PersistenceProvider)Class.forName(providerClass).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception error) {
            throw new TestProblemException("Failed to create persistence provider.", (Throwable)error);
        }
        Map properties = this.getPersistenceProperties();
        this.getExecutor().setEntityManagerFactory(provider.createEntityManagerFactory("performance", properties));
    }

    public Map getPersistenceProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("eclipselink.jdbc.driver", this.getSession().getLogin().getDriverClassName());
        properties.put("eclipselink.jdbc.url", this.getSession().getLogin().getConnectionString());
        properties.put("eclipselink.jdbc.user", this.getSession().getLogin().getUserName());
        properties.put("eclipselink.jdbc.password", this.getSession().getLogin().getPassword());
        if (this.isEmulated) {
            try {
                Class.forName(this.getSession().getLogin().getDriverClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            properties.put("eclipselink.jdbc.driver", "org.eclipse.persistence.testing.tests.performance.emulateddb.EmulatedDriver");
            properties.put("eclipselink.jdbc.url", "emulate:" + this.getSession().getLogin().getConnectionString());
            LoadBuildSystem.loadBuild.loginChoice = "emulate:" + this.getSession().getLogin().getConnectionString();
        }
        properties.put("eclipselink.sequencing.default-sequence-to-table", "true");
        properties.put("eclipselink.logging.level", this.getSession().getSessionLog().getLevelString());
        properties.put("eclipselink.jdbc.cache-statements", "true");
        return properties;
    }

    public TestCase buildChangeTrackingTest() {
        TestCase test = new TestCase(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void test() throws Exception {
                EntityManager manager = this.createEntityManager();
                manager.getTransaction().begin();
                Address address = (Address)manager.createQuery("Select a from Address a").getResultList().get(0);
                try {
                    Field field = Address.class.getDeclaredField("street");
                    field.setAccessible(true);
                    field.set(address, "Hastings");
                }
                finally {
                    manager.getTransaction().commit();
                    manager.close();
                }
                manager = this.createEntityManager();
                address = (Address)manager.find(Address.class, (Object)address.getId());
                if (address.getStreet().equals("Hastings")) {
                    this.throwError("Change tracking detected the change (not used?).");
                } else {
                    this.throwError("Change tracking did not detect the change (used?).");
                }
            }
        };
        test.setName("TestChangeTracking");
        return test;
    }

    public TestCase buildFieldAccessChangeTrackingTest() {
        TestCase test = new TestCase(){

            public void test() throws Exception {
                EntityManager manager = this.createEntityManager();
                manager.getTransaction().begin();
                Address address = (Address)manager.createQuery("Select a from Address a").getResultList().get(0);
                try {
                    address.internalSetStreet("Hastings");
                }
                finally {
                    manager.getTransaction().commit();
                    manager.close();
                }
                manager = this.createEntityManager();
                address = (Address)manager.find(Address.class, (Object)address.getId());
                if (address.getStreet().equals("Hastings")) {
                    this.throwError("Change tracking detected the change (not used?).");
                } else {
                    this.throwError("Change tracking did not detect the change (used?).");
                }
            }
        };
        test.setName("TestFieldAccessChangeTracking");
        return test;
    }

    public TestCase buildEmployeeChangeTrackingTest() {
        TestCase test = new TestCase(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void test() throws Exception {
                EntityManager manager = this.createEntityManager();
                manager.getTransaction().begin();
                Employee employee = (Employee)manager.createQuery("Select e from Employee e").getResultList().get(0);
                try {
                    Field field = Employee.class.getDeclaredField("lastName");
                    field.setAccessible(true);
                    field.set(employee, "Hastings");
                }
                finally {
                    manager.getTransaction().commit();
                    manager.close();
                }
                manager = this.createEntityManager();
                employee = (Employee)manager.getReference(Employee.class, (Object)employee.getId());
                if (employee.getLastName().equals("Hastings")) {
                    this.throwError("Change tracking detected the change (not used?).");
                } else {
                    this.throwError("Change tracking did not detect the change (used?).");
                }
            }
        };
        test.setName("TestEmployeeChangeTracking");
        return test;
    }

    public TestCase buildDateChangeTrackingTest() {
        TestCase test = new TestCase(){

            public void test() throws Exception {
                EntityManager manager = this.createEntityManager();
                manager.getTransaction().begin();
                Employee employee = (Employee)manager.createQuery("Select e from Employee e").getResultList().get(0);
                try {
                    employee.getPeriod().getStartDate().setDate(7);
                }
                finally {
                    manager.getTransaction().commit();
                    manager.close();
                }
                manager = this.createEntityManager();
                employee = (Employee)manager.getReference(Employee.class, (Object)employee.getId());
                manager.refresh((Object)employee);
                if (employee.getPeriod().getStartDate().getDate() == 7) {
                    this.throwError("Change tracking detected the change (not used?).");
                } else {
                    this.throwError("Change tracking did not detect the change (used?).");
                }
            }
        };
        test.setName("TestDateChangeTracking");
        return test;
    }
}

