/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.junit.Assert;

public class NamedNativeQueryJUnitTest
extends JUnitTestCase {
    protected String PUName = NamedNativeQueryJUnitTest.isOnServer() ? "MulitPU-1" : "default";

    public NamedNativeQueryJUnitTest() {
    }

    public NamedNativeQueryJUnitTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new NamedNativeQueryJUnitTest("testSetup"));
        return NamedNativeQueryJUnitTest.addNamedNativeQueryTests(suite);
    }

    public static Test addNamedNativeQueryTests(TestSuite suite) {
        suite.setName("NamedNativeQueryJUnitTest");
        suite.addTest((Test)new NamedNativeQueryJUnitTest("testNamedNativeQuery"));
        suite.addTest((Test)new NamedNativeQueryJUnitTest("selectNamedNativeQueryWithPositionalParameterTest"));
        suite.addTest((Test)new NamedNativeQueryJUnitTest("selectNativeQueryWithPositionalParameterTest"));
        return suite;
    }

    public void testSetup() {
        new AdvancedTableCreator().replaceTables((DatabaseSession)NamedNativeQueryJUnitTest.getServerSession((String)this.PUName));
        NamedNativeQueryJUnitTest.clearCache((String)this.PUName);
    }

    public void testNamedNativeQuery() {
        EntityManager em = NamedNativeQueryJUnitTest.createEntityManager((String)this.PUName);
        try {
            em.createNamedQuery("findAllSQLAddresses").getResultList();
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.closeEntityManager(em);
            }
        }
    }

    public void selectNamedNativeQueryWithPositionalParameterTest() {
        Query query;
        EntityManager em = NamedNativeQueryJUnitTest.createEntityManager((String)this.PUName);
        List results_QuestionMark_Number = null;
        List results_QuestionMark = null;
        String errorMsg = "";
        boolean shouldCompareResults = true;
        try {
            query = em.createNamedQuery("findAllSQLAddressesByCity_QuestionMark_Number");
            query.setParameter(1, (Object)"Ottawa");
            results_QuestionMark_Number = query.getResultList();
        }
        catch (Exception e) {
            errorMsg = errorMsg + "findAllSQLAddressesByCity_QuestionMark_Number: " + e.getMessage() + "\n";
            shouldCompareResults = false;
        }
        try {
            query = em.createNamedQuery("findAllSQLAddressesByCity_QuestionMark");
            query.setParameter(1, (Object)"Ottawa");
            results_QuestionMark = query.getResultList();
        }
        catch (Exception e) {
            errorMsg = errorMsg + "findAllSQLAddressesByCity_QuestionMark: " + e.getMessage() + "\n";
            shouldCompareResults = false;
        }
        if (shouldCompareResults && results_QuestionMark_Number.size() != results_QuestionMark.size()) {
            errorMsg = errorMsg + "findAllSQLAddressesByCity_QuestionMark_Number and findAllSQLAddressesByCity_QuestionMark produced non-equal results";
        }
        shouldCompareResults = true;
        try {
            query = em.createNamedQuery("findAllSQLAddressesByCityAndCountry_QuestionMark_Number");
            query.setParameter(1, (Object)"Ottawa");
            query.setParameter(2, (Object)"Canada");
            results_QuestionMark_Number = query.getResultList();
        }
        catch (Exception e) {
            errorMsg = errorMsg + "findAllSQLAddressesByCityAndCountry_QuestionMark_Number: " + e.getMessage() + "\n";
            shouldCompareResults = false;
        }
        try {
            query = em.createNamedQuery("findAllSQLAddressesByCityAndCountry_QuestionMark");
            query.setParameter(1, (Object)"Ottawa");
            query.setParameter(2, (Object)"Canada");
            results_QuestionMark = query.getResultList();
        }
        catch (Exception e) {
            errorMsg = errorMsg + "findAllSQLAddressesByCityAndCountry_QuestionMark: " + e.getMessage();
            shouldCompareResults = false;
        }
        if (shouldCompareResults && results_QuestionMark_Number.size() != results_QuestionMark.size()) {
            errorMsg = errorMsg + "findAllSQLAddressesByCityAndCountry_QuestionMark_Number and findAllSQLAddressesByCityAndCountry_QuestionMark produced non-equal results";
        }
        if (errorMsg.length() > 0) {
            Assert.fail((String)errorMsg);
        }
        this.closeEntityManager(em);
    }

    public void selectNativeQueryWithPositionalParameterTest() {
        Query query;
        EntityManager em = NamedNativeQueryJUnitTest.createEntityManager((String)this.PUName);
        List results_QuestionMark_Number = null;
        List results_QuestionMark = null;
        String errorMsg = "";
        boolean shouldCompareResults = true;
        try {
            query = em.createNativeQuery("select * from CMP3_ADDRESS where CITY=?1", Address.class);
            query.setParameter(1, (Object)"Ottawa");
            results_QuestionMark_Number = query.getResultList();
        }
        catch (Exception e) {
            errorMsg = errorMsg + "findAllSQLAddressesByCity_QuestionMark_Number: " + e.getMessage() + "\n";
            shouldCompareResults = false;
        }
        try {
            query = em.createNativeQuery("select * from CMP3_ADDRESS where CITY=?", Address.class);
            query.setParameter(1, (Object)"Ottawa");
            results_QuestionMark = query.getResultList();
        }
        catch (Exception e) {
            errorMsg = errorMsg + "findAllSQLAddressesByCity_QuestionMark: " + e.getMessage() + "\n";
            shouldCompareResults = false;
        }
        if (shouldCompareResults && results_QuestionMark_Number.size() != results_QuestionMark.size()) {
            errorMsg = errorMsg + "findAllSQLAddressesByCity_QuestionMark_Number and findAllSQLAddressesByCity_QuestionMark produced non-equal results";
        }
        shouldCompareResults = true;
        try {
            query = em.createNativeQuery("select * from CMP3_ADDRESS where CITY=?1 and COUNTRY=?2", Address.class);
            query.setParameter(1, (Object)"Ottawa");
            query.setParameter(2, (Object)"Canada");
            results_QuestionMark_Number = query.getResultList();
        }
        catch (Exception e) {
            errorMsg = errorMsg + "findAllSQLAddressesByCityAndCountry_QuestionMark_Number: " + e.getMessage() + "\n";
            shouldCompareResults = false;
        }
        try {
            query = em.createNativeQuery("select * from CMP3_ADDRESS where CITY=? and COUNTRY=?", Address.class);
            query.setParameter(1, (Object)"Ottawa");
            query.setParameter(2, (Object)"Canada");
            results_QuestionMark = query.getResultList();
        }
        catch (Exception e) {
            errorMsg = errorMsg + "findAllSQLAddressesByCityAndCountry_QuestionMark: " + e.getMessage();
            shouldCompareResults = false;
        }
        if (shouldCompareResults && results_QuestionMark_Number.size() != results_QuestionMark.size()) {
            errorMsg = errorMsg + "findAllSQLAddressesByCityAndCountry_QuestionMark_Number and findAllSQLAddressesByCityAndCountry_QuestionMark produced non-equal results";
        }
        if (errorMsg.length() > 0) {
            Assert.fail((String)errorMsg);
        }
        this.closeEntityManager(em);
    }
}

