/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.writing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;
import org.eclipse.persistence.testing.tests.performance.PerformanceTest;

public class UnitOfWorkNoChangesClientSessionEmployeeTest
extends PerformanceTest {
    protected Server server;
    protected Employee employee;

    public UnitOfWorkNoChangesClientSessionEmployeeTest() {
        this.setDescription("This tests the performance of unit of work with no changes.");
    }

    @Override
    public void setup() {
        this.server = this.getSession().getProject().createServerSession();
        this.server.login();
        Expression expression = new ExpressionBuilder().get("firstName").equal((Object)"Bob");
        this.employee = (Employee)this.getSession().readObject(Employee.class, expression);
    }

    @Override
    public void test() throws Exception {
        ClientSession client = this.server.acquireClientSession();
        UnitOfWork uow = client.acquireUnitOfWork();
        Employee employee = (Employee)uow.readObject((Object)this.employee);
        uow.commit();
        client.release();
    }

    @Override
    public void reset() {
        this.server.logout();
    }
}

