/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.onetoonejointable;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.TimesTenPlatform;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.DeleteObjectTest;
import org.eclipse.persistence.testing.framework.InsertObjectTest;
import org.eclipse.persistence.testing.framework.JoinedAttributeTestHelper;
import org.eclipse.persistence.testing.framework.ReadAllCallTest;
import org.eclipse.persistence.testing.framework.ReadAllCallWithOrderingTest;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectCallTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.UnitOfWorkBasicInsertObjectTest;
import org.eclipse.persistence.testing.framework.UnitOfWorkBasicUpdateObjectTest;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.onetoonejointable.Address;
import org.eclipse.persistence.testing.models.onetoonejointable.Child;
import org.eclipse.persistence.testing.models.onetoonejointable.Employee;
import org.eclipse.persistence.testing.models.onetoonejointable.EmployeePopulator;
import org.eclipse.persistence.testing.models.onetoonejointable.EmployeeSystem;
import org.eclipse.persistence.testing.models.onetoonejointable.LargeProject;
import org.eclipse.persistence.testing.models.onetoonejointable.Project;
import org.eclipse.persistence.testing.models.onetoonejointable.SmallProject;
import org.eclipse.persistence.testing.tests.expressions.ReadObjectExpressionTest;
import org.eclipse.persistence.testing.tests.writing.ComplexUpdateTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class OneToOneJoinTableEmployeeBasicTestModel
extends TestModel {
    public static junit.framework.TestSuite suite() {
        return new OneToOneJoinTableEmployeeBasicTestModel();
    }

    public OneToOneJoinTableEmployeeBasicTestModel() {
        this.setDescription("This model tests reading/writing/deleting using the employee demo.");
    }

    public OneToOneJoinTableEmployeeBasicTestModel(boolean isSRG) {
        this();
        this.isSRG = isSRG;
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new EmployeeSystem());
    }

    public void addTests() {
        this.addTest((Test)OneToOneJoinTableEmployeeBasicTestModel.getReadObjectTestSuite());
        this.addTest((Test)OneToOneJoinTableEmployeeBasicTestModel.getUpdateObjectTestSuite());
        this.addTest((Test)OneToOneJoinTableEmployeeBasicTestModel.getInsertObjectTestSuite());
        this.addTest((Test)OneToOneJoinTableEmployeeBasicTestModel.getUOWInsertObjectTestSuite());
        this.addTest((Test)OneToOneJoinTableEmployeeBasicTestModel.getDeleteObjectTestSuite());
        this.addTest((Test)OneToOneJoinTableEmployeeBasicTestModel.getReadAllTestSuite());
        this.addTest((Test)new ExpressionTestSuite());
    }

    public static TestSuite getDeleteObjectTestSuite() {
        TestSuite suite = OneToOneJoinTableEmployeeBasicTestModel.getSRGDeleteObjectTestSuite();
        return suite;
    }

    public static TestSuite getSRGDeleteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeDeleteObjectTestSuite");
        suite.setDescription("This suite tests the deletion of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0005")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }

    public static TestSuite getInsertObjectTestSuite() {
        TestSuite suite = OneToOneJoinTableEmployeeBasicTestModel.getSRGInsertObjectTestSuite();
        return suite;
    }

    public static TestSuite getSRGInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeInsertObjectTestSuite");
        suite.setDescription("This suite tests the insertion of each object in the employee demo.");
        EmployeePopulator system = new EmployeePopulator();
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample1()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample2()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample3()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample4()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample5()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicSmallProjectExample1()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicSmallProjectExample2()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicSmallProjectExample3()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicLargeProjectExample1()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicLargeProjectExample2()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicLargeProjectExample3()));
        return suite;
    }

    public static TestSuite getReadAllTestSuite() {
        TestSuite suite = OneToOneJoinTableEmployeeBasicTestModel.getSRGReadAllTestSuite();
        Expression orderBy = new ExpressionBuilder().get("firstName").ascending();
        SQLCall call = new SQLCall("SELECT t0.VERSION, t1.EMP_ID, t0.L_NAME, t0.F_NAME, t1.SALARY, t0.EMP_ID, t0.GENDER FROM OTOJT_EMPLOYEE t0, OTOJT_SALARY t1 WHERE t1.EMP_ID = t0.EMP_ID");
        suite.addTest((Test)new ReadAllCallWithOrderingTest(Employee.class, 12, (Call)call, orderBy));
        suite.addTest((Test)new JoinTest());
        suite.addTest((Test)new JoinTest_SelectByFirstName());
        suite.addTest((Test)new BatchReadingTest());
        suite.addTest((Test)new BatchReadingTest_SelectByFirstName());
        return suite;
    }

    public static TestSuite getSRGReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeReadAllTestSuite");
        suite.setDescription("This suite tests the reading of all the objects of each class in the employee demo.");
        suite.addTest((Test)new ReadAllTest(Employee.class, 12));
        suite.addTest((Test)new ReadAllTest(Project.class, 15));
        suite.addTest((Test)new ReadAllTest(LargeProject.class, 5));
        suite.addTest((Test)new ReadAllTest(SmallProject.class, 10));
        suite.addTest((Test)new ReadAllCallTest(Employee.class, 12, (Call)new SQLCall("SELECT  t0.VERSION, t1.EMP_ID, t0.L_NAME, t0.F_NAME, t1.SALARY, t0.EMP_ID, t0.GENDER FROM OTOJT_EMPLOYEE t0, OTOJT_SALARY t1 WHERE t1.EMP_ID = t0.EMP_ID")));
        return suite;
    }

    public static TestSuite getReadObjectTestSuite() {
        TestSuite suite = OneToOneJoinTableEmployeeBasicTestModel.getSRGReadObjectTestSuite();
        return suite;
    }

    public static TestSuite getSRGReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeReadObjectTestSuite");
        suite.setDescription("This suite test the reading of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0005")));
        Employee employee = (Employee)manager.getObject(employeeClass, "0001");
        suite.addTest((Test)new ReadObjectCallTest(employeeClass, (Call)new SQLCall("SELECT t0.VERSION, t1.EMP_ID, t0.L_NAME, t0.F_NAME, t1.SALARY, t0.EMP_ID, t0.GENDER FROM OTOJT_EMPLOYEE t0, OTOJT_SALARY t1 WHERE t1.EMP_ID = t0.EMP_ID AND t0.F_NAME = '" + employee.getFirstName() + "' AND t0.L_NAME = '" + employee.getLastName() + "'")));
        employee = (Employee)manager.getObject(employeeClass, "0002");
        suite.addTest((Test)new ReadObjectCallTest(employeeClass, (Call)new SQLCall("SELECT  t0.VERSION, t1.EMP_ID, t0.L_NAME, t0.F_NAME, t1.SALARY, t0.EMP_ID, t0.GENDER FROM OTOJT_EMPLOYEE t0, OTOJT_SALARY t1 WHERE t1.EMP_ID = t0.EMP_ID AND t0.F_NAME = '" + employee.getFirstName() + "' AND t0.L_NAME = '" + employee.getLastName() + "'")));
        employee = (Employee)manager.getObject(employeeClass, "0003");
        suite.addTest((Test)new ReadObjectCallTest(employeeClass, (Call)new SQLCall("SELECT  t0.VERSION, t1.EMP_ID, t0.L_NAME, t0.F_NAME, t1.SALARY, t0.EMP_ID, t0.GENDER FROM OTOJT_EMPLOYEE t0, OTOJT_SALARY t1 WHERE t1.EMP_ID = t0.EMP_ID AND t0.F_NAME = '" + employee.getFirstName() + "' AND t0.L_NAME = '" + employee.getLastName() + "'")));
        Project project = (Project)manager.getObject(largeProjectClass, "0001");
        ReadObjectTest test = new ReadObjectTest((Object)project);
        test.setQuery(new ReadObjectQuery(Project.class, new ExpressionBuilder().get("id").equal((Object)project.getId())));
        suite.addTest((Test)test);
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }

    public static TestSuite getUpdateObjectTestSuite() {
        TestSuite suite = OneToOneJoinTableEmployeeBasicTestModel.getSRGUpdateObjectTestSuite();
        suite.addTest((Test)new ManyToManyReadOnlyMappingUpdateTest());
        suite.addTest((Test)new AddRemoveTest());
        return suite;
    }

    public static TestSuite getSRGUpdateObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeUpdateObjectTestSuite");
        suite.setDescription("This suite tests the updating of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "0005")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }

    public static TestSuite getUOWInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeUOWBasicInsertObjectTestSuite");
        suite.setDescription("This suite tests the insertion of each object in the employee demo using uow.");
        EmployeePopulator populator = new EmployeePopulator();
        suite.addTest((Test)new UnitOfWorkBasicInsertObjectTest((Object)populator.basicEmployeeExample1()));
        suite.addTest((Test)new UnitOfWorkBasicInsertObjectTest((Object)populator.basicEmployeeExample2()));
        suite.addTest((Test)new UnitOfWorkBasicInsertObjectTest((Object)populator.basicEmployeeExample3()));
        suite.addTest((Test)new UnitOfWorkBasicInsertObjectTest((Object)populator.basicEmployeeExample4()));
        suite.addTest((Test)new UnitOfWorkBasicInsertObjectTest((Object)populator.basicEmployeeExample5()));
        return suite;
    }

    static class ReadAllExpressionTest
    extends org.eclipse.persistence.testing.tests.expressions.ReadAllExpressionTest {
        public ReadAllExpressionTest(Class referenceClass, int originalObjectsSize) {
            super(referenceClass, originalObjectsSize);
        }

        @Override
        protected void setupBatchAttributes() {
            this.getQuery().addBatchReadAttribute("children");
            this.getQuery().addBatchReadAttribute("address");
            this.getQuery().addBatchReadAttribute("responsibilitiesList");
            this.getQuery().addBatchReadAttribute("projects");
        }

        @Override
        protected void testBatchAttributes() {
            Vector result = (Vector)this.objectsFromDatabase;
            List<Child> children = ((Employee)result.elementAt(0)).getChildren();
            ((Employee)result.elementAt(0)).getResponsibilitiesList().size();
            ((Employee)result.elementAt(0)).getProjects().size();
            if (children == null || children.size() == 0) {
                throw new TestErrorException("The original query was corrupted when made part of a batch query.");
            }
            if (((Employee)result.elementAt(0)).getAddress() == null) {
                throw new TestErrorException("The original query was corrupted when made part of a batch query.");
            }
        }
    }

    static class ProjectDeleteTest
    extends DeleteObjectTest {
        public ProjectDeleteTest(Object originalObject) {
            super(originalObject);
        }

        protected void setup() {
            super.setup();
            this.getSession().executeNonSelectingCall((Call)new SQLCall("delete from OTOJT_PROJ_EMP where PROJ_ID = " + ((Project)this.getOriginalObject()).getId()));
        }
    }

    static class EmployeeDeleteTest
    extends DeleteObjectTest {
        public EmployeeDeleteTest(Object originalObject) {
            super(originalObject);
        }

        protected void setup() {
            super.setup();
            this.getSession().executeNonSelectingCall((Call)new SQLCall("delete from OTOJT_PROJ_LEADER where EMP_ID = " + ((Employee)this.getOriginalObject()).getId()));
            this.getSession().executeNonSelectingCall((Call)new SQLCall("delete from OTOJT_EMP_MANAGER where MANAGER_ID = " + ((Employee)this.getOriginalObject()).getId()));
        }
    }

    static class ExpressionTestSuite
    extends TestSuite {
        public ExpressionTestSuite() {
            this.setName("ExpressionTestSuite");
            this.setDescription("This suite tests expressions.");
        }

        public void addTests() {
            this.addMultipleAndsTest();
            this.addMultipleAndsTest2();
            this.addMultipleAndsTest3();
            this.addMultipleAndsTest4();
            this.addMultipleAndsTest5();
            this.addMultipleAndsTest6();
            this.addEqualUnneccessaryJoinTest();
            this.addManagersOfWealthyMarriedAtWorkEmployeesTest();
            this.addOneToManyJoin2WithBatchReadTest();
        }

        private void addMultipleAndsTest() {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("address").equal((Object)new Address()).and(builder.get("lastName").notEqual((Object)"foopoyp"));
            ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
            test.setExpression(expression);
            test.setName("MultipleAndsExpressionTest");
            test.setDescription("Test object equality with object will null primary key");
            this.addTest((Test)test);
        }

        private void addMultipleAndsTest2() {
            ExpressionBuilder builder = new ExpressionBuilder();
            Address a = new Address();
            a.setId(new BigDecimal(123456));
            Expression expression = builder.get("address").equal((Object)a).and(builder.get("id").greaterThan(800));
            ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
            test.setQuery(new ReadAllQuery(Employee.class, expression));
            test.getQuery().addAscendingOrdering("id");
            test.setExpression(expression);
            test.setName("MultipleAndsExpressionTest2");
            test.setDescription("Test multiple ands with object equality");
            this.addTest((Test)test);
        }

        private void addMultipleAndsTest3() {
            ExpressionBuilder builder = new ExpressionBuilder();
            Address a = new Address();
            a.setId(new BigDecimal(123456));
            Expression expression = builder.get("id").greaterThan(800).and(builder.get("address").equal((Object)a));
            ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
            test.setQuery(new ReadAllQuery(Employee.class, expression));
            test.getQuery().addAscendingOrdering("id");
            test.setExpression(expression);
            test.setName("MultipleAndsExpressionTest3");
            test.setDescription("Test multiple ands with object equality");
            this.addTest((Test)test);
        }

        private void addMultipleAndsTest4() {
            ExpressionBuilder builder = new ExpressionBuilder();
            Address address1 = new Address();
            address1.setId(new BigDecimal(999999876));
            Address address2 = new Address();
            address2.setId(new BigDecimal(999999877));
            Expression expression1 = builder.get("address").equal((Object)address1).or(builder.get("lastName").equal((Object)"Smith"));
            Expression expression2 = builder.get("address").equal((Object)address2).or(builder.get("firstName").equal((Object)"Bob"));
            ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
            test.setExpression(expression1.and(expression2));
            test.setName("MultipleAndsExpressionTest4");
            test.setDescription("Test multiple booleans with supression in each branch");
            this.addTest((Test)test);
        }

        private void addMultipleAndsTest5() {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("address").equal(null).and(builder.get("lastName").notEqual((Object)"foopoyp"));
            ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
            test.setExpression(expression);
            test.setName("MultipleAndsExpressionTest5");
            test.setDescription("Test multiple ands expression");
            this.addTest((Test)test);
        }

        private void addMultipleAndsTest6() {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("address").isNull().and(builder.get("lastName").notEqual((Object)"foopoyp"));
            ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
            test.setExpression(expression);
            test.setName("MultipleAndsExpressionTest6");
            test.setDescription("Test multiple ands expression");
            this.addTest((Test)test);
        }

        private void addEqualUnneccessaryJoinTest() {
            Employee employee = (Employee)PopulationManager.getDefaultManager().getObject(new Employee().getClass(), "0008");
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("firstName").equal((Object)"Fred").or(builder.get("manager").notEqual(builder.get("manager")));
            ReadObjectExpressionTest test = new ReadObjectExpressionTest(employee, expression);
            test.setName("EqualUnneccessaryJoinTest");
            test.setDescription("Test = expression does not create an extra unneccessary join");
            this.addTest((Test)test);
        }

        private void addManagersOfWealthyMarriedAtWorkEmployeesTest() {
            ExpressionBuilder builder = new ExpressionBuilder();
            ExpressionBuilder innerBuilder = new ExpressionBuilder(Employee.class);
            ExpressionBuilder innerSpouses = new ExpressionBuilder(Employee.class);
            Expression innerExpression = innerBuilder.get("manager").equal((Expression)builder);
            innerExpression = innerExpression.and(innerBuilder.get("lastName").equal(innerSpouses.get("lastName")));
            innerExpression = innerExpression.and(innerBuilder.get("gender").notEqual(innerSpouses.get("gender")));
            ReportQuery subquery = new ReportQuery(Employee.class, innerBuilder);
            subquery.addAverage("family income", ExpressionMath.add((Expression)innerBuilder.get("salary"), (Object)innerSpouses.get("salary")));
            subquery.setSelectionCriteria(innerExpression);
            Expression expression = builder.subQuery(subquery).equal(140000);
            ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 2);
            test.setExpression(expression);
            test.testBatchAttributesOnEmployee();
            test.setName("ManagersOfWealthyMarriedAtWorkEmployeesTest");
            test.setDescription("Test executing query where subselect is a ReportQuery with ReportItems from multiple builders.  Does not tests batch reading.  For 2612185.");
            test.addUnsupportedPlatform(TimesTenPlatform.class);
            this.addTest((Test)test);
        }

        private void addOneToManyJoin2WithBatchReadTest() {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.anyOf("managedEmployees").get("lastName").like("Sa%");
            Expression exp2 = builder.anyOf("managedEmployees").get("firstName").like("B%");
            expression = expression.and(exp2);
            ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
            test.setExpression(expression);
            test.testBatchAttributesOnEmployee();
            test.setName("OneToManyJoin2WithBatchReadTest");
            test.setDescription("Test a join across a 1:many relation with 2 anyOf clauses, and test again as part of a batch read.");
            this.addTest((Test)test);
        }
    }

    static class BatchReadingTest_SelectByFirstName
    extends BatchReadingTest {
        public BatchReadingTest_SelectByFirstName() {
            this.setName("EmployeeBatchReadingTest - select by first name");
        }

        @Override
        void setSelectionCriteria(ReadAllQuery query) {
            query.setSelectionCriteria(query.getExpressionBuilder().get("firstName").like("J%"));
        }
    }

    static class BatchReadingTest
    extends TestCase {
        boolean shouldPrintDebugOutput = false;

        public BatchReadingTest() {
            this.setName("EmployeeBatchReadingTest - no selection criteria");
            this.setDescription("Tests batch reading of Employees with batch expression address");
        }

        void setSelectionCriteria(ReadAllQuery query) {
        }

        public void test() {
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            ReadAllQuery query = new ReadAllQuery(Employee.class);
            this.setSelectionCriteria(query);
            ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
            Expression addressExp = query.getExpressionBuilder().get("address");
            query.addBatchReadAttribute(addressExp);
            List employees = (List)this.getSession().executeQuery((DatabaseQuery)query);
            if (employees.isEmpty()) {
                throw new TestProblemException("No Employees were read");
            }
            this.printDebug("Trigger batch reading results");
            boolean isConnected = true;
            for (int i = 0; i < employees.size(); ++i) {
                Address address = ((Employee)employees.get(i)).getAddress();
                if (!isConnected) continue;
                ((AbstractSession)this.getSession()).getAccessor().closeConnection();
                isConnected = false;
            }
            if (!isConnected) {
                ((AbstractSession)this.getSession()).getAccessor().reestablishConnection((AbstractSession)this.getSession());
            }
            this.printDebug("");
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            List controlEmployees = (List)this.getSession().executeQuery((DatabaseQuery)controlQuery);
            this.printDebug("Trigger control results");
            for (int i = 0; i < controlEmployees.size(); ++i) {
                Address address = ((Employee)controlEmployees.get(i)).getAddress();
            }
            String errorMsg = JoinedAttributeTestHelper.compareCollections((Collection)employees, (Collection)controlEmployees, (ClassDescriptor)this.getSession().getClassDescriptor(Employee.class), (AbstractSession)((AbstractSession)this.getSession()));
            if (errorMsg.length() > 0) {
                throw new TestErrorException(errorMsg);
            }
        }

        void printDebug(String msg) {
            if (this.shouldPrintDebugOutput) {
                System.out.println(msg);
            }
        }
    }

    static class JoinTest_SelectByFirstName
    extends JoinTest {
        public JoinTest_SelectByFirstName() {
            this.setName("JoinTest - select by first name");
        }

        @Override
        void setSelectionCriteria(ReadAllQuery query) {
            query.setSelectionCriteria(query.getExpressionBuilder().get("firstName").like("J%"));
        }
    }

    static class JoinTest
    extends TestCase {
        public JoinTest() {
            this.setName("JoinTest - no selection criteria");
            this.setDescription("Tests reading of Employees with join expressions.");
        }

        void setSelectionCriteria(ReadAllQuery query) {
        }

        public void test() {
            ReadAllQuery query = new ReadAllQuery();
            query.setReferenceClass(Employee.class);
            this.setSelectionCriteria(query);
            ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
            Expression address = query.getExpressionBuilder().getAllowingNull("address");
            query.addJoinedAttribute(address);
            Expression projectLed = query.getExpressionBuilder().getAllowingNull("projectLed");
            query.addJoinedAttribute(projectLed);
            Expression manager = query.getExpressionBuilder().getAllowingNull("manager");
            query.addJoinedAttribute(manager);
            Expression managerProjectLed = manager.getAllowingNull("projectLed");
            query.addJoinedAttribute(managerProjectLed);
            String errorMsg = JoinedAttributeTestHelper.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query, (AbstractSession)((AbstractSession)this.getSession()));
            if (errorMsg.length() > 0) {
                throw new TestErrorException(errorMsg);
            }
        }
    }

    static class AddRemoveTest
    extends TestCase {
        Employee employee;
        Address address1;
        Address address2;
        Project project1;
        Project project2;
        boolean useAddress;
        boolean useProjects;

        AddRemoveTest() {
            this.setName("AddRemoveTest");
        }

        public void setup() {
            this.useAddress = true;
            this.useProjects = true;
        }

        public void test() {
            Project project1Clone;
            Address address1Clone;
            this.employee = new Employee();
            this.employee.setFirstName("AddRemoveTest");
            if (this.useAddress) {
                this.address1 = new Address();
                this.address1.setCity("city1");
            }
            if (this.useProjects) {
                this.project1 = new SmallProject("project1");
            }
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            Employee employeeClone = (Employee)uow.registerObject((Object)this.employee);
            if (this.useAddress) {
                address1Clone = (Address)uow.registerObject((Object)this.address1);
                employeeClone.setAddress(address1Clone);
            }
            if (this.useProjects) {
                project1Clone = (Project)uow.registerObject((Object)this.project1);
                employeeClone.addProject(project1Clone);
            }
            uow.commit();
            uow = this.getSession().acquireUnitOfWork();
            employeeClone = (Employee)uow.registerObject((Object)this.employee);
            if (this.useAddress) {
                employeeClone.setAddress(null);
            }
            if (this.useProjects) {
                employeeClone.removeProject(employeeClone.getProjects().get(0));
            }
            uow.commit();
            uow = this.getSession().acquireUnitOfWork();
            employeeClone = (Employee)uow.registerObject((Object)this.employee);
            if (this.useAddress) {
                address1Clone = (Address)uow.registerObject((Object)this.address1);
                employeeClone.setAddress(address1Clone);
            }
            if (this.useProjects) {
                project1Clone = (Project)uow.registerObject((Object)this.project1);
                employeeClone.addProject(project1Clone);
            }
            uow.commit();
            uow = this.getSession().acquireUnitOfWork();
            employeeClone = (Employee)uow.registerObject((Object)this.employee);
            if (this.useAddress) {
                this.address2 = new Address();
                this.address2.setCity("city2");
                Address address2Clone = (Address)uow.registerObject((Object)this.address2);
                employeeClone.setAddress(address2Clone);
            }
            if (this.useProjects) {
                this.project2 = new LargeProject("project2");
                Project project2Clone = (Project)uow.registerObject((Object)this.project2);
                employeeClone.addProject(project2Clone);
            }
            uow.commit();
            uow = this.getSession().acquireUnitOfWork();
            uow.deleteObject((Object)this.employee);
            uow.commit();
            this.employee = null;
        }

        public void reset() {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            if (this.employee != null) {
                uow.deleteObject((Object)this.employee);
            }
            if (this.useAddress) {
                if (this.address1 != null) {
                    uow.deleteObject((Object)this.address1);
                }
                if (this.address2 != null) {
                    uow.deleteObject((Object)this.address2);
                }
            }
            if (this.useProjects) {
                if (this.project1 != null) {
                    uow.deleteObject((Object)this.project1);
                }
                if (this.project2 != null) {
                    uow.deleteObject((Object)this.project2);
                }
            }
            uow.commit();
        }
    }

    static class ManyToManyReadOnlyMappingUpdateTest
    extends ComplexUpdateTest {
        ManyToManyReadOnlyMappingUpdateTest() {
            this.usesUnitOfWork = true;
            this.setName("ManyToManyReadOnlyMappingUpdateTest");
        }

        @Override
        public void setup() {
            Vector projects = this.getSession().readAllObjects(Project.class);
            for (int i = 0; i < projects.size(); ++i) {
                if (((Project)projects.get(i)).getEmployees().size() <= 0) continue;
                this.originalObject = projects.get(i);
                break;
            }
            super.setup();
        }

        @Override
        protected void changeObject() {
            Project project = (Project)this.workingCopy;
            int size = project.getEmployees().size();
            if (size == 0) {
                throw new TestProblemException("Project was supposed to have Employees, but doesn't have any.");
            }
            for (int i = size - 1; 0 <= i; --i) {
                project.removeEmployee(project.getEmployees().get(i));
            }
        }
    }
}

