/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.jaxb;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import jakarta.xml.bind.JAXBContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.helper.IdentityWeakHashMap;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOCopyHelper;
import org.eclipse.persistence.sdo.helper.SDODataHelper;
import org.eclipse.persistence.sdo.helper.SDOEqualityHelper;
import org.eclipse.persistence.sdo.helper.SDOHelperContext;
import org.eclipse.persistence.sdo.helper.delegates.SDOTypeHelperDelegate;
import org.eclipse.persistence.sdo.helper.delegates.SDOXSDHelperDelegate;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBDataFactory;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBValueStore;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBXMLHelper;

public class JAXBHelperContext
extends SDOHelperContext {
    private org.eclipse.persistence.jaxb.JAXBContext jaxbContext;
    private Map<Object, SDODataObject> wrapperDataObjects = new IdentityWeakHashMap<Object, SDODataObject>();

    public JAXBHelperContext(JAXBContext aJAXBContext) {
        this(aJAXBContext, Thread.currentThread().getContextClassLoader());
    }

    public JAXBHelperContext(JAXBContext aJAXBContext, ClassLoader aClassLoader) {
        super(aClassLoader);
        this.jaxbContext = (org.eclipse.persistence.jaxb.JAXBContext)aJAXBContext;
    }

    @Override
    protected void initialize(ClassLoader aClassLoader) {
        this.copyHelper = new SDOCopyHelper(this);
        this.dataFactory = new JAXBDataFactory(this);
        this.dataHelper = new SDODataHelper(this);
        this.equalityHelper = new SDOEqualityHelper(this);
        this.xmlHelper = new JAXBXMLHelper(this, aClassLoader);
        this.typeHelper = new SDOTypeHelperDelegate(this);
        this.xsdHelper = new SDOXSDHelperDelegate(this);
    }

    public JAXBContext getJAXBContext() {
        return this.jaxbContext;
    }

    public Type getType(Class entityClass) {
        Type wrapperType;
        if (null == entityClass) {
            return null;
        }
        XMLDescriptor entityDescriptor = null;
        try {
            entityDescriptor = (XMLDescriptor)this.jaxbContext.getXMLContext().getSession(entityClass).getDescriptor(entityClass);
        }
        catch (Exception e) {
            return null;
        }
        XMLSchemaReference schemaReference = entityDescriptor.getSchemaReference();
        if (null == schemaReference) {
            throw SDOException.sdoJaxbNoSchemaReference(entityClass);
        }
        QName qName = schemaReference.getSchemaContextAsQName(entityDescriptor.getNamespaceResolver());
        if (null == qName) {
            throw SDOException.sdoJaxbNoSchemaContext(entityClass);
        }
        if (entityDescriptor.getSchemaReference().getType() == 1) {
            wrapperType = this.getTypeHelper().getType(qName.getNamespaceURI(), qName.getLocalPart());
        } else {
            Property property = this.getXSDHelper().getGlobalProperty(qName.getNamespaceURI(), qName.getLocalPart(), true);
            wrapperType = property.getType();
        }
        if (null == wrapperType) {
            throw SDOException.sdoJaxbNoTypeForClassBySchemaContext(entityClass, qName);
        }
        return wrapperType;
    }

    public Class getClass(Type type) {
        if (null == type) {
            return null;
        }
        return this.getObjectDescriptor((SDOType)type).getJavaClass();
    }

    public DataObject wrap(Object entity) {
        if (null == entity) {
            return null;
        }
        SDODataObject wrapperDO = this.wrapperDataObjects.get(entity);
        if (null != wrapperDO) {
            return wrapperDO;
        }
        Type wrapperType = this.getType(entity.getClass());
        if (null == wrapperType) {
            throw SDOException.sdoJaxbNoTypeForClass(entity.getClass());
        }
        wrapperDO = (SDODataObject)this.getDataFactory().create(wrapperType);
        JAXBValueStore jaxbValueStore = new JAXBValueStore(this, entity);
        wrapperDO._setCurrentValueStore(jaxbValueStore);
        jaxbValueStore.initialize(wrapperDO);
        this.wrapperDataObjects.put(entity, wrapperDO);
        return wrapperDO;
    }

    DataObject wrap(Object entity, Property containmentProperty, DataObject container) {
        SDODataObject sdoDataObject = (SDODataObject)this.wrap(entity);
        if (null == container) {
            sdoDataObject._setContainmentPropertyName(null);
        } else {
            sdoDataObject._setContainmentPropertyName(containmentProperty.getName());
        }
        sdoDataObject._setContainer(container);
        return sdoDataObject;
    }

    public List<DataObject> wrap(Collection<Object> entities) {
        return this.wrap(entities, null, null);
    }

    List<DataObject> wrap(Collection<Object> entities, Property containmentProperty, DataObject container) {
        if (null == entities) {
            return new ArrayList<DataObject>(0);
        }
        ArrayList<DataObject> dataObjects = new ArrayList<DataObject>(entities.size());
        for (Object entity : entities) {
            dataObjects.add(this.wrap(entity, containmentProperty, container));
        }
        return dataObjects;
    }

    public Object unwrap(DataObject dataObject) {
        try {
            if (null == dataObject) {
                return null;
            }
            SDODataObject sdoDataObject = (SDODataObject)dataObject;
            JAXBValueStore jpaValueStore = (JAXBValueStore)sdoDataObject._getCurrentValueStore();
            return jpaValueStore.getEntity();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public List<Object> unwrap(Collection<DataObject> dataObjects) {
        if (null == dataObjects) {
            return new ArrayList<Object>(0);
        }
        ArrayList<Object> entities = new ArrayList<Object>(dataObjects.size());
        for (DataObject dataObject : dataObjects) {
            entities.add(this.unwrap(dataObject));
        }
        return entities;
    }

    void putWrapperDataObject(Object anObject, SDODataObject aDataObject) {
        this.wrapperDataObjects.put(anObject, aDataObject);
    }

    XMLDescriptor getObjectDescriptor(SDOType sdoType) {
        QName xsdQName = sdoType.getXsdType();
        if (null == xsdQName) {
            xsdQName = sdoType.getQName();
        }
        XPathFragment xPathFragment = new XPathFragment(xsdQName.getLocalPart());
        xPathFragment.setNamespaceURI(xsdQName.getNamespaceURI());
        XMLDescriptor xmlDescriptor = this.jaxbContext.getXMLContext().getDescriptorByGlobalType(xPathFragment);
        if (null == xmlDescriptor && null == (xmlDescriptor = this.jaxbContext.getXMLContext().getDescriptor(xsdQName))) {
            throw SDOException.sdoJaxbNoDescriptorForType(sdoType.getQName(), xsdQName);
        }
        return xmlDescriptor;
    }
}

