/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.table;

import java.util.List;
import oracle.kv.table.FieldRange;
import oracle.kv.table.Table;

public class MultiRowOptions {
    private FieldRange fieldRange;
    private List<Table> ancestors;
    private List<Table> children;

    public MultiRowOptions(FieldRange fieldRange, List<Table> ancestors, List<Table> children) {
        this.fieldRange = fieldRange;
        this.ancestors = ancestors;
        this.children = children;
    }

    public MultiRowOptions(FieldRange fieldRange) {
        this.fieldRange = fieldRange;
        this.ancestors = null;
        this.children = null;
    }

    public FieldRange getFieldRange() {
        return this.fieldRange;
    }

    public List<Table> getIncludedParentTables() {
        if (this.ancestors != null && !this.ancestors.isEmpty()) {
            return this.ancestors;
        }
        return null;
    }

    public List<Table> getIncludedChildTables() {
        if (this.children != null && !this.children.isEmpty()) {
            return this.children;
        }
        return null;
    }

    public MultiRowOptions setFieldRange(FieldRange newFieldRange) {
        this.fieldRange = newFieldRange;
        return this;
    }

    public MultiRowOptions setIncludedParentTables(List<Table> newAncestors) {
        this.ancestors = newAncestors;
        return this;
    }

    public MultiRowOptions setIncludedChildTables(List<Table> newChildren) {
        this.children = newChildren;
        return this;
    }
}

