/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.Partition;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.Topology;

public class TopologyUtil {
    public static Map<RepGroupId, List<PartitionId>> getRGIdPartMap(Topology topology) {
        HashMap<RepGroupId, List<PartitionId>> map = new HashMap<RepGroupId, List<PartitionId>>();
        for (Partition p : topology.getPartitionMap().getAll()) {
            ArrayList<PartitionId> list = (ArrayList<PartitionId>)map.get(p.getRepGroupId());
            if (list == null) {
                list = new ArrayList<PartitionId>();
                map.put(p.getRepGroupId(), list);
            }
            list.add((PartitionId)p.getResourceId());
        }
        return map;
    }

    public static int getNumRepNodesForRead(Topology topology, int[] readZoneIds) {
        ArrayList<Integer> readZoneIdsLst;
        if (readZoneIds != null) {
            readZoneIdsLst = new ArrayList<Integer>(readZoneIds.length);
            for (int id : readZoneIds) {
                readZoneIdsLst.add(id);
            }
        } else {
            readZoneIdsLst = null;
        }
        Collection datacenters = topology.getDatacenterMap().getAll();
        int num = 0;
        for (Datacenter dc : datacenters) {
            int dcId;
            if (readZoneIdsLst != null && !readZoneIdsLst.contains(dcId = ((DatacenterId)dc.getResourceId()).getDatacenterId())) continue;
            num += dc.getRepFactor();
        }
        int nShards = topology.getRepGroupMap().size();
        return num * nShards;
    }
}

