/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.persist.model.Persistent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import oracle.kv.impl.api.ClientId;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.ArbNodeId;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.FastExternalizable;

@Persistent
public abstract class ResourceId
implements Serializable,
FastExternalizable {
    private static final long serialVersionUID = 1L;

    protected static int parseForInt(String idPrefix, String val) {
        try {
            int id = Integer.parseInt(val);
            return id;
        }
        catch (NumberFormatException e) {
            String arg = val.toLowerCase();
            if (arg.startsWith(idPrefix)) {
                try {
                    int id = Integer.parseInt(val.substring(idPrefix.length()));
                    if (id > 0) {
                        return id;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException(val + " is not a valid id. It must follow the format " + idPrefix + "X");
        }
    }

    protected static int parseForInt(String[] idPrefixes, String val) {
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException numberFormatException) {
            String arg = val.toLowerCase();
            for (String idPrefix : idPrefixes) {
                if (!arg.startsWith(idPrefix)) continue;
                try {
                    int id = Integer.parseInt(val.substring(idPrefix.length()));
                    if (id <= 0) continue;
                    return id;
                }
                catch (NumberFormatException e2) {
                    break;
                }
            }
            throw new IllegalArgumentException(val + " is not a valid id. It must have the form <prefix>X where <prefix> is one of: " + Arrays.toString(idPrefixes));
        }
    }

    protected ResourceId() {
    }

    public ResourceId(DataInput in, short serialVersion) {
    }

    public static ResourceId readFastExternal(DataInput in, short serialVersion) throws IOException {
        ResourceType type = ResourceType.readFastExternal(in, serialVersion);
        return type.readResourceId(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        this.getType().writeFastExternal(out, serialVersion);
    }

    public abstract ResourceType getType();

    public abstract Topology.Component<?> getComponent(Topology var1);

    protected abstract Topology.Component<?> readComponent(Topology var1, DataInput var2, short var3) throws IOException;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract ResourceId clone();

    public String getFullName() {
        throw new UnsupportedOperationException("Not supported for " + this.getType());
    }

    public static enum ResourceType implements FastExternalizable
    {
        DATACENTER(0){

            @Override
            ResourceId readResourceId(DataInput in, short serialVersion) throws IOException {
                return new DatacenterId(in, serialVersion);
            }

            @Override
            public boolean isDatacenter() {
                return true;
            }
        }
        ,
        STORAGE_NODE(1){

            @Override
            ResourceId readResourceId(DataInput in, short serialVersion) throws IOException {
                return new StorageNodeId(in, serialVersion);
            }

            @Override
            public boolean isStorageNode() {
                return true;
            }
        }
        ,
        REP_GROUP(2){

            @Override
            ResourceId readResourceId(DataInput in, short serialVersion) throws IOException {
                return new RepGroupId(in, serialVersion);
            }

            @Override
            public boolean isRepGroup() {
                return true;
            }
        }
        ,
        REP_NODE(3){

            @Override
            ResourceId readResourceId(DataInput in, short serialVersion) throws IOException {
                return new RepNodeId(in, serialVersion);
            }

            @Override
            public boolean isRepNode() {
                return true;
            }
        }
        ,
        PARTITION(4){

            @Override
            ResourceId readResourceId(DataInput in, short serialVersion) throws IOException {
                return new PartitionId(in, serialVersion);
            }

            @Override
            public boolean isPartition() {
                return true;
            }
        }
        ,
        ADMIN(5){

            @Override
            ResourceId readResourceId(DataInput in, short serialVersion) throws IOException {
                return new AdminId(in, serialVersion);
            }

            @Override
            public boolean isAdmin() {
                return true;
            }
        }
        ,
        CLIENT(6){

            @Override
            ResourceId readResourceId(DataInput in, short serialVersion) throws IOException {
                return new ClientId(in, serialVersion);
            }

            @Override
            public boolean isClient() {
                return true;
            }
        }
        ,
        ARB_NODE(7){

            @Override
            ResourceId readResourceId(DataInput in, short serialVersion) throws IOException {
                return new ArbNodeId(in, serialVersion);
            }

            @Override
            public boolean isArbNode() {
                return true;
            }
        };

        private static final ResourceType[] VALUES;

        private ResourceType(int ordinal) {
            if (ordinal != this.ordinal()) {
                throw new IllegalArgumentException("Wrong ordinal");
            }
        }

        abstract ResourceId readResourceId(DataInput var1, short var2) throws IOException;

        static ResourceType readFastExternal(DataInput in, short serialVersion) throws IOException {
            int ordinal = in.readUnsignedByte();
            try {
                return VALUES[ordinal];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Unknown resource type: " + ordinal);
            }
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            out.writeByte(this.ordinal());
        }

        public boolean isDatacenter() {
            return false;
        }

        public boolean isStorageNode() {
            return false;
        }

        public boolean isRepGroup() {
            return false;
        }

        public boolean isRepNode() {
            return false;
        }

        public boolean isPartition() {
            return false;
        }

        public boolean isAdmin() {
            return false;
        }

        public boolean isArbNode() {
            return false;
        }

        public boolean isClient() {
            return false;
        }

        static {
            VALUES = ResourceType.values();
        }
    }
}

