/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import oracle.kv.impl.security.login.LoginSession;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.SerializationUtil;

public final class SessionId
implements Serializable,
FastExternalizable {
    public static final int SESSION_ID_MAX_SIZE = 127;
    private static final long serialVersionUID = 1L;
    public static final int HAS_ALLOCATOR = 1;
    private IdScope idValueScope;
    private byte[] idValue;
    private ResourceId allocator;

    public SessionId(byte[] idValue) {
        if (idValue.length > 127) {
            throw new IllegalArgumentException("sessionId length exceeds limit");
        }
        this.idValueScope = IdScope.PERSISTENT;
        this.idValue = Arrays.copyOf(idValue, idValue.length);
    }

    public SessionId(byte[] idValue, IdScope idValueScope, ResourceId allocator) {
        if (idValueScope == IdScope.PERSISTENT) {
            throw new IllegalArgumentException("invalid scope");
        }
        if (idValue.length > 127) {
            throw new IllegalArgumentException("sessionId length exceeds limit");
        }
        this.idValueScope = idValueScope;
        this.idValue = Arrays.copyOf(idValue, idValue.length);
        this.allocator = allocator;
    }

    public SessionId(DataInput in, short serialVersion) throws IOException {
        byte flagByte = in.readByte();
        this.idValueScope = IdScope.readFastExternal(in, serialVersion);
        if (serialVersion >= 14) {
            this.idValue = SerializationUtil.readNonNullByteArray(in);
        } else {
            byte valueLen = in.readByte();
            this.idValue = new byte[valueLen];
            in.readFully(this.idValue, 0, valueLen);
        }
        if ((flagByte & 1) != 0) {
            this.allocator = ResourceId.readFastExternal(in, serialVersion);
        }
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        int flagByte = 0;
        if (this.allocator != null) {
            flagByte |= 1;
        }
        out.writeByte(flagByte);
        this.idValueScope.writeFastExternal(out, serialVersion);
        if (serialVersion >= 14) {
            SerializationUtil.writeNonNullByteArray(out, this.idValue);
        } else {
            out.writeByte(this.idValue.length);
            out.write(this.idValue, 0, this.idValue.length);
        }
        if (this.allocator != null) {
            this.allocator.writeFastExternal(out, serialVersion);
        }
    }

    public byte[] getIdValue() {
        return this.idValue;
    }

    public IdScope getIdValueScope() {
        return this.idValueScope;
    }

    public ResourceId getAllocator() {
        return this.allocator;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != SessionId.class) {
            return false;
        }
        SessionId otherToken = (SessionId)other;
        return this.idValueScope == otherToken.idValueScope && Arrays.equals(this.idValue, otherToken.idValue) && (this.allocator == null && otherToken.allocator == null || this.allocator != null && this.allocator.equals(otherToken.allocator));
    }

    public int hashCode() {
        return Arrays.hashCode(this.idValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SessionId: scope=");
        sb.append(this.idValueScope);
        sb.append(", hashId()=");
        sb.append(this.hashId());
        sb.append(", allocator=");
        sb.append(this.allocator);
        return sb.toString();
    }

    public int hashId() {
        return LoginSession.Id.hashId((byte[])this.idValue);
    }

    public static enum IdScope implements FastExternalizable
    {
        PERSISTENT(0),
        LOCAL(1),
        STORE(2);

        private static final IdScope[] VALUES;

        private IdScope(int ordinal) {
            if (ordinal != this.ordinal()) {
                throw new IllegalArgumentException("Wrong ordinal");
            }
        }

        static IdScope readFastExternal(DataInput in, short serialVersion) throws IOException {
            return IdScope.valueOf(in.readByte());
        }

        static IdScope valueOf(int ordinal) {
            try {
                return VALUES[ordinal];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("invalid scope: " + ordinal);
            }
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            out.writeByte(this.ordinal());
        }

        static {
            VALUES = IdScope.values();
        }
    }
}

