/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;

public class ArrayFilterIter
extends PlanIter {
    private final PlanIter theInputIter;
    private final PlanIter thePredIter;
    private final int theCtxItemReg;
    private final int theCtxElemReg;
    private final int theCtxElemPosReg;

    public ArrayFilterIter(Expr e, int resultReg, PlanIter inputIter, PlanIter predIter, int ctxItemReg, int ctxElemReg, int ctxElemPosReg) {
        super(e, resultReg);
        this.theInputIter = inputIter;
        this.thePredIter = predIter;
        this.theCtxItemReg = ctxItemReg;
        this.theCtxElemReg = ctxElemReg;
        this.theCtxElemPosReg = ctxElemPosReg;
    }

    ArrayFilterIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        int ctxKeyReg;
        this.theCtxItemReg = ArrayFilterIter.readPositiveInt(in, true);
        this.theCtxElemReg = ArrayFilterIter.readPositiveInt(in, true);
        this.theCtxElemPosReg = ArrayFilterIter.readPositiveInt(in, true);
        if (serialVersion < 13 && (ctxKeyReg = in.readInt()) >= 0) {
            throw new QueryException("Filtering maps via the [] operator is no longer supported. Please uses the values() operator");
        }
        this.theInputIter = ArrayFilterIter.deserializeIter(in, serialVersion);
        this.thePredIter = ArrayFilterIter.deserializeIter(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeInt(this.theCtxItemReg);
        out.writeInt(this.theCtxElemReg);
        out.writeInt(this.theCtxElemPosReg);
        if (serialVersion < 13) {
            out.writeInt(-1);
        }
        ArrayFilterIter.serializeIter(this.theInputIter, out, serialVersion);
        ArrayFilterIter.serializeIter(this.thePredIter, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.ARRAY_FILTER;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new ArrayFilterState(this));
        this.theInputIter.open(rcb);
        if (this.thePredIter != null) {
            this.thePredIter.open(rcb);
        }
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        FieldValueImpl ctxItem;
        ArrayFilterState state;
        block21: {
            block20: {
                state = (ArrayFilterState)rcb.getState(this.theStatePos);
                if (state.isDone()) {
                    return false;
                }
                if (state.theComputePredOnce && state.isOpen()) {
                    state.setState(PlanIterState.StateEnum.RUNNING);
                    this.computePredExpr(rcb, state);
                    if (state.theBoolPredValue == 0) {
                        state.done();
                        return false;
                    }
                }
                while (true) {
                    if (state.theCtxItem == null || state.theCtxItem.isNull()) {
                        boolean more = this.theInputIter.next(rcb);
                        if (!more) {
                            state.done();
                            return false;
                        }
                        ctxItem = rcb.getRegVal(this.theInputIter.getResultReg());
                        if (ctxItem.isNull()) {
                            state.theCtxItem = ctxItem;
                            rcb.setRegVal(this.theResultReg, ctxItem);
                            return true;
                        }
                        if (!ctxItem.isArray()) {
                            state.theSingletonArray.clear();
                            state.theSingletonArray.addInternal(ctxItem);
                            ctxItem = state.theSingletonArray;
                            state.theCtxItemSize = 1;
                        } else {
                            state.theCtxItemSize = ctxItem.size();
                            if (state.theCtxItemSize == 0) continue;
                        }
                        state.theCtxItem = ctxItem;
                        state.theCtxPos = 0;
                        if (!state.theComputePredPerElem) {
                            if (state.theComputePredPerArray) {
                                this.computePredExpr(rcb, state);
                                if (state.theBoolPredValue == 0) {
                                    state.theCtxItem = null;
                                    continue;
                                }
                            }
                            if (state.theBoolPredValue < 0 && (state.theNumPredValue < 0L || state.theNumPredValue >= (long)state.theCtxItemSize)) {
                                state.theCtxItem = null;
                                continue;
                            }
                        }
                    } else {
                        ctxItem = state.theCtxItem;
                    }
                    if (state.theCtxPos >= state.theCtxItemSize) {
                        state.theCtxItem = null;
                        continue;
                    }
                    if (state.theComputePredPerElem) {
                        this.computePredExpr(rcb, state);
                        if (state.theBoolPredValue == 0) {
                            ++state.theCtxPos;
                            continue;
                        }
                    } else assert (state.theBoolPredValue != 0);
                    if (state.theBoolPredValue == 1) {
                        FieldValueImpl elem = ((ArrayValueImpl)state.theCtxItem).getElement(state.theCtxPos);
                        ++state.theCtxPos;
                        rcb.setRegVal(this.theResultReg, elem);
                        return true;
                    }
                    if (!state.theComputePredPerElem) break block20;
                    if (state.theNumPredValue == (long)state.theCtxPos) break;
                    ++state.theCtxPos;
                }
                ++state.theCtxPos;
                break block21;
            }
            state.theCtxItemSize = 0;
            state.theCtxPos = (int)state.theNumPredValue + 1;
        }
        FieldValueImpl res = ctxItem.getElement((int)state.theNumPredValue);
        rcb.setRegVal(this.theResultReg, res);
        return true;
    }

    void computePredExpr(RuntimeControlBlock rcb, ArrayFilterState state) {
        boolean more;
        if (this.thePredIter == null) {
            state.theBoolPredValue = 1;
            return;
        }
        state.theBoolPredValue = -1;
        this.thePredIter.reset(rcb);
        if (this.theCtxItemReg >= 0) {
            rcb.setRegVal(this.theCtxItemReg, state.theCtxItem);
        }
        if (this.theCtxElemReg >= 0) {
            rcb.setRegVal(this.theCtxElemReg, ((ArrayValueImpl)state.theCtxItem).getElement(state.theCtxPos));
        }
        if (this.theCtxElemPosReg >= 0) {
            rcb.setRegVal(this.theCtxElemPosReg, FieldDefImpl.integerDef.createInteger(state.theCtxPos));
        }
        if (!(more = this.thePredIter.next(rcb))) {
            state.theBoolPredValue = 0;
        } else {
            FieldValueImpl val = rcb.getRegVal(this.thePredIter.getResultReg());
            if (val.isNull()) {
                state.theBoolPredValue = 0;
            } else if (val.isBoolean()) {
                state.theBoolPredValue = val.getBoolean() ? 1 : 0;
            } else if (val.isLong() || val.isInteger()) {
                state.theNumPredValue = val.getLong();
            } else {
                throw new QueryException("Predicate expression in array filter has invalid type:\n" + val.getDefinition().getDDLString(), this.getLocation());
            }
        }
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInputIter.reset(rcb);
        if (this.thePredIter != null) {
            this.thePredIter.reset(rcb);
        }
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInputIter.close(rcb);
        if (this.thePredIter != null) {
            this.thePredIter.close(rcb);
        }
        state.close();
    }

    @Override
    void getParentItemContext(RuntimeControlBlock rcb, PlanIter.ParentItemContext ctx) {
        ArrayFilterState state = (ArrayFilterState)rcb.getState(this.theStatePos);
        if (state.theCtxItem == state.theSingletonArray) {
            this.theInputIter.getParentItemContext(rcb, ctx);
        } else {
            ctx.theParentItem = state.theCtxItem;
            ctx.theTargetPos = state.theCtxPos - 1;
            ctx.theTargetKey = null;
        }
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInputIter.display(sb, formatter);
        if (this.thePredIter != null) {
            sb.append(",\n");
            this.thePredIter.display(sb, formatter);
        }
        if (this.theCtxItemReg >= 0) {
            sb.append(",\n");
            formatter.indent(sb);
            sb.append("theCtxItemReg : ").append(this.theCtxItemReg);
        }
        if (this.theCtxElemReg >= 0) {
            sb.append(",\n");
            formatter.indent(sb);
            sb.append("theCtxElemReg : ").append(this.theCtxElemReg);
        }
        if (this.theCtxElemPosReg >= 0) {
            sb.append(",\n");
            formatter.indent(sb);
            sb.append("theCtxElemPosReg : ").append(this.theCtxElemPosReg);
        }
    }

    private static class ArrayFilterState
    extends PlanIterState {
        FieldValueImpl theCtxItem;
        int theCtxItemSize;
        int theCtxPos;
        ArrayValueImpl theSingletonArray;
        int theBoolPredValue;
        long theNumPredValue;
        boolean theComputePredOnce;
        boolean theComputePredPerArray;
        boolean theComputePredPerElem;

        ArrayFilterState(ArrayFilterIter iter) {
            this.theComputePredOnce = iter.theCtxItemReg < 0 && iter.theCtxElemReg < 0 && iter.theCtxElemPosReg < 0;
            this.theComputePredPerArray = iter.theCtxItemReg >= 0 && iter.theCtxElemReg < 0 && iter.theCtxElemPosReg < 0;
            this.theComputePredPerElem = iter.theCtxElemReg >= 0 || iter.theCtxElemPosReg >= 0;
            this.theSingletonArray = FieldDefImpl.arrayAnyDef.createArray();
        }

        @Override
        public void reset(PlanIter iter) {
            super.reset(iter);
            this.theCtxItem = null;
            this.theCtxItemSize = 0;
            this.theCtxPos = 0;
            this.theBoolPredValue = -1;
        }

        @Override
        public void close() {
            super.close();
            this.theCtxItem = null;
            this.theSingletonArray = null;
        }
    }
}

