/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.FieldDefFactory;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.JsonDefImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

public class ExprArrayConstr
extends Expr {
    private final ArrayList<Expr> theArgs;
    private boolean theMustBeJson;
    private final boolean theIsConditional;

    ExprArrayConstr(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location, ArrayList<Expr> args, boolean conditional) {
        super(qcb, sctx, Expr.ExprKind.ARRAY_CONSTR, location);
        this.theArgs = args;
        for (Expr arg : args) {
            arg.addParent(this);
        }
        this.theIsConditional = conditional;
        this.theType = this.computeType();
    }

    @Override
    int getNumChildren() {
        return this.theArgs.size();
    }

    public boolean isConditional() {
        return this.theIsConditional;
    }

    int getNumArgs() {
        return this.theArgs.size();
    }

    Expr getArg(int i) {
        return this.theArgs.get(i);
    }

    void setArg(int i, Expr newExpr, boolean destroy) {
        this.theArgs.get(i).removeParent(this, destroy);
        this.theArgs.set(i, newExpr);
        newExpr.addParent(this);
    }

    void removeArg(int i, boolean destroy) {
        if (!this.theArgs.get(i).getType().isEmpty()) {
            throw new QueryStateException("Cannot remove non-empty input expr from array constructor expr");
        }
        this.theArgs.get(i).removeParent(this, destroy);
        this.theArgs.remove(i);
    }

    void setJsonArrayType() {
        this.theMustBeJson = true;
    }

    public ArrayDefImpl getArrayType() {
        if (!this.theIsConditional) {
            return (ArrayDefImpl)this.getType().getDef();
        }
        JsonDefImpl elemDef = this.theMustBeJson ? FieldDefImpl.jsonDef : this.theArgs.get(0).getType().getDef();
        return FieldDefFactory.createArrayDef(elemDef);
    }

    @Override
    ExprType computeType() {
        ExprType type;
        int numArgs = this.theArgs.size();
        if (numArgs == 0) {
            return TypeManager.createArrayType(TypeManager.JSON_ONE(), ExprType.Quantifier.ONE);
        }
        ExprType elemType = this.theArgs.get(0).getType();
        if (this.theIsConditional) {
            assert (numArgs == 1);
            if (elemType.isSubType(TypeManager.JSON_STAR())) {
                return TypeManager.JSON_QSTN();
            }
            return TypeManager.ANY_QSTN();
        }
        for (int i = 1; i < numArgs && !(elemType = TypeManager.getConcatType(elemType, type = this.theArgs.get(i).getType())).isAny(); ++i) {
        }
        if (this.theMustBeJson && elemType.getDef().isSubtype(FieldDefImpl.jsonDef)) {
            elemType = TypeManager.JSON_ONE();
        }
        if (elemType.isAnyJson()) {
            this.theQCB.theHaveJsonConstructors = true;
        }
        return TypeManager.createArrayType(elemType, ExprType.Quantifier.ONE);
    }

    @Override
    public boolean mayReturnNULL() {
        if (this.theIsConditional) {
            return this.theArgs.get(0).mayReturnNULL();
        }
        return false;
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
        for (int i = 0; i < this.theArgs.size(); ++i) {
            this.theArgs.get(i).display(sb, formatter);
            if (i >= this.theArgs.size() - 1) continue;
            sb.append(",\n");
        }
    }
}

