/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.async.DialogHandlerFactory;
import oracle.kv.impl.async.EndpointConfig;
import oracle.kv.impl.async.EndpointHandlerManager;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.async.dialog.AbstractDialogEndpointHandler;
import oracle.kv.impl.async.dialog.ChannelOutput;
import oracle.kv.impl.async.dialog.ProtocolReader;
import oracle.kv.impl.async.dialog.ProtocolWriter;
import oracle.kv.impl.async.dialog.netty.NettyChannelInput;
import oracle.kv.impl.async.exception.ConnectionEndpointShutdownException;

public class NettyEndpointHandler
extends AbstractDialogEndpointHandler {
    private final NettyChannelInput channelInput;
    private final ChannelOutput channelOutput;
    private final ProtocolReader protocolReader;
    private final ProtocolWriter protocolWriter;
    private final Decoder decoder;
    private volatile boolean handedOffToSync = false;
    private volatile ChannelHandlerContext context = null;
    private volatile boolean lastChunkWrittenToContext = false;
    private final Queue<ChannelFuture> pendingWriteFutures = new LinkedList<ChannelFuture>();
    private final Runnable invokeWriteTask = new Runnable(){

        @Override
        public void run() {
            NettyEndpointHandler.this.invokeWrite();
        }
    };

    public NettyEndpointHandler(Logger logger, EndpointHandlerManager parent, EndpointConfig endpointConfig, boolean isCreator, NetworkAddress remoteAddress, Map<Integer, DialogHandlerFactory> dialogHandlerFactories) {
        super(logger, parent, endpointConfig, isCreator, remoteAddress, dialogHandlerFactories);
        this.channelInput = new NettyChannelInput();
        this.channelOutput = new ChannelOutput();
        this.protocolReader = new ProtocolReader(this.channelInput, this.getMaxInputProtocolMesgLen());
        this.protocolWriter = new ProtocolWriter(this.channelOutput, this.getMaxOutputProtocolMesgLen());
        this.decoder = new Decoder();
    }

    @Override
    public ScheduledExecutorService getSchedExecService() {
        if (this.context == null) {
            return null;
        }
        return this.context.executor();
    }

    @Override
    public ProtocolReader getProtocolReader() {
        return this.protocolReader;
    }

    @Override
    public ProtocolWriter getProtocolWriter() {
        return this.protocolWriter;
    }

    @Override
    public void assertInExecutorThread() {
        if (this.context == null || !this.context.executor().inEventLoop()) {
            throw new IllegalStateException("The method is not executed in the thread of executor");
        }
    }

    @Override
    protected boolean flushInternal(boolean writeHasRemaining) {
        if (this.handedOffToSync) {
            return true;
        }
        if (this.context.executor().inEventLoop()) {
            this.invokeWrite();
            return this.pendingWriteFutures.isEmpty();
        }
        this.context.executor().execute(this.invokeWriteTask);
        return false;
    }

    @Override
    protected void cleanup() {
        this.channelInput.close();
        this.channelOutput.close();
        if (!this.handedOffToSync) {
            this.context.close();
        }
    }

    private void invokeWrite() {
        ChannelOutput.Chunk chunk;
        while (!this.lastChunkWrittenToContext && (chunk = this.channelOutput.getChunkQueue().poll()) != null) {
            ByteBuf buf = Unpooled.wrappedBuffer((ByteBuffer[])chunk.chunkArray());
            this.pendingWriteFutures.add(this.context.write((Object)buf));
            if (!chunk.last()) continue;
            this.lastChunkWrittenToContext = true;
            break;
        }
        this.context.flush();
        Iterator iter = this.pendingWriteFutures.iterator();
        while (iter.hasNext()) {
            ChannelFuture future = (ChannelFuture)iter.next();
            if (!future.isDone()) continue;
            iter.remove();
        }
    }

    void handedOffToSync() {
        this.handedOffToSync = true;
    }

    Decoder decoder() {
        return this.decoder;
    }

    class Decoder
    extends ByteToMessageDecoder {
        Decoder() {
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            NettyEndpointHandler.this.context = ctx;
            this.setCumulator(COMPOSITE_CUMULATOR);
            NettyEndpointHandler.this.onExecutorReady();
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            if (ctx != NettyEndpointHandler.this.context) {
                NettyEndpointHandler.this.getLogger().log(Level.FINE, "Endpoint handler context switched, handler={0}", (Object)this);
                NettyEndpointHandler.this.context = ctx;
            }
            NettyEndpointHandler.this.channelInput.feed(in);
            NettyEndpointHandler.this.onChannelInputRead();
            NettyEndpointHandler.this.flush();
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ChannelInputShutdownEvent) {
                NettyEndpointHandler.this.markTerminating(new ConnectionEndpointShutdownException(true, "Got eof when reading"));
                NettyEndpointHandler.this.terminate();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            NettyEndpointHandler.this.markTerminating(cause);
            NettyEndpointHandler.this.terminate();
        }
    }
}

