/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.table.IntegerValueImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableKey;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.RecordDef;
import oracle.kv.table.RecordValue;

public class PrimaryKeyImpl
extends RowImpl
implements PrimaryKey {
    private static final long serialVersionUID = 1L;

    PrimaryKeyImpl(RecordDef field, TableImpl table) {
        super(field, table);
    }

    private PrimaryKeyImpl(PrimaryKeyImpl other) {
        super(other);
    }

    @Override
    public PrimaryKeyImpl clone() {
        return new PrimaryKeyImpl(this);
    }

    @Override
    public PrimaryKey asPrimaryKey() {
        return this;
    }

    @Override
    public boolean isPrimaryKey() {
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof PrimaryKeyImpl) {
            return super.equals(other);
        }
        return false;
    }

    @Override
    public RecordValue put(int pos, FieldValue value) {
        int size;
        if (value.isNull()) {
            throw new IllegalArgumentException("Can not put a NULL value in a primary key field");
        }
        super.put(pos, value);
        if (value.isInteger() && (size = this.table.getPrimaryKeySize(pos)) != 0) {
            ((IntegerValueImpl)value).validateStorageSize(size);
        }
        return this;
    }

    @Override
    void checkIdentity(int pos, FieldValue value) {
    }

    @Override
    public RecordValue put(int pos, int value) {
        this.validateValueKind(pos, FieldDef.Type.INTEGER);
        return this.put(pos, (FieldValue)this.getFieldDef(pos).createInteger(value));
    }

    @Override
    public RecordValue put(String name, int value) {
        int pos = this.getFieldPos(name);
        return this.put(pos, value);
    }

    @Override
    public int getDataSize() {
        throw new IllegalArgumentException("It is not possible to get data size from a PrimaryKey");
    }

    @Override
    public void validate() {
        this.validateIndexFields();
    }

    @Override
    public void copyFrom(RecordValue source) {
        this.copyFrom(source, true);
    }

    public boolean isComplete() {
        return this.getNumFields() == this.size();
    }

    public boolean hasShardKey() {
        return this.table.getShardKeySize() <= this.size();
    }

    public byte[] createKeyBytes() {
        return TableKey.createKey(this.getTable(), this, true).getKeyBytes();
    }

    public PartitionId getPartitionId(KVStoreImpl store) {
        if (!this.hasShardKey()) {
            return null;
        }
        TableKey key = TableKey.createKey(this.table, this, true);
        byte[] binaryKey = store.getKeySerializer().toByteArray(key.getKey());
        return store.getDispatcher().getPartitionId(binaryKey);
    }

    @Override
    public String getClassNameForError() {
        return "PrimaryKey";
    }
}

