/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.parallelscan;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.Direction;
import oracle.kv.RequestTimeoutException;
import oracle.kv.StoreIteratorException;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.parallelscan.ParallelScanHook;
import oracle.kv.impl.async.AsyncTableIterator;
import oracle.kv.impl.async.IterationHandleNotifier;
import oracle.kv.impl.async.ResultHandler;

public abstract class BaseParallelScanIteratorImpl<K>
implements AsyncTableIterator<K> {
    private static final long NANOS_TO_MILLIS = 1000000L;
    private static final long WAIT_TIME_MS = 100L;
    private static final int QUEUE_SIZE = 3;
    protected final KVStoreImpl storeImpl;
    protected final Logger logger;
    protected final long requestTimeoutMs;
    protected final Direction itrDirection;
    private volatile KVStoreImpl.TaskExecutor taskExecutor;
    protected final TreeSet<Stream> streams = new TreeSet();
    protected volatile boolean closed = false;
    private volatile Throwable closeException = null;
    private volatile K next = null;
    final int maxResultsBatches;
    final IterationHandleNotifier iterHandleNotifier;
    private final Semaphore asyncTaskPermits = new Semaphore(0);
    private final BlockingQueue<Runnable> pendingAsyncTasks = new LinkedBlockingQueue<Runnable>();
    private final boolean prefetch;

    protected BaseParallelScanIteratorImpl(KVStoreImpl storeImpl, Logger logger, long requestTimeoutMs, Direction itrDirection, int maxResultsBatches, boolean prefetch, IterationHandleNotifier iterHandleNotifier) {
        this.storeImpl = storeImpl;
        this.logger = logger;
        this.requestTimeoutMs = requestTimeoutMs;
        this.itrDirection = itrDirection;
        this.maxResultsBatches = maxResultsBatches > 0 ? maxResultsBatches : 3;
        this.prefetch = prefetch;
        this.iterHandleNotifier = iterHandleNotifier;
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            this.next = this.getNext();
        }
        return this.next != null;
    }

    @Override
    public K next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        K lastReturned = this.next;
        this.next = null;
        return lastReturned;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public K nextLocal() {
        if (!this.hasNext()) {
            return null;
        }
        K lastReturned = this.next;
        this.next = null;
        return lastReturned;
    }

    @Override
    public boolean isClosed() {
        if (this.closed) {
            if (this.closeException != null) {
                throw new StoreIteratorException(this.closeException, null);
            }
            return true;
        }
        return false;
    }

    @Override
    public Throwable getCloseException() {
        return this.closed && this.closeException != null ? new StoreIteratorException(this.closeException, null) : null;
    }

    private K getNext() {
        long limitNs = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.requestTimeoutMs);
        while (!this.isClosed()) {
            Stream stream = this.streams.pollFirst();
            if (stream == null) {
                this.close();
                return null;
            }
            Object entry = stream.removeNext();
            if (!stream.isDone()) {
                this.streams.add(stream);
            }
            if (this.isClosed()) {
                return null;
            }
            if (entry != null) {
                return entry;
            }
            if (stream.isDone() || stream.hasNextElem()) continue;
            long waitMs = Math.min((limitNs - System.nanoTime()) / 1000000L, 100L);
            if (waitMs <= 0L) {
                throw new RequestTimeoutException((int)this.requestTimeoutMs, "Operation timed out on shard: " + stream, null, false);
            }
            if (this.iterHandleNotifier != null) {
                return null;
            }
            stream.waitForNext(waitMs);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean close(Throwable reason) {
        BaseParallelScanIteratorImpl baseParallelScanIteratorImpl = this;
        synchronized (baseParallelScanIteratorImpl) {
            if (this.closed) {
                return false;
            }
            this.closeException = reason;
            this.closed = true;
        }
        this.next = null;
        return true;
    }

    protected abstract int compare(K var1, K var2);

    protected abstract void convertResult(Result var1, List<K> var2);

    protected KVStoreImpl.TaskExecutor getTaskExecutor() {
        if (this.taskExecutor == null) {
            throw new IllegalStateException("No task executor");
        }
        return this.taskExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTaskExecutor(int maxConcurrentTasks) {
        BaseParallelScanIteratorImpl baseParallelScanIteratorImpl = this;
        synchronized (baseParallelScanIteratorImpl) {
            if (this.taskExecutor != null) {
                throw new IllegalStateException("Task executor has already been set");
            }
            this.taskExecutor = this.storeImpl.getTaskExecutor(maxConcurrentTasks);
            this.asyncTaskPermits.release(maxConcurrentTasks);
        }
    }

    void runAsync(Runnable task) {
        if (this.asyncTaskPermits.tryAcquire()) {
            task.run();
            return;
        }
        this.pendingAsyncTasks.add(task);
        if (this.asyncTaskPermits.tryAcquire()) {
            Runnable t = (Runnable)this.pendingAsyncTasks.poll();
            if (t == null) {
                this.asyncTaskPermits.release();
            } else {
                t.run();
            }
        }
    }

    void asyncTaskDone() {
        Runnable t = (Runnable)this.pendingAsyncTasks.poll();
        if (t == null) {
            this.asyncTaskPermits.release();
        } else {
            this.taskExecutor.submit(t);
        }
    }

    public abstract class Stream
    implements Comparable<Stream>,
    Runnable {
        private final BlockingQueue<Result> blocks;
        protected Result currentResultSet;
        private List<K> currentBlock;
        protected int currentResultPos;
        private K nextElem;
        private boolean doneReading;
        private boolean done;
        private boolean active;

        public Stream() {
            this.blocks = new LinkedBlockingQueue<Result>(BaseParallelScanIteratorImpl.this.maxResultsBatches);
            this.currentResultPos = -1;
            this.nextElem = null;
            this.doneReading = false;
            this.done = false;
            this.active = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        K removeNext() {
            assert (!this.done);
            Object ret = this.nextElem;
            if (this.currentBlock != null && !this.currentBlock.isEmpty()) {
                do {
                    this.nextElem = this.currentBlock.remove(0);
                    ++this.currentResultPos;
                } while (this.nextElem == null && !this.currentBlock.isEmpty());
            } else {
                this.nextElem = null;
            }
            while (this.nextElem == null) {
                Stream stream = this;
                synchronized (stream) {
                    this.currentResultSet = (Result)this.blocks.poll();
                    this.currentBlock = null;
                    this.currentResultPos = -1;
                    if (this.currentResultSet == null) {
                        this.submit();
                        this.done = this.doneReading;
                        break;
                    }
                    if (BaseParallelScanIteratorImpl.this.prefetch) {
                        this.submit();
                    }
                }
                int nRecords = this.currentResultSet.getNumRecords();
                if (nRecords <= 0) continue;
                this.currentBlock = new ArrayList(nRecords);
                BaseParallelScanIteratorImpl.this.convertResult(this.currentResultSet, this.currentBlock);
                assert (nRecords == this.currentBlock.size());
                do {
                    this.nextElem = this.currentBlock.remove(0);
                    ++this.currentResultPos;
                } while (this.nextElem == null && !this.currentBlock.isEmpty());
            }
            return ret;
        }

        boolean hasNextElem() {
            return this.nextElem != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitForNext(long waitMs) {
            block7: {
                assert (BaseParallelScanIteratorImpl.this.iterHandleNotifier == null);
                try {
                    Stream stream = this;
                    synchronized (stream) {
                        if (this.blocks.isEmpty() && !this.doneReading) {
                            this.wait(waitMs);
                        }
                    }
                }
                catch (InterruptedException ex) {
                    if (BaseParallelScanIteratorImpl.this.closed) break block7;
                    BaseParallelScanIteratorImpl.this.logger.log(Level.WARNING, "Unexpected interrupt ", ex);
                }
            }
        }

        boolean isDone() {
            return this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void submit() {
            Stream stream = this;
            synchronized (stream) {
                if (this.active || this.doneReading || this.blocks.remainingCapacity() == 0 || BaseParallelScanIteratorImpl.this.closed) {
                    return;
                }
                this.active = true;
            }
            if (BaseParallelScanIteratorImpl.this.iterHandleNotifier != null) {
                BaseParallelScanIteratorImpl.this.runAsync(this);
                return;
            }
            try {
                BaseParallelScanIteratorImpl.this.getTaskExecutor().submit(this);
            }
            catch (RejectedExecutionException ree) {
                this.setActive(false);
                BaseParallelScanIteratorImpl.this.close(ree);
            }
        }

        synchronized void setActive(boolean value) {
            this.active = value;
        }

        @Override
        public void run() {
            try {
                assert (this.active);
                assert (!this.doneReading);
                assert (this.blocks.remainingCapacity() > 0);
                this.readBlock();
            }
            catch (RuntimeException re) {
                this.setActive(false);
                BaseParallelScanIteratorImpl.this.close(re);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readBlock() {
            final long start = System.nanoTime();
            Request req = this.makeReadRequest();
            if (req == null) {
                Stream stream = this;
                synchronized (stream) {
                    this.active = false;
                    this.doneReading = true;
                    this.notifySync();
                }
                this.notifyAsync();
                this.submitDetailedMetrics(start, 0);
                return;
            }
            assert (BaseParallelScanIteratorImpl.this.storeImpl.getParallelScanHook() == null || BaseParallelScanIteratorImpl.this.storeImpl.getParallelScanHook().callback(Thread.currentThread(), ParallelScanHook.HookType.BEFORE_EXECUTE_REQUEST, null));
            if (BaseParallelScanIteratorImpl.this.iterHandleNotifier != null) {
                class RequestResultHandler
                implements ResultHandler<Result> {
                    RequestResultHandler() {
                    }

                    @Override
                    public void onResult(Result result, Throwable exception) {
                        BaseParallelScanIteratorImpl.this.asyncTaskDone();
                        if (exception != null) {
                            Stream.this.setActive(false);
                            BaseParallelScanIteratorImpl.this.close(exception);
                            Stream.this.notifyAsync();
                            return;
                        }
                        Stream.this.processResult(start, result);
                    }
                }
                BaseParallelScanIteratorImpl.this.storeImpl.executeRequest(req, new RequestResultHandler());
            } else {
                try {
                    this.processResult(start, BaseParallelScanIteratorImpl.this.storeImpl.executeRequest(req));
                }
                catch (RuntimeException re) {
                    this.setActive(false);
                    BaseParallelScanIteratorImpl.this.close(re);
                }
            }
        }

        private void submitDetailedMetrics(long start, int nRecords) {
            long end = System.nanoTime();
            long thisTimeMs = (end - start) / 1000000L;
            this.updateDetailedMetrics(thisTimeMs, nRecords);
        }

        private void notifySync() {
            assert (Thread.holdsLock(this));
            if (BaseParallelScanIteratorImpl.this.iterHandleNotifier == null) {
                this.notify();
            }
        }

        void notifyAsync() {
            assert (!Thread.holdsLock(this));
            if (BaseParallelScanIteratorImpl.this.iterHandleNotifier != null) {
                BaseParallelScanIteratorImpl.this.iterHandleNotifier.notifyNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processResult(long start, Result result) {
            boolean hasMore = this.hasMoreElements(result);
            int nRecords = result.getNumRecords();
            if (nRecords > 0) {
                this.setResumeKey(result);
            }
            Stream stream = this;
            synchronized (stream) {
                this.active = false;
                boolean bl = this.doneReading = !hasMore;
                if (nRecords == 0) {
                    assert (BaseParallelScanIteratorImpl.this.storeImpl.getParallelScanHook() == null || BaseParallelScanIteratorImpl.this.storeImpl.getParallelScanHook().callback(Thread.currentThread(), ParallelScanHook.HookType.AFTER_PROCESSING_STREAM, null));
                } else {
                    this.blocks.add(result);
                }
                this.notifySync();
            }
            this.notifyAsync();
            if (hasMore && BaseParallelScanIteratorImpl.this.prefetch) {
                this.submit();
            }
            this.submitDetailedMetrics(start, nRecords);
        }

        protected abstract void setResumeKey(Result var1);

        protected abstract Request makeReadRequest();

        protected boolean hasMoreElements(Result result) {
            return result.hasMoreElements();
        }

        @Override
        public int compareTo(Stream other) {
            if (this == other) {
                return 0;
            }
            if (BaseParallelScanIteratorImpl.this.itrDirection == Direction.UNORDERED) {
                return this.nextElem == null ? 1 : -1;
            }
            if (this.nextElem == null) {
                return -1;
            }
            Object otherNext = other.nextElem;
            if (otherNext == null) {
                return 1;
            }
            int comp = this.compareInternal(other);
            if (comp == 0) {
                BaseParallelScanIteratorImpl.this.close(new IllegalStateException("Detected an unexpected duplicate record"));
            }
            return comp;
        }

        protected int compareInternal(Stream other) {
            int cmp = BaseParallelScanIteratorImpl.this.compare(this.nextElem, other.nextElem);
            return BaseParallelScanIteratorImpl.this.itrDirection == Direction.FORWARD ? cmp : cmp * -1;
        }

        public synchronized String getStatus() {
            return this.done + ", " + this.active + ", " + this.doneReading + ", " + this.blocks.size();
        }

        protected abstract void updateDetailedMetrics(long var1, long var3);
    }
}

