/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.MathContext;
import java.math.RoundingMode;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.query.PreparedStatementImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldDefSerialization;
import oracle.kv.impl.api.table.FieldValueSerialization;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.ReceiveIter;
import oracle.kv.impl.query.runtime.ResumeInfo;
import oracle.kv.impl.util.SerialVersion;
import oracle.kv.table.FieldValue;

public class TableQuery
extends InternalOperation {
    private final FieldDefImpl resultDef;
    private final boolean mayReturnNULL;
    private final PlanIter queryPlan;
    private final FieldValue[] externalVars;
    private final int numIterators;
    private final int numRegisters;
    private final long tableId;
    private final MathContext mathContext;
    private final byte traceLevel;
    private final int batchSize;
    private final int currentMaxReadKB;
    private final int maxReadKB;
    private final ResumeInfo resumeInfo;
    private final int emptyReadFactor;

    public TableQuery(PreparedStatementImpl.DistributionKind distKind, FieldDefImpl resultDef, boolean mayReturnNULL, PlanIter queryPlan, FieldValue[] externalVars, int numIterators, int numRegisters, long tableId, MathContext mathContext, byte traceLevel, int batchSize, int currentMaxReadKB, int maxReadKB, ResumeInfo resumeInfo, int emptyReadFactor) {
        super(distKind == PreparedStatementImpl.DistributionKind.ALL_PARTITIONS ? InternalOperation.OpCode.QUERY_MULTI_PARTITION : (distKind == PreparedStatementImpl.DistributionKind.ALL_SHARDS ? InternalOperation.OpCode.QUERY_MULTI_SHARD : InternalOperation.OpCode.QUERY_SINGLE_PARTITION));
        this.resultDef = resultDef;
        this.mayReturnNULL = mayReturnNULL;
        this.queryPlan = queryPlan;
        this.externalVars = externalVars;
        this.numIterators = numIterators;
        this.numRegisters = numRegisters;
        this.tableId = tableId;
        this.mathContext = mathContext;
        this.traceLevel = traceLevel;
        this.batchSize = batchSize;
        this.currentMaxReadKB = currentMaxReadKB;
        this.maxReadKB = maxReadKB;
        this.resumeInfo = resumeInfo;
        assert (emptyReadFactor <= 127);
        this.emptyReadFactor = emptyReadFactor;
    }

    FieldDefImpl getResultDef() {
        return this.resultDef;
    }

    boolean mayReturnNULL() {
        return this.mayReturnNULL;
    }

    PlanIter getQueryPlan() {
        return this.queryPlan;
    }

    FieldValue[] getExternalVars() {
        return this.externalVars;
    }

    int getNumIterators() {
        return this.numIterators;
    }

    int getNumRegisters() {
        return this.numRegisters;
    }

    @Override
    public long getTableId() {
        return this.tableId;
    }

    public MathContext getMathContext() {
        return this.mathContext;
    }

    byte getTraceLevel() {
        return this.traceLevel;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    public int getCurrentMaxReadKB() {
        return this.currentMaxReadKB;
    }

    public int getMaxReadKB() {
        return this.maxReadKB;
    }

    public ResumeInfo getResumeInfo() {
        return this.resumeInfo;
    }

    @Override
    void addEmptyReadCharge() {
        this.addReadBytes(1024 * this.emptyReadFactor);
    }

    public int getEmptyReadFactor() {
        return this.emptyReadFactor;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        if (serialVersion < 12) {
            out.writeShort(1);
        }
        if (this.queryPlan instanceof ReceiveIter) {
            byte[] serializedQueryPlan = ((ReceiveIter)this.queryPlan).ensureSerializedIter(serialVersion);
            out.write(serializedQueryPlan);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(baos);
            PlanIter.serializeIter(this.queryPlan, dataOut, serialVersion);
            out.write(baos.toByteArray());
        }
        FieldDefSerialization.writeFieldDef(this.resultDef, out, serialVersion);
        if (serialVersion >= 12) {
            out.writeBoolean(this.mayReturnNULL);
        }
        TableQuery.writeExternalVars(this.externalVars, out, serialVersion);
        out.writeInt(this.numIterators);
        out.writeInt(this.numRegisters);
        out.writeInt(this.batchSize);
        if (serialVersion >= 13) {
            out.writeByte(this.traceLevel);
        }
        if (serialVersion >= 16) {
            this.resumeInfo.writeFastExternal(out, serialVersion);
        } else {
            if (serialVersion >= 15) {
                out.writeInt(this.resumeInfo.getCurrentIndexRange());
            }
            byte[] primKey = this.resumeInfo.getPrimResumeKey();
            byte[] secKey = this.resumeInfo.getSecResumeKey();
            if (primKey == null) {
                out.writeShort(-1);
            } else {
                out.writeShort(primKey.length);
                out.write(primKey);
            }
            if (secKey == null) {
                out.writeShort(-1);
            } else {
                out.writeShort(secKey.length);
                out.write(secKey);
            }
            out.writeLong(this.resumeInfo.getNumResultsComputed());
        }
        if (serialVersion >= 14) {
            TableQuery.writeMathContext(this.mathContext, out);
        }
        if (serialVersion >= 16) {
            out.writeLong(this.tableId);
        }
        if (serialVersion >= 16) {
            out.writeInt(this.currentMaxReadKB);
            out.writeInt(this.maxReadKB);
        }
        if (serialVersion >= 16) {
            out.writeByte(this.emptyReadFactor);
        }
    }

    protected TableQuery(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        if (serialVersion < 11) {
            String required = SerialVersion.getKVVersion((short)11).getNumericVersionString();
            String found = SerialVersion.getKVVersion(serialVersion).getNumericVersionString();
            throw new UnsupportedOperationException("Query operations require a client version equal to or greater than " + required + ". The client version detected is " + found);
        }
        try {
            if (serialVersion < 12) {
                in.readShort();
            }
            this.queryPlan = PlanIter.deserializeIter(in, serialVersion);
            this.resultDef = FieldDefSerialization.readFieldDef(in, serialVersion);
            this.mayReturnNULL = serialVersion < 12 ? false : in.readBoolean();
            this.externalVars = TableQuery.readExternalVars(in, serialVersion);
            this.numIterators = in.readInt();
            this.numRegisters = in.readInt();
            this.batchSize = in.readInt();
            this.traceLevel = serialVersion < 13 ? (byte)0 : in.readByte();
            if (serialVersion >= 16) {
                this.resumeInfo = new ResumeInfo(in, serialVersion);
            } else {
                byte[] key;
                this.resumeInfo = new ResumeInfo(null);
                if (serialVersion < 15) {
                    this.resumeInfo.setCurrentIndexRange(0);
                } else {
                    this.resumeInfo.setCurrentIndexRange(in.readInt());
                }
                short keyLen = in.readShort();
                if (keyLen < 0) {
                    this.resumeInfo.setPrimResumeKey(null);
                } else {
                    key = new byte[keyLen];
                    in.readFully(key);
                    this.resumeInfo.setPrimResumeKey(key);
                }
                keyLen = in.readShort();
                if (keyLen < 0) {
                    this.resumeInfo.setSecResumeKey(null);
                } else {
                    key = new byte[keyLen];
                    in.readFully(key);
                    this.resumeInfo.setSecResumeKey(key);
                }
                this.resumeInfo.setNumResultsComputed((int)in.readLong());
            }
            this.mathContext = serialVersion < 14 ? MathContext.DECIMAL32 : TableQuery.readMathContext(in);
            this.tableId = serialVersion < 16 ? 0L : in.readLong();
            if (serialVersion < 16) {
                this.currentMaxReadKB = 0;
                this.maxReadKB = 0;
            } else {
                this.currentMaxReadKB = in.readInt();
                this.maxReadKB = in.readInt();
            }
            this.emptyReadFactor = serialVersion < 16 ? 0 : (int)in.readByte();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            throw new QueryStateException("Read TableQuery failed: " + re);
        }
    }

    static void writeExternalVars(FieldValue[] vars, DataOutput out, short serialVersion) throws IOException {
        if (vars != null && vars.length > 0) {
            int numVars = vars.length;
            out.writeInt(numVars);
            for (int i = 0; i < numVars; ++i) {
                FieldValueSerialization.writeFieldValue(vars[i], true, out, serialVersion);
            }
        } else {
            out.writeInt(0);
        }
    }

    static FieldValue[] readExternalVars(DataInput in, short serialVersion) throws IOException {
        int numVars = in.readInt();
        if (numVars == 0) {
            return null;
        }
        FieldValue[] vars = new FieldValue[numVars];
        for (int i = 0; i < numVars; ++i) {
            FieldValue val;
            vars[i] = val = FieldValueSerialization.readFieldValue(null, in, serialVersion);
        }
        return vars;
    }

    static void writeMathContext(MathContext mathContext, DataOutput out) throws IOException {
        if (mathContext == null) {
            out.writeByte(0);
        } else if (MathContext.DECIMAL32.equals(mathContext)) {
            out.writeByte(1);
        } else if (MathContext.DECIMAL64.equals(mathContext)) {
            out.writeByte(2);
        } else if (MathContext.DECIMAL128.equals(mathContext)) {
            out.writeByte(3);
        } else if (MathContext.UNLIMITED.equals(mathContext)) {
            out.writeByte(4);
        } else {
            out.writeByte(5);
            out.writeInt(mathContext.getPrecision());
            out.writeInt(mathContext.getRoundingMode().ordinal());
        }
    }

    static MathContext readMathContext(DataInput in) throws IOException {
        byte code = in.readByte();
        switch (code) {
            case 0: {
                return null;
            }
            case 1: {
                return MathContext.DECIMAL32;
            }
            case 2: {
                return MathContext.DECIMAL64;
            }
            case 3: {
                return MathContext.DECIMAL128;
            }
            case 4: {
                return MathContext.UNLIMITED;
            }
            case 5: {
                int precision = in.readInt();
                int roundingMode = in.readInt();
                return new MathContext(precision, RoundingMode.valueOf(roundingMode));
            }
        }
        throw new QueryStateException("Unknown MathContext code.");
    }
}

