/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.lob;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.Durability;
import oracle.kv.FaultException;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.ValueVersion;
import oracle.kv.Version;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.lob.ChunkKeysIterator;
import oracle.kv.impl.api.lob.WriteOperation;
import oracle.kv.impl.test.TestHook;
import oracle.kv.impl.test.TestHookExecute;
import oracle.kv.impl.util.UserDataControl;

public class DeleteOperation
extends WriteOperation {
    private static final int DELETE_KEYS_BATCH_SIZE = 1000;
    private static TestHook<Integer> deleteTestHook;

    public DeleteOperation(KVStoreImpl kvsImpl, Key appLobKey, Durability durability, long chunkTimeout, TimeUnit timeoutUnit) {
        super(kvsImpl, appLobKey, null, durability, chunkTimeout, timeoutUnit);
    }

    public static void setDeleteTestHook(TestHook<Integer> deleteTestHook) {
        DeleteOperation.deleteTestHook = deleteTestHook;
    }

    public boolean execute(boolean retainAppKV) {
        boolean metadataDeleted;
        ValueVersion appLobValueVersion = this.kvsImpl.get(this.appLOBKey, Consistency.ABSOLUTE, this.chunkTimeoutMs, TimeUnit.MILLISECONDS);
        if (appLobValueVersion == null) {
            return false;
        }
        this.internalLOBKey = DeleteOperation.valueToILK(appLobValueVersion.getValue());
        ValueVersion metadataVV = this.kvsImpl.get(this.internalLOBKey, Consistency.ABSOLUTE, this.chunkTimeoutMs, TimeUnit.MILLISECONDS);
        if (metadataVV != null) {
            this.initMetadata(metadataVV.getValue());
            this.lobProps.markDeleted();
            this.updateMetadata(metadataVV.getVersion());
            if (this.lobProps.getLastSuperChunkId() != null) {
                this.deleteSuperChunks(this.lobProps.getLastSuperChunkId());
            } else {
                ChunkKeysIterator chunkKeys = this.lobProps.getNumChunks() != null ? this.getChunkKeysNumChunksIterator(this.lobProps.getNumChunks()) : this.kvsImpl.storeKeysIterator(Direction.UNORDERED, 1000, this.internalLOBKey, new KeyRange("", true, null, false), Depth.DESCENDANTS_ONLY, Consistency.ABSOLUTE, this.chunkTimeoutMs, TimeUnit.MILLISECONDS);
                this.deleteChunks(chunkKeys);
            }
        }
        if (!(metadataDeleted = this.kvsImpl.delete(this.internalLOBKey))) {
            if (metadataVV != null) {
                String msg = "Internal Lob key: " + this.internalLOBKey + " deleted while LOB delete was in progress.";
                throw new ConcurrentModificationException(msg);
            }
        } else if (metadataVV == null) {
            String msg = "Internal Lob key: " + this.internalLOBKey + " appeared while LOB delete was in progress.";
            throw new ConcurrentModificationException(msg);
        }
        if (retainAppKV) {
            return true;
        }
        boolean deleted = this.kvsImpl.deleteIfVersion(this.appLOBKey, appLobValueVersion.getVersion());
        if (!deleted) {
            String msg = "LOB: " + UserDataControl.displayKey(this.appLOBKey) + " modified while delete was in progress.";
            throw new ConcurrentModificationException(msg);
        }
        return true;
    }

    private void deleteSuperChunks(long lastScid) throws FaultException {
        for (long scid = 1L; scid <= lastScid + 1L; ++scid) {
            assert (TestHookExecute.doHookIfSet(deleteTestHook, null));
            Key scKey = this.chunkKeyFactory.createSuperChunkKey(this.internalLOBKey, scid);
            this.kvsImpl.multiDelete(scKey, new KeyRange("", true, null, false), Depth.DESCENDANTS_ONLY, this.lobDurability, this.chunkTimeoutMs, TimeUnit.MILLISECONDS);
        }
    }

    private void deleteChunks(Iterator<Key> chunkKeys) throws FaultException, ConcurrentModificationException {
        while (chunkKeys.hasNext()) {
            assert (TestHookExecute.doHookIfSet(deleteTestHook, null));
            Key chunkKey = chunkKeys.next();
            boolean bl = this.kvsImpl.delete(chunkKey);
        }
    }

    @Override
    protected Version putChunks(long startByte, byte[] chunkPrefix, Version metadataVersion) {
        throw new UnsupportedOperationException("Delete does not support this operation.");
    }
}

