/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.CascadeLockingPolicy;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.expressions.FieldExpression;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.SQLUpdateStatement;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.RelationalMapping;
import org.eclipse.persistence.mappings.foundation.MapComponentMapping;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class OneToManyMapping
extends CollectionMapping
implements RelationalMapping,
MapComponentMapping {
    protected static final String PostInsert = "postInsert";
    protected static final String ObjectRemoved = "objectRemoved";
    protected static final String ObjectAdded = "objectAdded";
    protected Vector<DatabaseField> targetForeignKeyFields;
    protected Vector<DatabaseField> sourceKeyFields;
    protected transient Map<DatabaseField, DatabaseField> targetForeignKeysToSourceKeys = new HashMap<DatabaseField, DatabaseField>(2);
    protected transient Map<DatabaseField, DatabaseField> sourceKeysToTargetForeignKeys = new HashMap<DatabaseField, DatabaseField>(2);
    protected transient DatabaseTable targetForeignKeyTable;
    protected transient List<DatabaseField> targetPrimaryKeyFields;
    protected transient List<Expression> sourceExpressionsToPostInitialize;
    protected transient List<Expression> targetExpressionsToPostInitialize;
    protected DataModifyQuery addTargetQuery;
    protected boolean hasCustomAddTargetQuery;
    protected Boolean shouldDeferInserts = null;
    protected DataModifyQuery removeTargetQuery;
    protected boolean hasCustomRemoveTargetQuery;
    protected DataModifyQuery removeAllTargetsQuery;
    protected boolean hasCustomRemoveAllTargetsQuery;

    public OneToManyMapping() {
        this.sourceKeyFields = NonSynchronizedVector.newInstance(1);
        this.targetForeignKeyFields = NonSynchronizedVector.newInstance(1);
        this.sourceExpressionsToPostInitialize = new CopyOnWriteArrayList<Expression>();
        this.targetExpressionsToPostInitialize = new CopyOnWriteArrayList<Expression>();
        this.deleteAllQuery = new DeleteAllQuery();
        this.removeTargetQuery = new DataModifyQuery();
        this.removeAllTargetsQuery = new DataModifyQuery();
        this.isListOrderFieldSupported = true;
    }

    @Override
    public boolean isRelationalMapping() {
        return true;
    }

    @Override
    public void addTargetForeignKeyField(DatabaseField targetForeignKeyField, DatabaseField sourceKeyField) {
        this.getTargetForeignKeyFields().addElement(targetForeignKeyField);
        this.getSourceKeyFields().addElement(sourceKeyField);
    }

    public void addTargetForeignKeyFieldName(String targetForeignKeyFieldName, String sourceKeyFieldName) {
        this.addTargetForeignKeyField(new DatabaseField(targetForeignKeyFieldName), new DatabaseField(sourceKeyFieldName));
    }

    @Override
    protected void buildListOrderField() {
        if (this.listOrderField.hasTableName()) {
            if (!this.targetForeignKeyTable.equals(this.listOrderField.getTable())) {
                throw DescriptorException.listOrderFieldTableIsWrong(this.getDescriptor(), this, this.listOrderField.getTable(), this.targetForeignKeyTable);
            }
        } else {
            this.listOrderField.setTable(this.targetForeignKeyTable);
        }
        this.listOrderField = this.getReferenceDescriptor().buildField(this.listOrderField, this.targetForeignKeyTable);
    }

    protected Expression buildDefaultSelectionCriteriaAndAddFieldsToQuery() {
        Expression selectionCriteria = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        for (DatabaseField targetForeignKey : this.getTargetForeignKeysToSourceKeys().keySet()) {
            DatabaseField sourceKey = this.getTargetForeignKeysToSourceKeys().get(targetForeignKey);
            Expression partialSelectionCriteria = ((Expression)builder).getField(targetForeignKey).equal(builder.getParameter(sourceKey));
            selectionCriteria = partialSelectionCriteria.and(selectionCriteria);
        }
        this.getContainerPolicy().addAdditionalFieldsToQuery(this.getSelectionQuery(), builder);
        return selectionCriteria;
    }

    public Expression buildSelectionCriteria() {
        Expression selectionCriteria = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        Enumeration<DatabaseField> sourceKeys = this.getSourceKeyFields().elements();
        Enumeration<DatabaseField> targetForeignKeys = this.getTargetForeignKeyFields().elements();
        while (targetForeignKeys.hasMoreElements()) {
            DatabaseField targetForeignKey = targetForeignKeys.nextElement();
            DatabaseField sourceKey = sourceKeys.nextElement();
            Expression targetExpression = ((Expression)builder).getField(targetForeignKey);
            Expression sourceExpression = builder.getParameter(sourceKey);
            this.targetExpressionsToPostInitialize.add(targetExpression);
            this.sourceExpressionsToPostInitialize.add(sourceExpression);
            Expression partialSelectionCriteria = targetExpression.equal(sourceExpression);
            selectionCriteria = partialSelectionCriteria.and(selectionCriteria);
        }
        return selectionCriteria;
    }

    @Override
    public void collectQueryParameters(Set<DatabaseField> cacheFields) {
        for (DatabaseField field : this.getSourceKeyFields()) {
            cacheFields.add(field);
        }
    }

    @Override
    public Object clone() {
        OneToManyMapping clone = (OneToManyMapping)super.clone();
        clone.setTargetForeignKeysToSourceKeys(new HashMap<DatabaseField, DatabaseField>(this.getTargetForeignKeysToSourceKeys()));
        if (this.addTargetQuery != null) {
            clone.addTargetQuery = (DataModifyQuery)this.addTargetQuery.clone();
        }
        clone.removeTargetQuery = (DataModifyQuery)this.removeTargetQuery.clone();
        clone.removeAllTargetsQuery = (DataModifyQuery)this.removeAllTargetsQuery.clone();
        return clone;
    }

    @Override
    public Object createMapComponentFromRow(AbstractRecord dbRow, ObjectBuildingQuery query, CacheKey parentCacheKey, AbstractSession session, boolean isTargetProtected) {
        return session.executeQuery((DatabaseQuery)this.getSelectionQuery(), dbRow);
    }

    protected void deleteAll(DeleteObjectQuery query, AbstractSession session) throws DatabaseException {
        Object attribute = this.getAttributeValueFromObject(query.getObject());
        if (this.usesIndirection() && !this.indirectionPolicy.objectIsInstantiated(attribute)) {
            ((DeleteAllQuery)this.deleteAllQuery).executeDeleteAll(session.getSessionForClass(this.referenceClass), query.getTranslationRow(), new Vector(0));
            return;
        }
        Object referenceObjects = this.getRealCollectionAttributeValueFromObject(query.getObject(), session);
        if (session.isUnitOfWork() && this.containerPolicy.isEmpty(referenceObjects)) {
            return;
        }
        ((DeleteAllQuery)this.deleteAllQuery).executeDeleteAll(session.getSessionForClass(this.getReferenceClass()), query.getTranslationRow(), this.containerPolicy.vectorFor(referenceObjects, session));
    }

    protected void deleteReferenceObjectsLeftOnDatabase(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        Object objects = this.readPrivateOwnedForObject(query);
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            query.getSession().deleteObject(cp.next(iter, query.getSession()));
        }
    }

    @Override
    protected Object extractKeyFromTargetRow(AbstractRecord row, AbstractSession session) {
        int size = this.sourceKeyFields.size();
        Object[] key = new Object[size];
        ConversionManager conversionManager = session.getDatasourcePlatform().getConversionManager();
        for (int index = 0; index < size; ++index) {
            DatabaseField targetField = this.targetForeignKeyFields.get(index);
            DatabaseField sourceField = this.sourceKeyFields.get(index);
            Object value = row.get(targetField);
            try {
                value = conversionManager.convertObject(value, sourceField.getType());
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
            key[index] = value;
        }
        return new CacheId(key);
    }

    @Override
    protected Object extractBatchKeyFromRow(AbstractRecord row, AbstractSession session) {
        int size = this.sourceKeyFields.size();
        Object[] key = new Object[size];
        ConversionManager conversionManager = session.getDatasourcePlatform().getConversionManager();
        for (int index = 0; index < size; ++index) {
            DatabaseField sourceField = this.sourceKeyFields.get(index);
            Object value = row.get(sourceField);
            try {
                value = conversionManager.convertObject(value, sourceField.getType());
            }
            catch (ConversionException exception) {
                throw ConversionException.couldNotBeConverted((Object)this, this.descriptor, exception);
            }
            key[index] = value;
        }
        return new CacheId(key);
    }

    @Override
    protected ModifyQuery getDeleteAllQuery() {
        if (this.deleteAllQuery == null) {
            this.deleteAllQuery = new DeleteAllQuery();
        }
        return this.deleteAllQuery;
    }

    @Override
    public Collection getFieldsForTranslationInAggregate() {
        return this.getSourceKeyFields();
    }

    public Vector getSourceKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getSourceKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getSourceKeyFields() {
        return this.sourceKeyFields;
    }

    public Map<DatabaseField, DatabaseField> getSourceKeysToTargetForeignKeys() {
        if (this.sourceKeysToTargetForeignKeys == null) {
            this.sourceKeysToTargetForeignKeys = new HashMap<DatabaseField, DatabaseField>(2);
        }
        return this.sourceKeysToTargetForeignKeys;
    }

    @Override
    public List<DatabaseField> getTargetPrimaryKeyFields() {
        return this.targetPrimaryKeyFields;
    }

    public Vector getTargetForeignKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getTargetForeignKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getTargetForeignKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getTargetForeignKeyFields() {
        return this.targetForeignKeyFields;
    }

    public Map<DatabaseField, DatabaseField> getTargetForeignKeysToSourceKeys() {
        if (this.targetForeignKeysToSourceKeys == null) {
            this.targetForeignKeysToSourceKeys = new HashMap<DatabaseField, DatabaseField>(2);
        }
        return this.targetForeignKeysToSourceKeys;
    }

    @Override
    public boolean hasInverseConstraintDependency() {
        return true;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        if (session.hasBroker()) {
            if (this.getReferenceClass() == null) {
                throw DescriptorException.referenceClassNotSpecified(this);
            }
            session = session.getBroker().getSessionForClass(this.getReferenceClass());
        }
        super.initialize(session);
        this.getContainerPolicy().initialize(session, this.getReferenceDescriptor().getDefaultTable());
        if (this.shouldInitializeSelectionCriteria()) {
            this.setSelectionCriteria(this.buildDefaultSelectionCriteriaAndAddFieldsToQuery());
        }
        this.initializeDeleteAllQuery(session);
        if (this.requiresDataModificationEvents() || this.getContainerPolicy().requiresDataModificationEvents()) {
            this.initializeAddTargetQuery(session);
            this.initializeRemoveTargetQuery(session);
            this.initializeRemoveAllTargetsQuery(session);
        }
        if (this.getDescriptor().getTables().size() > 1) {
            DatabaseTable firstTable = this.getDescriptor().getTables().get(0);
            for (DatabaseField field : this.getSourceKeyFields()) {
                if (field.getTable().equals(firstTable)) continue;
                this.getDescriptor().setHasMultipleTableConstraintDependecy(true);
            }
        }
    }

    protected void initializeAddTargetQuery(AbstractSession session) {
        AbstractRecord modifyRow = this.createModifyRowForAddTargetQuery();
        if (modifyRow.isEmpty()) {
            return;
        }
        if (!this.hasCustomAddTargetQuery) {
            this.addTargetQuery = new DataModifyQuery();
        }
        if (!this.addTargetQuery.hasSessionName()) {
            this.addTargetQuery.setSessionName(session.getName());
        }
        if (this.hasCustomAddTargetQuery) {
            return;
        }
        DatabaseTable table = modifyRow.getFields().get(0).getTable();
        Expression whereClause = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        int size = this.targetPrimaryKeyFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField targetPrimaryKey = this.targetPrimaryKeyFields.get(index);
            Expression expression = ((Expression)builder).getField(targetPrimaryKey).equal(builder.getParameter(targetPrimaryKey));
            whereClause = expression.and(whereClause);
        }
        SQLUpdateStatement statement = new SQLUpdateStatement();
        statement.setTable(table);
        statement.setWhereClause(whereClause);
        statement.setModifyRow(modifyRow);
        this.addTargetQuery.setSQLStatement(statement);
    }

    protected AbstractRecord createModifyRowForAddTargetQuery() {
        DatabaseRecord modifyRow = new DatabaseRecord();
        this.containerPolicy.addFieldsForMapKey(modifyRow);
        if (this.listOrderField != null) {
            modifyRow.add(this.listOrderField, null);
        }
        return modifyRow;
    }

    @Override
    protected void initializeChangeOrderTargetQuery(AbstractSession session) {
        boolean hasChangeOrderTargetQuery;
        boolean bl = hasChangeOrderTargetQuery = this.changeOrderTargetQuery != null;
        if (!hasChangeOrderTargetQuery) {
            this.changeOrderTargetQuery = new DataModifyQuery();
        }
        this.changeOrderTargetQuery = new DataModifyQuery();
        if (!this.changeOrderTargetQuery.hasSessionName()) {
            this.changeOrderTargetQuery.setSessionName(session.getName());
        }
        if (hasChangeOrderTargetQuery) {
            return;
        }
        DatabaseTable table = this.listOrderField.getTable();
        Expression whereClause = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        int size = this.targetPrimaryKeyFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField targetPrimaryKey = this.targetPrimaryKeyFields.get(index);
            Expression expression = ((Expression)builder).getField(targetPrimaryKey).equal(builder.getParameter(targetPrimaryKey));
            whereClause = expression.and(whereClause);
        }
        DatabaseRecord modifyRow = new DatabaseRecord();
        modifyRow.add(this.listOrderField, null);
        SQLUpdateStatement statement = new SQLUpdateStatement();
        statement.setTable(table);
        statement.setWhereClause(whereClause);
        statement.setModifyRow(modifyRow);
        this.changeOrderTargetQuery.setSQLStatement(statement);
    }

    protected void initializeDeleteAllQuery(AbstractSession session) {
        ((DeleteAllQuery)this.getDeleteAllQuery()).setReferenceClass(this.getReferenceClass());
        this.getDeleteAllQuery().setName(this.getAttributeName());
        ((DeleteAllQuery)this.getDeleteAllQuery()).setIsInMemoryOnly(this.isCascadeOnDeleteSetOnDatabase());
        if (!this.hasCustomDeleteAllQuery()) {
            if (this.getSelectionCriteria() == null) {
                this.getDeleteAllQuery().setSelectionCriteria(this.buildDefaultSelectionCriteriaAndAddFieldsToQuery());
            } else {
                this.getDeleteAllQuery().setSelectionCriteria(this.getSelectionCriteria());
            }
        }
        if (!this.getDeleteAllQuery().hasSessionName()) {
            this.getDeleteAllQuery().setSessionName(session.getName());
        }
        if (this.getDeleteAllQuery().getPartitioningPolicy() == null) {
            this.getDeleteAllQuery().setPartitioningPolicy(this.getPartitioningPolicy());
        }
    }

    protected void initializeTargetPrimaryKeyFields() {
        int size = this.getTargetForeignKeyFields().size();
        HashSet<DatabaseTable> tables = new HashSet<DatabaseTable>();
        for (int i = 0; i < size; ++i) {
            tables.add(this.getTargetForeignKeyFields().get(i).getTable());
        }
        if (tables.size() != 1) {
            throw DescriptorException.multipleTargetForeignKeyTables(this.getDescriptor(), this, tables);
        }
        this.targetForeignKeyTable = this.getTargetForeignKeyFields().get(0).getTable();
        List<DatabaseField> defaultTablePrimaryKeyFields = this.getReferenceDescriptor().getPrimaryKeyFields();
        if (this.targetForeignKeyTable.equals(this.getReferenceDescriptor().getDefaultTable())) {
            this.targetPrimaryKeyFields = defaultTablePrimaryKeyFields;
        } else {
            int sizePk = defaultTablePrimaryKeyFields.size();
            this.targetPrimaryKeyFields = new ArrayList<DatabaseField>();
            for (int i = 0; i < sizePk; ++i) {
                this.targetPrimaryKeyFields.add(null);
            }
            Map<DatabaseField, DatabaseField> map = this.getReferenceDescriptor().getAdditionalTablePrimaryKeyFields().get(this.targetForeignKeyTable);
            for (Map.Entry<DatabaseField, DatabaseField> entry : map.entrySet()) {
                DatabaseField defaultTableField;
                DatabaseField additionalTableField;
                DatabaseField sourceField = entry.getKey();
                DatabaseField targetField = entry.getValue();
                if (sourceField.getTable().equals(this.targetForeignKeyTable)) {
                    additionalTableField = sourceField;
                    defaultTableField = targetField;
                } else {
                    defaultTableField = sourceField;
                    additionalTableField = targetField;
                }
                int index = defaultTablePrimaryKeyFields.indexOf(defaultTableField);
                this.getReferenceDescriptor().buildField(additionalTableField, this.targetForeignKeyTable);
                this.targetPrimaryKeyFields.set(index, additionalTableField);
            }
        }
    }

    protected void initializeRemoveTargetQuery(AbstractSession session) {
        if (!this.removeTargetQuery.hasSessionName()) {
            this.removeTargetQuery.setSessionName(session.getName());
        }
        if (this.hasCustomRemoveTargetQuery) {
            return;
        }
        DatabaseTable table = this.targetForeignKeyFields.get(0).getTable();
        Expression whereClause = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        int size = this.targetPrimaryKeyFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField targetPrimaryKey = this.targetPrimaryKeyFields.get(index);
            Expression expression = ((Expression)builder).getField(targetPrimaryKey).equal(builder.getParameter(targetPrimaryKey));
            whereClause = expression.and(whereClause);
        }
        DatabaseRecord modifyRow = new DatabaseRecord();
        if (this.shouldRemoveTargetQueryModifyTargetForeignKey()) {
            size = this.targetForeignKeyFields.size();
            for (int index = 0; index < size; ++index) {
                DatabaseField targetForeignKey = this.targetForeignKeyFields.get(index);
                modifyRow.put(targetForeignKey, (Object)null);
                Expression expression = ((Expression)builder).getField(targetForeignKey).equal(builder.getParameter(targetForeignKey));
                whereClause = expression.and(whereClause);
            }
        }
        if (this.listOrderField != null) {
            modifyRow.add(this.listOrderField, null);
        }
        SQLUpdateStatement statement = new SQLUpdateStatement();
        statement.setTable(table);
        statement.setWhereClause(whereClause);
        statement.setModifyRow(modifyRow);
        this.removeTargetQuery.setSQLStatement(statement);
    }

    @Override
    protected void initializeReferenceDescriptor(AbstractSession session) throws DescriptorException {
        super.initializeReferenceDescriptor(session);
        if (!this.isSourceKeySpecified()) {
            this.setSourceKeyFields(NonSynchronizedVector.newInstance(this.getDescriptor().getPrimaryKeyFields()));
        }
        this.initializeTargetForeignKeysToSourceKeys();
        if (this.usesIndirection()) {
            for (DatabaseField field : this.getSourceKeyFields()) {
                field.setKeepInRow(true);
            }
        }
        if (this.requiresDataModificationEvents() || this.getContainerPolicy().requiresDataModificationEvents()) {
            this.initializeTargetPrimaryKeyFields();
        }
    }

    protected void initializeRemoveAllTargetsQuery(AbstractSession session) {
        if (!this.removeAllTargetsQuery.hasSessionName()) {
            this.removeAllTargetsQuery.setSessionName(session.getName());
        }
        if (this.hasCustomRemoveAllTargetsQuery) {
            return;
        }
        DatabaseTable table = this.targetForeignKeyFields.get(0).getTable();
        Expression whereClause = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        DatabaseRecord modifyRow = new DatabaseRecord();
        int size = this.targetForeignKeyFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField targetForeignKey = this.targetForeignKeyFields.get(index);
            if (this.shouldRemoveTargetQueryModifyTargetForeignKey()) {
                modifyRow.put(targetForeignKey, (Object)null);
            }
            Expression expression = ((Expression)builder).getField(targetForeignKey).equal(builder.getParameter(targetForeignKey));
            whereClause = expression.and(whereClause);
        }
        if (this.listOrderField != null) {
            modifyRow.add(this.listOrderField, null);
        }
        SQLUpdateStatement statement = new SQLUpdateStatement();
        statement.setTable(table);
        statement.setWhereClause(whereClause);
        statement.setModifyRow(modifyRow);
        this.removeAllTargetsQuery.setSQLStatement(statement);
    }

    protected void initializeTargetForeignKeysToSourceKeys() throws DescriptorException {
        DatabaseField field;
        int index;
        if (this.getTargetForeignKeyFields().isEmpty()) {
            if (this.shouldInitializeSelectionCriteria() || this.requiresDataModificationEvents() || this.getContainerPolicy().requiresDataModificationEvents()) {
                throw DescriptorException.noTargetForeignKeysSpecified(this);
            }
            return;
        }
        if (this.getTargetForeignKeyFields().size() != this.getSourceKeyFields().size()) {
            throw DescriptorException.targetForeignKeysSizeMismatch(this);
        }
        for (index = 0; index < this.getTargetForeignKeyFields().size(); ++index) {
            field = this.getReferenceDescriptor().buildField(this.getTargetForeignKeyFields().get(index));
            this.getTargetForeignKeyFields().set(index, field);
        }
        for (index = 0; index < this.getSourceKeyFields().size(); ++index) {
            field = this.getDescriptor().buildField(this.getSourceKeyFields().get(index));
            this.getSourceKeyFields().set(index, field);
        }
        Iterator<DatabaseField> targetForeignKeys = this.getTargetForeignKeyFields().iterator();
        Iterator<DatabaseField> sourceKeys = this.getSourceKeyFields().iterator();
        while (targetForeignKeys.hasNext()) {
            DatabaseField targetForeignKey = targetForeignKeys.next();
            DatabaseField sourcePrimaryKey = sourceKeys.next();
            this.getTargetForeignKeysToSourceKeys().put(targetForeignKey, sourcePrimaryKey);
            this.getSourceKeysToTargetForeignKeys().put(sourcePrimaryKey, targetForeignKey);
        }
    }

    @Override
    public boolean isOneToManyMapping() {
        return true;
    }

    protected boolean isSourceKeySpecified() {
        return !this.getSourceKeyFields().isEmpty();
    }

    @Override
    protected void objectAddedDuringUpdate(ObjectLevelModifyQuery query, Object objectAdded, ObjectChangeSet changeSet, Map extraData) throws DatabaseException, OptimisticLockException {
        super.objectAddedDuringUpdate(query, objectAdded, changeSet, extraData);
        if (this.requiresDataModificationEvents() || this.containerPolicy.requiresDataModificationEvents()) {
            if (query.shouldCascadeOnlyDependentParts()) {
                if (this.shouldDeferInsert()) {
                    Object[] event = new Object[]{ObjectAdded, query, objectAdded, extraData};
                    query.getSession().getCommitManager().addDataModificationEvent(this, event);
                } else {
                    ContainerPolicy cp = this.getContainerPolicy();
                    this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getDescriptor(), query.getSession());
                    AbstractRecord keyRow = this.buildKeyRowForTargetUpdate(query);
                    ClassDescriptor referenceDesc = this.getReferenceDescriptor();
                    AbstractSession session = query.getSession();
                    AbstractRecord databaseRow = referenceDesc.getObjectBuilder().buildRow(keyRow, objectAdded, session, DatabaseMapping.WriteType.INSERT);
                    ContainerPolicy.copyMapDataToRow(cp.getKeyMappingDataForWriteQuery(objectAdded, query.getSession()), databaseRow);
                    if (this.listOrderField != null && extraData != null) {
                        databaseRow.put(this.listOrderField, extraData.get(this.listOrderField));
                    }
                    InsertObjectQuery insertQuery = this.getInsertObjectQuery(session, referenceDesc);
                    insertQuery.setObject(objectAdded);
                    insertQuery.setCascadePolicy(query.getCascadePolicy());
                    insertQuery.setTranslationRow(databaseRow);
                    insertQuery.setModifyRow(databaseRow);
                    insertQuery.setIsPrepared(false);
                    query.getSession().executeQuery(insertQuery);
                }
            } else {
                this.updateTargetForeignKeyPostUpdateSource_ObjectAdded(query, objectAdded, extraData);
            }
        }
    }

    @Override
    protected void objectRemovedDuringUpdate(ObjectLevelModifyQuery query, Object objectDeleted, Map extraData) throws DatabaseException, OptimisticLockException {
        if (!this.isPrivateOwned() && (this.requiresDataModificationEvents() || this.containerPolicy.requiresDataModificationEvents())) {
            if (query.shouldCascadeOnlyDependentParts()) {
                Object[] event = new Object[]{ObjectRemoved, query, objectDeleted};
                query.getSession().getCommitManager().addDataModificationEvent(this, event);
            } else {
                this.updateTargetForeignKeyPostUpdateSource_ObjectRemoved(query, objectDeleted);
            }
        }
        super.objectRemovedDuringUpdate(query, objectDeleted, extraData);
    }

    @Override
    public void performDataModificationEvent(Object[] event, AbstractSession session) throws DatabaseException, DescriptorException {
        if (event[0] == PostInsert) {
            this.updateTargetRowPostInsertSource((WriteObjectQuery)event[1]);
        } else if (event[0] == ObjectRemoved) {
            this.updateTargetForeignKeyPostUpdateSource_ObjectRemoved((WriteObjectQuery)event[1], event[2]);
        } else if (event[0] == ObjectAdded) {
            this.updateTargetForeignKeyPostUpdateSource_ObjectAdded((WriteObjectQuery)event[1], event[2], (Map)event[3]);
        } else {
            throw DescriptorException.invalidDataModificationEventCode(event[0], this);
        }
    }

    @Override
    public void postInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.isReadOnly()) {
            return;
        }
        if (this.shouldObjectModifyCascadeToParts(query) && !query.shouldCascadeOnlyDependentParts()) {
            Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
            ContainerPolicy cp = this.getContainerPolicy();
            Object iter = cp.iteratorFor(objects);
            while (cp.hasNext(iter)) {
                Object wrappedObject = cp.nextEntry(iter, query.getSession());
                Object object = cp.unwrapIteratorResult(wrappedObject);
                if (this.isPrivateOwned()) {
                    InsertObjectQuery insertQuery = new InsertObjectQuery();
                    insertQuery.setIsExecutionClone(true);
                    insertQuery.setObject(object);
                    insertQuery.setCascadePolicy(query.getCascadePolicy());
                    query.getSession().executeQuery(insertQuery);
                } else if (!query.getSession().getCommitManager().isCommitInPreModify(object)) {
                    WriteObjectQuery writeQuery = new WriteObjectQuery();
                    writeQuery.setIsExecutionClone(true);
                    writeQuery.setObject(object);
                    writeQuery.setCascadePolicy(query.getCascadePolicy());
                    query.getSession().executeQuery(writeQuery);
                }
                cp.propogatePostInsert(query, wrappedObject);
            }
        }
        if (this.requiresDataModificationEvents() || this.getContainerPolicy().requiresDataModificationEvents()) {
            if (query.shouldCascadeOnlyDependentParts()) {
                if (this.requiresDataModificationEvents() || this.containerPolicy.shouldUpdateForeignKeysPostInsert()) {
                    if (this.shouldDeferInsert()) {
                        Object[] event = new Object[]{PostInsert, query};
                        query.getSession().getCommitManager().addDataModificationEvent(this, event);
                    } else {
                        Object objects;
                        ContainerPolicy cp = this.getContainerPolicy();
                        if (cp.isEmpty(objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession()))) {
                            return;
                        }
                        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getDescriptor(), query.getSession());
                        AbstractRecord keyRow = this.buildKeyRowForTargetUpdate(query);
                        ClassDescriptor referenceDesc = this.getReferenceDescriptor();
                        AbstractSession session = query.getSession();
                        int objectIndex = 0;
                        Object iter = cp.iteratorFor(objects);
                        while (cp.hasNext(iter)) {
                            DatabaseRecord row = new DatabaseRecord();
                            row.mergeFrom(keyRow);
                            Object wrappedObject = cp.nextEntry(iter, query.getSession());
                            Object object = cp.unwrapIteratorResult(wrappedObject);
                            AbstractRecord databaseRow = referenceDesc.getObjectBuilder().buildRow(row, object, session, DatabaseMapping.WriteType.INSERT);
                            ContainerPolicy.copyMapDataToRow(cp.getKeyMappingDataForWriteQuery(wrappedObject, session), databaseRow);
                            if (this.listOrderField != null) {
                                databaseRow.put(this.listOrderField, (Object)objectIndex++);
                            }
                            InsertObjectQuery insertQuery = this.getInsertObjectQuery(session, referenceDesc);
                            insertQuery.setObject(object);
                            insertQuery.setCascadePolicy(query.getCascadePolicy());
                            insertQuery.setTranslationRow(databaseRow);
                            insertQuery.setModifyRow(databaseRow);
                            insertQuery.setIsPrepared(false);
                            query.getSession().executeQuery(insertQuery);
                        }
                    }
                }
            } else if (this.requiresDataModificationEvents() || this.containerPolicy.shouldUpdateForeignKeysPostInsert()) {
                this.updateTargetRowPostInsertSource(query);
            }
        }
    }

    @Override
    public void postInitializeSourceAndTargetExpressions() {
        DatabaseField field;
        ObjectBuilder objectBuilder;
        ClassDescriptor descriptor;
        if (this.sourceExpressionsToPostInitialize != null && this.sourceExpressionsToPostInitialize.size() > 0) {
            descriptor = this.getDescriptor();
            objectBuilder = descriptor.getObjectBuilder();
            for (Expression expression : this.sourceExpressionsToPostInitialize) {
                field = null;
                if (expression.isParameterExpression()) {
                    field = ((ParameterExpression)expression).getField();
                } else if (expression.isFieldExpression()) {
                    field = ((FieldExpression)expression).getField();
                }
                if (field == null || field.getType() != null && field.getTypeName() != null) continue;
                field.setType(objectBuilder.getFieldClassification(field));
            }
        }
        if (this.targetExpressionsToPostInitialize != null && this.targetExpressionsToPostInitialize.size() > 0) {
            descriptor = this.getReferenceDescriptor();
            objectBuilder = descriptor.getObjectBuilder();
            for (Expression expression : this.targetExpressionsToPostInitialize) {
                field = null;
                if (expression.isParameterExpression()) {
                    field = ((ParameterExpression)expression).getField();
                } else if (expression.isFieldExpression()) {
                    field = ((FieldExpression)expression).getField();
                }
                if (field == null || field.getType() != null && field.getTypeName() != null) continue;
                field.setType(objectBuilder.getFieldClassification(field));
            }
        }
    }

    @Override
    public void postUpdate(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.isReadOnly) {
            return;
        }
        if (!this.requiresDataModificationEvents() && !this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(query.getObject())) {
            return;
        }
        if (query.getObjectChangeSet() != null) {
            this.writeChanges(query.getObjectChangeSet(), query);
        } else {
            this.compareObjectsAndWrite(query);
        }
    }

    @Override
    protected Expression buildBatchCriteria(ExpressionBuilder builder, ObjectLevelReadQuery query) {
        int size = this.targetForeignKeyFields.size();
        if (size > 1) {
            ArrayList<Expression> fields = new ArrayList<Expression>(size);
            for (DatabaseField targetForeignKeyField : this.targetForeignKeyFields) {
                fields.add(builder.getField(targetForeignKeyField));
            }
            return query.getSession().getPlatform().buildBatchCriteriaForComplexId(builder, fields);
        }
        return query.getSession().getPlatform().buildBatchCriteria(builder, builder.getField(this.targetForeignKeyFields.get(0)));
    }

    @Override
    public void preDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            if (this.listOrderField != null) {
                this.updateTargetRowPreDeleteSource(query);
            }
            return;
        }
        AbstractSession session = query.getSession();
        if (this.mustDeleteReferenceObjectsOneByOne()) {
            Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), session);
            ContainerPolicy cp = this.getContainerPolicy();
            if (this.isCascadeOnDeleteSetOnDatabase && session.isUnitOfWork()) {
                Object iterator = cp.iteratorFor(objects);
                while (cp.hasNext(iterator)) {
                    Object wrappedObject = cp.nextEntry(iterator, session);
                    Object object = cp.unwrapIteratorResult(wrappedObject);
                    ((UnitOfWorkImpl)session).getCascadeDeleteObjects().add(object);
                }
            }
            int cascade = query.getCascadePolicy();
            Object iterator = cp.iteratorFor(objects);
            while (cp.hasNext(iterator)) {
                Object wrappedObject = cp.nextEntry(iterator, session);
                Object object = cp.unwrapIteratorResult(wrappedObject);
                if (session.getCommitManager().isCommitCompletedInPostOrIgnore(object) && !this.containerPolicy.propagatesEventsToCollection()) continue;
                if (session.isUnitOfWork() && ((UnitOfWorkImpl)session).isObjectNew(object)) {
                    session.getCommitManager().markIgnoreCommit(object);
                    continue;
                }
                DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
                deleteQuery.setIsExecutionClone(true);
                deleteQuery.setObject(object);
                deleteQuery.setCascadePolicy(cascade);
                session.executeQuery(deleteQuery);
                this.containerPolicy.propogatePreDelete(deleteQuery, wrappedObject);
            }
            if (!session.isUnitOfWork()) {
                this.deleteReferenceObjectsLeftOnDatabase(query);
            }
        } else {
            this.deleteAll(query, session);
        }
    }

    @Override
    public void prepareCascadeLockingPolicy() {
        CascadeLockingPolicy policy = new CascadeLockingPolicy(this.getDescriptor(), this.getReferenceDescriptor());
        policy.setQueryKeyFields(this.getSourceKeysToTargetForeignKeys());
        this.getReferenceDescriptor().addCascadeLockingPolicy(policy);
    }

    public boolean requiresDataModificationEvents() {
        return this.listOrderField != null;
    }

    public void setCustomAddTargetQuery(DataModifyQuery query) {
        this.addTargetQuery = query;
        this.hasCustomAddTargetQuery = true;
    }

    public void setAddTargetSQLString(String sqlString) {
        DataModifyQuery query = new DataModifyQuery();
        query.setSQLString(sqlString);
        this.setCustomAddTargetQuery(query);
    }

    public void setCustomRemoveTargetQuery(DataModifyQuery query) {
        this.removeTargetQuery = query;
        this.hasCustomRemoveTargetQuery = true;
    }

    public void setCustomRemoveAllTargetsQuery(DataModifyQuery query) {
        this.removeAllTargetsQuery = query;
        this.hasCustomRemoveAllTargetsQuery = true;
    }

    @Override
    public void setDeleteAllSQLString(String sqlString) {
        DeleteAllQuery query = new DeleteAllQuery();
        query.setSQLString(sqlString);
        this.setCustomDeleteAllQuery(query);
    }

    @Override
    public void setSessionName(String name) {
        super.setSessionName(name);
        if (this.addTargetQuery != null) {
            this.addTargetQuery.setSessionName(name);
        }
        this.removeTargetQuery.setSessionName(name);
        this.removeAllTargetsQuery.setSessionName(name);
    }

    public void setSourceKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setSourceKeyFields(fields);
    }

    public void setSourceKeyFields(Vector<DatabaseField> sourceKeyFields) {
        this.sourceKeyFields = sourceKeyFields;
    }

    public void setTargetForeignKeyFieldName(String targetForeignKeyFieldName) {
        this.getTargetForeignKeyFields().addElement(new DatabaseField(targetForeignKeyFieldName));
    }

    public void setTargetForeignKeyFieldNames(String[] targetForeignKeyFieldNames, String[] sourceKeyFieldNames) {
        if (targetForeignKeyFieldNames.length != sourceKeyFieldNames.length) {
            throw DescriptorException.targetForeignKeysSizeMismatch(this);
        }
        for (int i = 0; i < targetForeignKeyFieldNames.length; ++i) {
            this.addTargetForeignKeyFieldName(targetForeignKeyFieldNames[i], sourceKeyFieldNames[i]);
        }
    }

    public void setTargetForeignKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setTargetForeignKeyFields(fields);
    }

    public void setTargetForeignKeyFields(Vector<DatabaseField> targetForeignKeyFields) {
        this.targetForeignKeyFields = targetForeignKeyFields;
    }

    protected void setTargetForeignKeysToSourceKeys(Map<DatabaseField, DatabaseField> targetForeignKeysToSourceKeys) {
        this.targetForeignKeysToSourceKeys = targetForeignKeysToSourceKeys;
    }

    @Override
    protected boolean shouldObjectModifyCascadeToParts(ObjectLevelModifyQuery query) {
        if (this.isReadOnly()) {
            return false;
        }
        if (this.isPrivateOwned()) {
            return true;
        }
        if (this.containerPolicy.isMappedKeyMapPolicy() && this.containerPolicy.requiresDataModificationEvents()) {
            return true;
        }
        return query.shouldCascadeAllParts();
    }

    protected boolean shouldRemoveTargetQueryModifyTargetForeignKey() {
        return this.containerPolicy.isMapPolicy();
    }

    @Override
    public boolean isCascadedLockingSupported() {
        return true;
    }

    @Override
    public boolean isJoiningSupported() {
        return true;
    }

    public void updateTargetRowPostInsertSource(WriteObjectQuery query) throws DatabaseException {
        Object objects;
        if (this.isReadOnly() || this.addTargetQuery == null) {
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        if (cp.isEmpty(objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession()))) {
            return;
        }
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getDescriptor(), query.getSession());
        AbstractRecord keyRow = this.buildKeyRowForTargetUpdate(query);
        int size = this.targetPrimaryKeyFields.size();
        int objectIndex = 0;
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            DatabaseRecord databaseRow = new DatabaseRecord();
            databaseRow.mergeFrom(keyRow);
            Object wrappedObject = cp.nextEntry(iter, query.getSession());
            Object object = cp.unwrapIteratorResult(wrappedObject);
            for (int index = 0; index < size; ++index) {
                DatabaseField targetPrimaryKey = this.targetPrimaryKeyFields.get(index);
                Object targetKeyValue = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, targetPrimaryKey, query.getSession());
                databaseRow.put(targetPrimaryKey, targetKeyValue);
            }
            ContainerPolicy.copyMapDataToRow(cp.getKeyMappingDataForWriteQuery(wrappedObject, query.getSession()), databaseRow);
            if (this.listOrderField != null) {
                databaseRow.put(this.listOrderField, (Object)objectIndex++);
            }
            query.getSession().executeQuery((DatabaseQuery)this.addTargetQuery, databaseRow);
        }
    }

    protected AbstractRecord buildKeyRowForTargetUpdate(ObjectLevelModifyQuery query) {
        return new DatabaseRecord();
    }

    public void updateTargetForeignKeyPostUpdateSource_ObjectAdded(ObjectLevelModifyQuery query, Object objectAdded, Map extraData) throws DatabaseException {
        if (this.isReadOnly() || this.addTargetQuery == null) {
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getDescriptor(), query.getSession());
        AbstractRecord databaseRow = this.buildKeyRowForTargetUpdate(query);
        int size = this.targetPrimaryKeyFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField targetPrimaryKey = this.targetPrimaryKeyFields.get(index);
            Object targetKeyValue = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(cp.unwrapIteratorResult(objectAdded), targetPrimaryKey, query.getSession());
            databaseRow.put(targetPrimaryKey, targetKeyValue);
        }
        ContainerPolicy.copyMapDataToRow(cp.getKeyMappingDataForWriteQuery(objectAdded, query.getSession()), databaseRow);
        if (this.listOrderField != null && extraData != null) {
            databaseRow.put(this.listOrderField, extraData.get(this.listOrderField));
        }
        query.getSession().executeQuery((DatabaseQuery)this.addTargetQuery, databaseRow);
    }

    public void updateTargetForeignKeyPostUpdateSource_ObjectRemoved(ObjectLevelModifyQuery query, Object objectRemoved) throws DatabaseException {
        if (this.isReadOnly) {
            return;
        }
        AbstractSession session = query.getSession();
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getDescriptor(), session);
        DatabaseRecord translationRow = new DatabaseRecord();
        int size = this.sourceKeyFields.size();
        DatabaseRecord modifyRow = new DatabaseRecord(size);
        for (int index = 0; index < size; ++index) {
            DatabaseField sourceKey = this.sourceKeyFields.get(index);
            DatabaseField targetForeignKey = this.targetForeignKeyFields.get(index);
            Object sourceKeyValue = query.getTranslationRow().get(sourceKey);
            translationRow.add(targetForeignKey, sourceKeyValue);
            modifyRow.add(targetForeignKey, null);
        }
        if (this.listOrderField != null) {
            modifyRow.add(this.listOrderField, null);
        }
        ContainerPolicy cp = this.getContainerPolicy();
        size = this.targetPrimaryKeyFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField targetPrimaryKey = this.targetPrimaryKeyFields.get(index);
            Object targetKeyValue = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(cp.unwrapIteratorResult(objectRemoved), targetPrimaryKey, session);
            translationRow.add(targetPrimaryKey, targetKeyValue);
        }
        DataModifyQuery removeQuery = (DataModifyQuery)this.removeTargetQuery.clone();
        removeQuery.setModifyRow(modifyRow);
        removeQuery.setHasModifyRow(true);
        removeQuery.setIsExecutionClone(true);
        session.executeQuery((DatabaseQuery)removeQuery, translationRow);
    }

    public void updateTargetRowPreDeleteSource(ObjectLevelModifyQuery query) throws DatabaseException {
        if (this.isReadOnly) {
            return;
        }
        int size = this.sourceKeyFields.size();
        DatabaseRecord translationRow = new DatabaseRecord(size);
        DatabaseRecord modifyRow = new DatabaseRecord(size);
        for (int index = 0; index < size; ++index) {
            DatabaseField sourceKey = this.sourceKeyFields.get(index);
            DatabaseField targetForeignKey = this.targetForeignKeyFields.get(index);
            Object sourceKeyValue = query.getTranslationRow().get(sourceKey);
            translationRow.add(targetForeignKey, sourceKeyValue);
            modifyRow.add(targetForeignKey, null);
        }
        if (this.listOrderField != null) {
            modifyRow.add(this.listOrderField, null);
        }
        DataModifyQuery removeQuery = (DataModifyQuery)this.removeAllTargetsQuery.clone();
        removeQuery.setModifyRow(modifyRow);
        removeQuery.setHasModifyRow(true);
        removeQuery.setIsExecutionClone(true);
        query.getSession().executeQuery((DatabaseQuery)removeQuery, translationRow);
    }

    @Override
    public boolean verifyDelete(Object object, AbstractSession session) throws DatabaseException {
        if (this.isPrivateOwned() || this.isCascadeRemove()) {
            Object objects = this.getRealCollectionAttributeValueFromObject(object, session);
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object iter = containerPolicy.iteratorFor(objects);
            while (containerPolicy.hasNext(iter)) {
                if (session.verifyDelete(containerPolicy.next(iter, session))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean shouldDeferInsert() {
        if (this.shouldDeferInserts == null) {
            this.shouldDeferInserts = true;
        }
        return this.shouldDeferInserts;
    }

    public void setShouldDeferInsert(boolean defer) {
        this.shouldDeferInserts = defer;
    }

    protected InsertObjectQuery getInsertObjectQuery(AbstractSession session, ClassDescriptor desc) {
        InsertObjectQuery insertQuery = desc.getQueryManager().getInsertQuery();
        if (insertQuery == null) {
            insertQuery = new InsertObjectQuery();
            insertQuery.setDescriptor(desc);
            insertQuery.checkPrepare(session, insertQuery.getTranslationRow());
        } else {
            insertQuery.checkPrepare(session, insertQuery.getTranslationRow());
            insertQuery = (InsertObjectQuery)insertQuery.clone();
        }
        insertQuery.setIsExecutionClone(true);
        return insertQuery;
    }
}

