/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.codegen;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.internal.codegen.AccessLevel;
import org.eclipse.persistence.internal.codegen.CodeGenerator;
import org.eclipse.persistence.internal.helper.Helper;

public abstract class CodeDefinition {
    protected AccessLevel accessLevel = new AccessLevel();
    protected String name = "";
    protected String comment = "";
    protected static final String JAVA_LANG_PACKAGE_NAME = "java.lang";
    protected static final String JAVA_UTIL_PACKAGE_NAME = "java.util";
    protected static final String TOPLINK_INDIRECTION_PACKAGE_NAME = "org.eclipse.persistence.indirection";

    private static boolean adjustmentNeededForType(String typeName, Map typeNameMap) {
        if (typeName == null || typeName.equals("")) {
            return false;
        }
        if (CodeDefinition.packageName(typeName).length() == 0) {
            return false;
        }
        Set packages = (Set)typeNameMap.get(CodeDefinition.shortName(typeName));
        return packages == null || packages.size() <= 1;
    }

    protected static String adjustTypeName(String typeName, Map typeNameMap) {
        if (CodeDefinition.adjustmentNeededForType(typeName, typeNameMap)) {
            CodeDefinition.putTypeNameInMap(typeName, typeNameMap);
            return typeName.substring(CodeDefinition.packageName(typeName).length() + 1);
        }
        return typeName;
    }

    protected static Set parseForTypeNames(String longString) {
        HashSet typeNames = new HashSet();
        if (longString != null) {
            typeNames.addAll(CodeDefinition.parseForTypeNamesInPackage(longString, JAVA_LANG_PACKAGE_NAME));
            typeNames.addAll(CodeDefinition.parseForTypeNamesInPackage(longString, JAVA_UTIL_PACKAGE_NAME));
            typeNames.addAll(CodeDefinition.parseForTypeNamesInPackage(longString, TOPLINK_INDIRECTION_PACKAGE_NAME));
        }
        return typeNames;
    }

    private static Set parseForTypeNamesInPackage(String longString, String packageName) {
        HashSet<String> typeNames = new HashSet<String>();
        int packageStartIndex = longString.indexOf(packageName);
        while (packageStartIndex != -1) {
            boolean lookingForEndOfTypeName = true;
            int searchIndex = packageStartIndex + packageName.length() + 1;
            while (lookingForEndOfTypeName) {
                if (Character.isJavaIdentifierPart(longString.charAt(searchIndex))) {
                    ++searchIndex;
                    continue;
                }
                lookingForEndOfTypeName = false;
            }
            typeNames.add(longString.substring(packageStartIndex, searchIndex));
            packageStartIndex = longString.indexOf(packageName, searchIndex);
        }
        return typeNames;
    }

    protected static void putTypeNameInMap(String typeName, Map typeNameMap) {
        if (typeName == null || typeName.equals("")) {
            return;
        }
        String shortName = CodeDefinition.shortName(typeName);
        String packageName = CodeDefinition.packageName(typeName);
        if (packageName.length() > 0) {
            Set<String> packageNames;
            if (typeNameMap.get(shortName) == null) {
                packageNames = new HashSet();
                typeNameMap.put(shortName, packageNames);
            } else {
                packageNames = (Set)typeNameMap.get(shortName);
            }
            if (!packageNames.contains(packageName)) {
                packageNames.add(packageName);
            }
        }
    }

    private static String packageName(String typeName) {
        int lastPeriod = typeName.lastIndexOf(46);
        if (lastPeriod == -1) {
            return "";
        }
        return typeName.substring(0, lastPeriod);
    }

    private static String shortName(String typeName) {
        int shortNameStartIndex;
        int searchIndex = shortNameStartIndex = typeName.lastIndexOf(46) + 1;
        boolean stillLookingForEnd = true;
        while (stillLookingForEnd) {
            if (Character.isJavaIdentifierPart(typeName.charAt(searchIndex))) {
                stillLookingForEnd = ++searchIndex < typeName.length();
                continue;
            }
            stillLookingForEnd = false;
        }
        return typeName.substring(shortNameStartIndex, searchIndex);
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public String getComment() {
        return this.comment;
    }

    public String getName() {
        return this.name;
    }

    public void setAccessLevel(AccessLevel accessLevel) {
        this.accessLevel = accessLevel;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        CodeGenerator generator = new CodeGenerator();
        this.write(generator);
        return generator.toString();
    }

    public void write(CodeGenerator generator) {
        if (this.getComment().length() > 0) {
            generator.writeln("/**");
            String comment = this.getComment();
            String cr = Helper.cr();
            int lastLineIndex = 0;
            int nextLineIndex = comment.indexOf(cr);
            while (nextLineIndex != -1) {
                generator.write(" * ");
                generator.write(comment.substring(lastLineIndex, nextLineIndex + cr.length()));
                lastLineIndex = nextLineIndex + cr.length();
                nextLineIndex = comment.indexOf(cr, lastLineIndex);
            }
            generator.write(" * ");
            generator.writeln(comment.substring(lastLineIndex, comment.length()));
            generator.writeln(" */");
            generator.cr();
        }
        this.getAccessLevel().write(generator);
        generator.write(" ");
        this.writeBody(generator);
    }

    public abstract void writeBody(CodeGenerator var1);
}

