/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sequencing.DefaultSequence;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.SequenceDefinition;
import org.eclipse.persistence.tools.schemaframework.SequenceObjectDefinition;

public class OracleNativeSeqInitTest
extends AutoVerifyTestCase {
    public static final int DROP_CREATE = 0;
    public static final int CREATE_CREATE = 1;
    public static final int NEXTVAL_ALTER = 2;
    public static final int CREATE_ALTER = 3;
    protected Boolean usesNativeSequencingOriginal;
    protected Sequence originalSequence;
    protected int seqPreallocationSizeOriginal;
    protected int lastSeqNumberOriginal;
    protected Boolean usesBatchWritingOriginal;
    protected Boolean shouldCacheAllStatementsOriginal;
    protected int mode;
    protected int seqPreallocationSizeOld = 10;
    protected int seqPreallocationSize = 50;
    protected int idExpected;
    protected int id;
    protected ValidationException exception;
    protected String seqName;
    protected SequenceObjectDefinition sequenceDefinition;
    protected Sequence sequence;
    protected boolean shouldUseSchemaManager;
    protected SchemaManager schemaManager;

    public OracleNativeSeqInitTest(boolean shouldUseSchemaManager, int mode) {
        this.mode = mode;
        this.shouldUseSchemaManager = shouldUseSchemaManager;
        if (shouldUseSchemaManager) {
            if (mode == 0) {
                this.setName(this.getName() + " SchemaManager DROP CREATE");
                this.setDescription("Tests SchemaManager.createObject method");
            } else if (mode == 1) {
                this.setName(this.getName() + " SchemaManager CREATE CREATE");
                this.setDescription("Tests SchemaManager.createObject method");
            } else if (mode == 2) {
                this.setName(this.getName() + " SchemaManager NEXTVAL_ALTER");
                this.setDescription("Tests SchemaManager.alterSequenceIncrement method");
            } else if (mode == 3) {
                this.setName(this.getName() + " SchemaManager CREATE_ALTER");
                this.setDescription("Tests SchemaManager.alterSequenceIncrement method");
            }
        } else if (mode == 0) {
            this.setName(this.getName() + " OracleSequenceDefinition DROP CREATE");
            this.setDescription("Tests OracleSequenceDefinition.createOnDatabase method");
        } else if (mode == 1) {
            this.setName(this.getName() + " OracleSequenceDefinition  CREATE CREATE");
            this.setDescription("Tests OracleSequenceDefinition.createOnDatabase method");
        } else if (mode == 2) {
            this.setName(this.getName() + " OracleSequenceDefinition NEXTVAL_ALTER");
            this.setDescription("Tests OracleSequenceDefinition.alterOnDatabase method");
        } else if (mode == 3) {
            this.setName(this.getName() + " OracleSequenceDefinition CREATE_ALTER");
            this.setDescription("Tests OracleSequenceDefinition.alterOnDatabase method");
        }
    }

    public void setup() {
        if (!this.getSession().getPlatform().supportsSequenceObjects()) {
            throw new TestWarningException("This test requires a platform that supports sequence objects");
        }
        ClassDescriptor descriptor = this.getSession().getDescriptor(Employee.class);
        if (!descriptor.usesSequenceNumbers()) {
            throw new TestWarningException("Employee doesn't use sequencing");
        }
        this.originalSequence = this.getSession().getPlatform().getSequence(descriptor.getSequenceNumberName());
        this.usesNativeSequencingOriginal = (this.originalSequence instanceof NativeSequence || this.originalSequence instanceof DefaultSequence && this.getSession().getPlatform().getDefaultSequence() instanceof NativeSequence) && !this.originalSequence.shouldAcquireValueAfterInsert();
        if (!this.usesNativeSequencingOriginal.booleanValue()) {
            NativeSequence newSequence = new NativeSequence(this.originalSequence.getName(), this.originalSequence.getPreallocationSize());
            newSequence.onConnect(this.originalSequence.getDatasourcePlatform());
            this.getAbstractSession().getPlatform().addSequence((Sequence)newSequence);
            this.sequence = newSequence;
        } else {
            this.sequence = this.originalSequence;
        }
        this.seqPreallocationSizeOriginal = this.originalSequence.getPreallocationSize();
        this.lastSeqNumberOriginal = this.getSession().getNextSequenceNumberValue(Employee.class).intValue() - 1;
        this.usesBatchWritingOriginal = this.getSession().getPlatform().usesBatchWriting();
        this.shouldCacheAllStatementsOriginal = this.getSession().getPlatform().shouldCacheAllStatements();
        this.getDatabaseSession().getSequencingControl().initializePreallocated();
        this.sequenceDefinition = new SequenceObjectDefinition(this.sequence);
        this.sequenceDefinition.setQualifier(this.getSession().getLogin().getTableQualifier());
        if (this.shouldUseSchemaManager) {
            this.schemaManager = new SchemaManager(this.getDatabaseSession());
            this.getSession().getPlatform().setShouldCacheAllStatements(false);
            this.getSession().getPlatform().setUsesBatchWriting(true);
            this.getSession().getPlatform().setShouldCacheAllStatements(true);
        } else {
            this.getSession().getPlatform().setUsesBatchWriting(false);
            this.getSession().getPlatform().setShouldCacheAllStatements(false);
        }
        try {
            this.drop();
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        if (this.mode == 0) {
            this.sequence.setInitialValue(1);
            this.sequence.setPreallocationSize(this.seqPreallocationSize);
            this.create();
            this.idExpected = 1;
        } else if (this.mode == 1) {
            this.sequence.setInitialValue(1);
            this.sequence.setPreallocationSize(this.seqPreallocationSizeOld);
            this.create();
            this.sequence.setInitialValue(1);
            this.sequence.setPreallocationSize(this.seqPreallocationSize);
            this.create();
            this.idExpected = 1 + this.seqPreallocationSizeOld;
        } else if (this.mode == 2) {
            this.sequence.setInitialValue(1);
            this.sequence.setPreallocationSize(this.seqPreallocationSizeOld);
            this.create();
            this.sequenceDefinition.checkIfExist((AbstractSession)this.getSession());
            this.sequence.setInitialValue(1);
            this.sequence.setPreallocationSize(this.seqPreallocationSize);
            this.alter();
            this.idExpected = 1 + this.seqPreallocationSizeOld;
        } else if (this.mode == 3) {
            this.sequence.setInitialValue(1);
            this.sequence.setPreallocationSize(this.seqPreallocationSizeOld);
            this.create();
            this.sequence.setInitialValue(1);
            this.sequence.setPreallocationSize(this.seqPreallocationSize);
            this.alter();
            this.idExpected = 1;
        }
        this.getSession().getPlatform().getSequence(descriptor.getSequenceNumberName()).setPreallocationSize(this.seqPreallocationSize);
    }

    public void test() {
        try {
            this.id = this.getSession().getNextSequenceNumberValue(Employee.class).intValue();
            this.exception = null;
        }
        catch (ValidationException ex) {
            this.id = 0;
            this.exception = ex;
        }
    }

    public void verify() {
        if (this.exception != null) {
            throw new TestErrorException("Sequence allocation failed", (Throwable)this.exception);
        }
        if (this.id != this.idExpected) {
            throw new TestErrorException("Wrong sequencing number");
        }
    }

    public void reset() {
        if (this.sequence == null) {
            return;
        }
        this.getSession().getPlatform().setShouldCacheAllStatements(false);
        this.drop();
        this.sequence.setPreallocationSize(this.seqPreallocationSizeOriginal);
        this.sequence.setInitialValue(this.lastSeqNumberOriginal + this.seqPreallocationSizeOriginal);
        this.create();
        this.getDatabaseSession().getSequencingControl().initializePreallocated();
        this.getSession().getPlatform().getSequence(this.getSession().getDescriptor(Employee.class).getSequenceNumberName()).setPreallocationSize(this.seqPreallocationSizeOriginal);
        if (this.shouldCacheAllStatementsOriginal != null) {
            this.getSession().getPlatform().setShouldCacheAllStatements(this.shouldCacheAllStatementsOriginal.booleanValue());
        }
        if (this.usesBatchWritingOriginal != null) {
            this.getSession().getPlatform().setUsesBatchWriting(this.usesBatchWritingOriginal.booleanValue());
        }
        if (this.usesNativeSequencingOriginal != null && !this.usesNativeSequencingOriginal.booleanValue()) {
            this.getAbstractSession().getPlatform().addSequence(this.originalSequence);
        }
        this.sequence = null;
    }

    protected void drop() {
        if (this.shouldUseSchemaManager) {
            this.schemaManager.dropObject((DatabaseObjectDefinition)this.sequenceDefinition);
        } else {
            this.sequenceDefinition.dropFromDatabase(this.getAbstractSession());
        }
    }

    protected void create() {
        if (this.shouldUseSchemaManager) {
            this.schemaManager.createObject((DatabaseObjectDefinition)this.sequenceDefinition);
        } else {
            this.sequenceDefinition.createOnDatabase(this.getAbstractSession());
        }
    }

    protected void alter() {
        if (this.shouldUseSchemaManager) {
            this.schemaManager.alterSequence((SequenceDefinition)this.sequenceDefinition);
        } else {
            this.sequenceDefinition.alterOnDatabase(this.getAbstractSession());
        }
    }
}

