/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.xml.complexaggregate;

import jakarta.persistence.EntityManager;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.xml.complexaggregate.CitySlicker;
import org.eclipse.persistence.testing.models.jpa.xml.complexaggregate.ComplexAggregateTableCreator;
import org.eclipse.persistence.testing.models.jpa.xml.complexaggregate.CountryDweller;
import org.eclipse.persistence.testing.models.jpa.xml.complexaggregate.HockeyPlayer;
import org.eclipse.persistence.testing.models.jpa.xml.complexaggregate.HockeyTeam;
import org.eclipse.persistence.testing.models.jpa.xml.complexaggregate.HockeyTeamDetails;
import org.eclipse.persistence.testing.models.jpa.xml.complexaggregate.HockeyTeamId;
import org.eclipse.persistence.testing.models.jpa.xml.complexaggregate.Name;
import org.eclipse.persistence.testing.models.jpa.xml.complexaggregate.PersonalVitals;
import org.eclipse.persistence.testing.models.jpa.xml.complexaggregate.Role;
import org.eclipse.persistence.testing.models.jpa.xml.complexaggregate.TeamVitals;
import org.eclipse.persistence.testing.models.jpa.xml.complexaggregate.Vitals;
import org.eclipse.persistence.testing.tests.jpa.TestingProperties;

public class EntityMappingsComplexAggregateJUnitTestCase
extends JUnitTestCase {
    private static HockeyTeamId[] teamIDs = new HockeyTeamId[3];
    private String m_persistenceUnit;

    public EntityMappingsComplexAggregateJUnitTestCase() {
    }

    public EntityMappingsComplexAggregateJUnitTestCase(String name) {
        super(name);
    }

    public EntityMappingsComplexAggregateJUnitTestCase(String name, String persistenceUnit) {
        super(name);
        this.m_persistenceUnit = persistenceUnit;
    }

    public static Test suite() {
        String ormTesting = TestingProperties.getProperty("orm.testing", "jpa");
        String persistenceUnit = ormTesting.equals("jpa") ? "default" : "extended-complex-aggregate";
        TestSuite suite = new TestSuite("Complex Aggregate Model - " + persistenceUnit);
        if (persistenceUnit.equals("extended-complex-aggregate")) {
            suite.addTest((Test)new EntityMappingsComplexAggregateJUnitTestCase("testSetup", persistenceUnit));
            suite.addTest((Test)new EntityMappingsComplexAggregateJUnitTestCase("testCreateExtendedObjects", persistenceUnit));
            suite.addTest((Test)new EntityMappingsComplexAggregateJUnitTestCase("testVerifyExtendedObjects", persistenceUnit));
            suite.addTest((Test)new EntityMappingsComplexAggregateJUnitTestCase("testAutoGenerationOnEmbeddedId", persistenceUnit));
        }
        return suite;
    }

    public void testSetup() {
        ServerSession session = JUnitTestCase.getServerSession((String)this.m_persistenceUnit);
        new ComplexAggregateTableCreator().replaceTables((DatabaseSession)session);
        EntityMappingsComplexAggregateJUnitTestCase.clearCache((String)this.m_persistenceUnit);
    }

    public void setUp() {
        super.setUp();
        EntityMappingsComplexAggregateJUnitTestCase.clearCache((String)this.m_persistenceUnit);
    }

    public void testCreateExtendedObjects() {
        HockeyTeam team1 = new HockeyTeam("Axemen");
        HockeyTeamDetails team1Details = new HockeyTeamDetails();
        team1Details.setAwayColor("Red");
        team1Details.setHomeColor("White");
        team1Details.setLevel("Division 5");
        team1.setTeamDetails(team1Details);
        HockeyTeam team2 = new HockeyTeam("Cartier Partners");
        HockeyTeamDetails team2Details = new HockeyTeamDetails();
        team2Details.setAwayColor("Black");
        team2Details.setHomeColor("White");
        team2Details.setLevel("Division 2");
        team2.setTeamDetails(team2Details);
        HockeyTeam team3 = new HockeyTeam("Dead Last");
        HockeyTeamDetails team3Details = new HockeyTeamDetails();
        team3Details.setAwayColor("Blue");
        team3Details.setHomeColor("White");
        team3Details.setLevel("Division 4");
        team3.setTeamDetails(team3Details);
        HockeyPlayer player1 = new HockeyPlayer();
        player1.setFirstName("Guy");
        player1.setLastName("Pelletier");
        PersonalVitals personalVitals1 = new PersonalVitals();
        personalVitals1.setAge(29);
        personalVitals1.setHeight(1.8);
        personalVitals1.setWeight(180.0);
        TeamVitals teamVitals1 = new TeamVitals();
        teamVitals1.setHockeyTeam(team2);
        team2.getPlayers().add(player1);
        teamVitals1.setJerseyNumber(20);
        teamVitals1.setPosition("Goalie");
        teamVitals1.getRoles().add(new Role("Stop pucks!"));
        Vitals vitals1 = new Vitals();
        vitals1.setPersonalVitals(personalVitals1);
        vitals1.setTeamVitals(teamVitals1);
        player1.setVitals(vitals1);
        HockeyPlayer player2 = new HockeyPlayer();
        player2.setFirstName("Dave");
        player2.setLastName("McCann");
        PersonalVitals personalVitals2 = new PersonalVitals();
        personalVitals2.setAge(35);
        personalVitals2.setHeight(1.77);
        personalVitals2.setWeight(165.0);
        TeamVitals teamVitals2 = new TeamVitals();
        teamVitals2.setHockeyTeam(team1);
        team1.getPlayers().add(player2);
        teamVitals2.setJerseyNumber(70);
        teamVitals2.setPosition("Left wing");
        teamVitals2.getRoles().add(new Role("Power play unit"));
        teamVitals2.getRoles().add(new Role("Face-off specialist"));
        Vitals vitals2 = new Vitals();
        vitals2.setPersonalVitals(personalVitals2);
        vitals2.setTeamVitals(teamVitals2);
        player2.setVitals(vitals2);
        HockeyPlayer player3 = new HockeyPlayer();
        player3.setFirstName("Tom");
        player3.setLastName("Ware");
        PersonalVitals personalVitals3 = new PersonalVitals();
        personalVitals3.setAge(30);
        personalVitals3.setHeight(1.83);
        personalVitals3.setWeight(200.0);
        TeamVitals teamVitals3 = new TeamVitals();
        teamVitals3.setHockeyTeam(team1);
        team1.getPlayers().add(player3);
        teamVitals3.setJerseyNumber(12);
        teamVitals3.setPosition("Defence");
        teamVitals3.getRoles().add(new Role("Penalty kill unit"));
        Vitals vitals3 = new Vitals();
        vitals3.setPersonalVitals(personalVitals3);
        vitals3.setTeamVitals(teamVitals3);
        player3.setVitals(vitals3);
        HockeyPlayer player4 = new HockeyPlayer();
        player4.setFirstName("George");
        player4.setLastName("Robinson");
        PersonalVitals personalVitals4 = new PersonalVitals();
        personalVitals4.setAge(32);
        personalVitals4.setHeight(1.86);
        personalVitals4.setWeight(210.0);
        TeamVitals teamVitals4 = new TeamVitals();
        teamVitals4.setHockeyTeam(team3);
        team3.getPlayers().add(player4);
        teamVitals4.setJerseyNumber(6);
        teamVitals4.setPosition("Center");
        teamVitals4.getRoles().add(new Role("Power play unit"));
        teamVitals4.getRoles().add(new Role("Goon"));
        Vitals vitals4 = new Vitals();
        vitals4.setPersonalVitals(personalVitals4);
        vitals4.setTeamVitals(teamVitals4);
        player4.setVitals(vitals4);
        HockeyPlayer player5 = new HockeyPlayer();
        player5.setFirstName("Andrew");
        player5.setLastName("Glennie");
        PersonalVitals personalVitals5 = new PersonalVitals();
        personalVitals5.setAge(31);
        personalVitals5.setHeight(1.8);
        personalVitals5.setWeight(205.0);
        TeamVitals teamVitals5 = new TeamVitals();
        teamVitals5.setHockeyTeam(team3);
        team3.getPlayers().add(player5);
        teamVitals5.setJerseyNumber(7);
        teamVitals5.setPosition("Right wing");
        Vitals vitals5 = new Vitals();
        vitals5.setPersonalVitals(personalVitals5);
        vitals5.setTeamVitals(teamVitals5);
        player5.setVitals(vitals5);
        HockeyPlayer player6 = new HockeyPlayer();
        player6.setFirstName("David");
        player6.setLastName("Whittaker");
        PersonalVitals personalVitals6 = new PersonalVitals();
        personalVitals6.setAge(32);
        personalVitals6.setHeight(1.83);
        personalVitals6.setWeight(190.0);
        TeamVitals teamVitals6 = new TeamVitals();
        teamVitals6.setHockeyTeam(team2);
        team2.getPlayers().add(player6);
        teamVitals6.setJerseyNumber(17);
        teamVitals6.setPosition("Defence");
        Vitals vitals6 = new Vitals();
        vitals6.setPersonalVitals(personalVitals6);
        vitals6.setTeamVitals(teamVitals6);
        player6.setVitals(vitals6);
        EntityManager em = EntityMappingsComplexAggregateJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        try {
            this.beginTransaction(em);
            em.persist((Object)team1);
            EntityMappingsComplexAggregateJUnitTestCase.teamIDs[0] = team1.getId();
            em.persist((Object)team2);
            EntityMappingsComplexAggregateJUnitTestCase.teamIDs[1] = team2.getId();
            em.persist((Object)team3);
            EntityMappingsComplexAggregateJUnitTestCase.teamIDs[2] = team3.getId();
            em.persist((Object)player1);
            em.persist((Object)player2);
            em.persist((Object)player3);
            em.persist((Object)player4);
            em.persist((Object)player5);
            em.persist((Object)player6);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testVerifyExtendedObjects() {
        this.checkTeam(teamIDs[0]);
        this.checkTeam(teamIDs[1]);
        this.checkTeam(teamIDs[2]);
        EntityMappingsComplexAggregateJUnitTestCase.clearCache((String)this.m_persistenceUnit);
        this.checkTeam(teamIDs[0]);
        this.checkTeam(teamIDs[1]);
        this.checkTeam(teamIDs[2]);
    }

    private void checkTeam(HockeyTeamId id) {
        EntityManager em = EntityMappingsComplexAggregateJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        HockeyTeam team = (HockeyTeam)em.find(HockeyTeam.class, (Object)id);
        EntityMappingsComplexAggregateJUnitTestCase.assertFalse((String)("Hockey team with ID: " + id + ", was not created."), (team == null ? 1 : 0) != 0);
        EntityMappingsComplexAggregateJUnitTestCase.assertTrue((String)("Hockey team with ID: " + id + ", did not have 2 players added."), (team.getPlayers().size() == 2 ? 1 : 0) != 0);
    }

    public void testAutoGenerationOnEmbeddedId() {
        EntityManager em = EntityMappingsComplexAggregateJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        try {
            Name name1 = new Name();
            name1.setFirstName("Tom");
            name1.setLastName("Ware");
            CountryDweller countryDweller = new CountryDweller();
            countryDweller.setAge(30);
            countryDweller.setName(name1);
            CitySlicker citySlicker = new CitySlicker();
            citySlicker.setAge(53);
            Name name1Clone = (Name)name1.clone();
            citySlicker.setName(name1Clone);
            Name name2 = new Name();
            name2.setFirstName("Guy");
            name2.setLastName("Pelletier");
            CountryDweller countryDweller2 = new CountryDweller();
            countryDweller2.setAge(65);
            countryDweller2.setName(name2);
            this.beginTransaction(em);
            em.persist((Object)countryDweller);
            em.persist((Object)countryDweller2);
            em.persist((Object)citySlicker);
            this.commitTransaction(em);
            EntityMappingsComplexAggregateJUnitTestCase.clearCache((String)this.m_persistenceUnit);
            this.beginTransaction(em);
            CitySlicker cs = (CitySlicker)em.find(CitySlicker.class, (Object)name1Clone);
            CountryDweller cd = (CountryDweller)em.merge((Object)countryDweller);
            CountryDweller cd2 = (CountryDweller)em.merge((Object)countryDweller2);
            em.remove((Object)cs);
            em.remove((Object)cd);
            em.remove((Object)cd2);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }
}

