/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fetchgroups;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;

public class FetchGroupTrackerWeavingTests
extends JUnitTestCase {
    String checkAttribute = null;
    String checkForSetAttribute = null;

    public FetchGroupTrackerWeavingTests() {
    }

    public FetchGroupTrackerWeavingTests(String name) {
        super(name);
    }

    public void runBare() throws Throwable {
        if (this.shouldRunTestOnServer()) {
            super.runBare();
        } else if (this.isWeavingEnabled()) {
            super.runBare();
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("FetchGroupTrackerWeavingTests");
        suite.addTest((Test)new FetchGroupTrackerWeavingTests("testSetup"));
        suite.addTest((Test)new FetchGroupTrackerWeavingTests("verifyCheckFetchedForSetWithFetchGroup"));
        suite.addTest((Test)new FetchGroupTrackerWeavingTests("verifyCheckFetchedWithFetchGroup"));
        suite.addTest((Test)new FetchGroupTrackerWeavingTests("verifyCheckFetchedForSetWithFetchGroup_OneToOne"));
        suite.addTest((Test)new FetchGroupTrackerWeavingTests("verifyCheckFetchedWithFetchGroup_OneToOne"));
        suite.addTest((Test)new FetchGroupTrackerWeavingTests("verifyCheckFetchedForSetWithFetchGroup_OneToMany"));
        suite.addTest((Test)new FetchGroupTrackerWeavingTests("verifyCheckFetchedWithFetchGroup_OneToMany"));
        return suite;
    }

    public void tearDown() {
        this.checkAttribute = null;
        this.checkForSetAttribute = null;
    }

    @org.junit.Test
    public void testSetup() {
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        if (FetchGroupTrackerWeavingTests.getServerSession().getPlatform().isPostgreSQL()) {
            FetchGroupTrackerWeavingTests.getServerSession().getLogin().setShouldForceFieldNamesToUpperCase(true);
        }
    }

    @org.junit.Test
    public void verifyCheckFetchedForSetWithFetchGroup() {
        Employee emp = new Employee();
        TestFetchGroup fg = new TestFetchGroup();
        ((FetchGroupTracker)emp)._persistence_setFetchGroup((FetchGroup)fg);
        FetchGroupTrackerWeavingTests.assertNull((Object)this.checkAttribute);
        FetchGroupTrackerWeavingTests.assertNull((Object)this.checkForSetAttribute);
        emp.setFirstName("John");
        FetchGroupTrackerWeavingTests.assertNull((Object)this.checkAttribute);
        FetchGroupTrackerWeavingTests.assertNotNull((Object)this.checkForSetAttribute);
        FetchGroupTrackerWeavingTests.assertEquals((String)"firstName", (String)this.checkForSetAttribute);
    }

    @org.junit.Test
    public void verifyCheckFetchedWithFetchGroup() {
        Employee emp = new Employee();
        TestFetchGroup fg = new TestFetchGroup();
        ((FetchGroupTracker)emp)._persistence_setFetchGroup((FetchGroup)fg);
        FetchGroupTrackerWeavingTests.assertNull((Object)this.checkAttribute);
        FetchGroupTrackerWeavingTests.assertNull((Object)this.checkForSetAttribute);
        emp.getFirstName();
        FetchGroupTrackerWeavingTests.assertNull((Object)this.checkForSetAttribute);
        FetchGroupTrackerWeavingTests.assertNotNull((Object)this.checkAttribute);
        FetchGroupTrackerWeavingTests.assertEquals((String)"firstName", (String)this.checkAttribute);
    }

    @org.junit.Test
    public void verifyCheckFetchedForSetWithFetchGroup_OneToOne() {
        Employee emp = new Employee();
        TestFetchGroup fg = new TestFetchGroup();
        ((FetchGroupTracker)emp)._persistence_setFetchGroup((FetchGroup)fg);
        FetchGroupTrackerWeavingTests.assertNull((Object)this.checkAttribute);
        FetchGroupTrackerWeavingTests.assertNull((Object)this.checkForSetAttribute);
        emp.setAddress(new Address());
        FetchGroupTrackerWeavingTests.assertNull((Object)this.checkAttribute);
        FetchGroupTrackerWeavingTests.assertNotNull((Object)this.checkForSetAttribute);
        FetchGroupTrackerWeavingTests.assertEquals((String)"address", (String)this.checkForSetAttribute);
    }

    @org.junit.Test
    public void verifyCheckFetchedWithFetchGroup_OneToOne() {
        Employee emp = new Employee();
        TestFetchGroup fg = new TestFetchGroup();
        ((FetchGroupTracker)emp)._persistence_setFetchGroup((FetchGroup)fg);
        FetchGroupTrackerWeavingTests.assertNull((Object)this.checkAttribute);
        FetchGroupTrackerWeavingTests.assertNull((Object)this.checkForSetAttribute);
        Address addr = emp.getAddress();
        FetchGroupTrackerWeavingTests.assertNull((Object)addr);
        FetchGroupTrackerWeavingTests.assertNull((Object)this.checkForSetAttribute);
        FetchGroupTrackerWeavingTests.assertNotNull((Object)this.checkAttribute);
        FetchGroupTrackerWeavingTests.assertEquals((String)"address", (String)this.checkAttribute);
    }

    @org.junit.Test
    public void verifyCheckFetchedForSetWithFetchGroup_OneToMany() {
        Employee emp = new Employee();
        TestFetchGroup fg = new TestFetchGroup();
        ((FetchGroupTracker)emp)._persistence_setFetchGroup((FetchGroup)fg);
        FetchGroupTrackerWeavingTests.assertNull((Object)this.checkAttribute);
        FetchGroupTrackerWeavingTests.assertNull((Object)this.checkForSetAttribute);
        emp.setPhoneNumbers(new ArrayList());
        FetchGroupTrackerWeavingTests.assertNull((Object)this.checkAttribute);
        FetchGroupTrackerWeavingTests.assertNotNull((Object)this.checkForSetAttribute);
        FetchGroupTrackerWeavingTests.assertEquals((String)"phoneNumbers", (String)this.checkForSetAttribute);
    }

    @org.junit.Test
    public void verifyCheckFetchedWithFetchGroup_OneToMany() {
        Employee emp = new Employee();
        TestFetchGroup fg = new TestFetchGroup();
        ((FetchGroupTracker)emp)._persistence_setFetchGroup((FetchGroup)fg);
        FetchGroupTrackerWeavingTests.assertNull((Object)this.checkAttribute);
        FetchGroupTrackerWeavingTests.assertNull((Object)this.checkForSetAttribute);
        Collection phones = emp.getPhoneNumbers();
        FetchGroupTrackerWeavingTests.assertNotNull((Object)phones);
        FetchGroupTrackerWeavingTests.assertTrue((boolean)phones.isEmpty());
        FetchGroupTrackerWeavingTests.assertNull((Object)this.checkForSetAttribute);
        FetchGroupTrackerWeavingTests.assertNotNull((Object)this.checkAttribute);
        FetchGroupTrackerWeavingTests.assertEquals((String)"phoneNumbers", (String)this.checkAttribute);
    }

    class TestFetchGroup
    extends FetchGroup {
        TestFetchGroup() {
        }

        public String onUnfetchedAttribute(FetchGroupTracker entity, String attributeName) {
            FetchGroupTrackerWeavingTests.this.checkAttribute = attributeName;
            return null;
        }

        public String onUnfetchedAttributeForSet(FetchGroupTracker entity, String attributeName) {
            FetchGroupTrackerWeavingTests.this.checkForSetAttribute = attributeName;
            return null;
        }
    }
}

