/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.dynamic.simple.mappings;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.exceptions.DynamicException;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicTypeBuilder;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.testing.tests.jpa.dynamic.DynamicTestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SimpleTypes_OneToOne {
    static EntityManagerFactory emf = null;
    static JPADynamicHelper helper = null;

    @BeforeClass
    public static void setUp() {
        emf = DynamicTestHelper.createEMF("dynamic");
        helper = new JPADynamicHelper(emf);
        DynamicClassLoader dcl = helper.getDynamicClassLoader();
        Class simpleTypeB = dcl.createDynamicClass("model.SimpleB");
        JPADynamicTypeBuilder bFactory = new JPADynamicTypeBuilder(simpleTypeB, null, new String[]{"SIMPLE_TYPE_B"});
        bFactory.setPrimaryKeyFields(new String[]{"SID"});
        bFactory.addDirectMapping("id", Integer.TYPE, "SID");
        bFactory.addDirectMapping("value1", String.class, "VAL_1");
        Class simpleTypeA = dcl.createDynamicClass("model.SimpleA");
        JPADynamicTypeBuilder aFactory = new JPADynamicTypeBuilder(simpleTypeA, null, new String[]{"SIMPLE_TYPE_A"});
        aFactory.setPrimaryKeyFields(new String[]{"SID"});
        aFactory.addDirectMapping("id", Integer.TYPE, "SID");
        aFactory.addDirectMapping("value1", String.class, "VAL_1");
        aFactory.addOneToOneMapping("b", bFactory.getType(), new String[]{"B_FK"}).setCascadePersist(true);
        helper.addTypes(true, true, new DynamicType[]{aFactory.getType(), bFactory.getType()});
    }

    @AfterClass
    public static void shutdown() {
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        em.createNativeQuery("DROP TABLE SIMPLE_TYPE_A").executeUpdate();
        em.createNativeQuery("DROP TABLE SIMPLE_TYPE_B").executeUpdate();
        em.getTransaction().commit();
        em.close();
        emf.close();
    }

    @After
    public void clearDynamicTables() {
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        em.createQuery("DELETE FROM SimpleA").executeUpdate();
        em.createQuery("DELETE FROM SimpleB").executeUpdate();
        em.getTransaction().commit();
        em.close();
    }

    @Test
    public void verifyConfig() throws Exception {
        ClassDescriptor descriptorA = helper.getSession().getClassDescriptorForAlias("SimpleA");
        Assert.assertNotNull((String)"No descriptor found for alias='SimpleA'", (Object)descriptorA);
        DynamicType simpleTypeA = helper.getType("SimpleA");
        Assert.assertNotNull((String)"'SimpleA' EntityType not found", (Object)simpleTypeA);
        Assert.assertEquals((Object)descriptorA, (Object)simpleTypeA.getDescriptor());
        DirectToFieldMapping a_id = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("id");
        Assert.assertEquals(Integer.TYPE, (Object)a_id.getAttributeClassification());
        DirectToFieldMapping a_value1 = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("value1");
        Assert.assertEquals(String.class, (Object)a_value1.getAttributeClassification());
        ClassDescriptor descriptorB = helper.getSession().getClassDescriptorForAlias("SimpleB");
        Assert.assertNotNull((String)"No descriptor found for alias='SimpleB'", (Object)descriptorB);
        DynamicType simpleTypeB = helper.getType("SimpleB");
        Assert.assertNotNull((String)"'SimpleB' EntityType not found", (Object)simpleTypeB);
        Assert.assertEquals((Object)descriptorB, (Object)simpleTypeB.getDescriptor());
        DirectToFieldMapping b_id = (DirectToFieldMapping)descriptorB.getMappingForAttributeName("id");
        Assert.assertEquals(Integer.TYPE, (Object)b_id.getAttributeClassification());
        DirectToFieldMapping b_value1 = (DirectToFieldMapping)descriptorB.getMappingForAttributeName("value1");
        Assert.assertEquals(String.class, (Object)b_value1.getAttributeClassification());
        OneToOneMapping a_b = (OneToOneMapping)descriptorA.getMappingForAttributeName("b");
        Assert.assertEquals((Object)descriptorB, (Object)a_b.getReferenceDescriptor());
    }

    @Test
    public void createSimpleA() {
        DynamicType simpleTypeA = helper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        EntityManager em = emf.createEntityManager();
        DynamicEntity simpleInstance = simpleTypeA.newDynamicEntity();
        simpleInstance.set("id", (Object)1);
        simpleInstance.set("value1", (Object)"A1");
        em.getTransaction().begin();
        em.persist((Object)simpleInstance);
        em.getTransaction().commit();
        int simpleCount = ((Number)em.createQuery("SELECT COUNT(s) FROM SimpleA s").getSingleResult()).intValue();
        Assert.assertEquals((long)1L, (long)simpleCount);
        em.close();
    }

    @Test
    public void createSimpleB() {
        DynamicType simpleTypeB = helper.getType("SimpleB");
        Assert.assertNotNull((Object)simpleTypeB);
        EntityManager em = emf.createEntityManager();
        DynamicEntity simpleInstance = simpleTypeB.newDynamicEntity();
        simpleInstance.set("id", (Object)1);
        simpleInstance.set("value1", (Object)"B1");
        em.getTransaction().begin();
        em.persist((Object)simpleInstance);
        em.getTransaction().commit();
        int simpleCount = ((Number)em.createQuery("SELECT COUNT(s) FROM SimpleB s").getSingleResult()).intValue();
        Assert.assertEquals((long)1L, (long)simpleCount);
        em.close();
    }

    @Test
    public void createSimpleAwithSimpleB() {
        DynamicType simpleTypeA = helper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        DynamicType simpleTypeB = helper.getType("SimpleB");
        Assert.assertNotNull((Object)simpleTypeB);
        EntityManager em = emf.createEntityManager();
        Assert.assertNotNull((Object)JpaHelper.getServerSession((EntityManagerFactory)emf).getDescriptorForAlias("SimpleB"));
        DynamicEntity simpleInstanceB = simpleTypeB.newDynamicEntity();
        simpleInstanceB.set("id", (Object)2);
        simpleInstanceB.set("value1", (Object)"B2");
        DynamicEntity simpleInstanceA = simpleTypeA.newDynamicEntity();
        simpleInstanceA.set("id", (Object)2);
        simpleInstanceA.set("value1", (Object)"A2");
        simpleInstanceA.set("b", (Object)simpleInstanceB);
        em.getTransaction().begin();
        em.persist((Object)simpleInstanceB);
        em.persist((Object)simpleInstanceA);
        em.getTransaction().commit();
        int simpleCountB = ((Number)em.createQuery("SELECT COUNT(s) FROM SimpleB s").getSingleResult()).intValue();
        Assert.assertEquals((long)1L, (long)simpleCountB);
        int simpleCountA = ((Number)em.createQuery("SELECT COUNT(s) FROM SimpleA s").getSingleResult()).intValue();
        Assert.assertEquals((long)1L, (long)simpleCountA);
        em.close();
    }

    @Test(expected=DynamicException.class)
    public void invalidTypeSet() {
        DynamicType simpleTypeA = helper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        DynamicType simpleTypeB = helper.getType("SimpleB");
        Assert.assertNotNull((Object)simpleTypeB);
        Assert.assertNotNull((Object)JpaHelper.getServerSession((EntityManagerFactory)emf).getDescriptorForAlias("SimpleB"));
        DynamicEntity simpleInstanceB = simpleTypeB.newDynamicEntity();
        simpleInstanceB.set("id", (Object)2);
        simpleInstanceB.set("value1", (Object)"B2");
        DynamicEntity simpleInstanceA = simpleTypeA.newDynamicEntity();
        simpleInstanceA.set("id", (Object)2);
        simpleInstanceA.set("value1", (Object)"A2");
        simpleInstanceA.set("b", (Object)simpleInstanceA);
    }
}

