/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.datetime;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.datetime.DateTime;
import org.eclipse.persistence.testing.models.jpa.datetime.DateTimeTableCreator;

public class NullBindingJUnitTestCase
extends JUnitTestCase {
    private static int datetimeId;

    public NullBindingJUnitTestCase() {
    }

    public NullBindingJUnitTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Null Binding DateTime");
        suite.addTest((Test)new NullBindingJUnitTestCase("testSetup"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testCreateDateTime"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testNullifySqlDate"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testNullifyLocalDate"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testNullifyLocalTime"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testNullifyLocalDateTime"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testNullifyTime"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testNullifyTimestamp"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testNullifyUtilDate"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testNullifyCalendar"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testDateTimeMap"));
        return suite;
    }

    public void testSetup() {
        new DateTimeTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public void testCreateDateTime() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        DateTime dt = new DateTime();
        em.persist((Object)dt);
        datetimeId = dt.getId();
        this.commitTransaction(em);
    }

    public void testNullifySqlDate() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            DateTime dt = (DateTime)em.find(DateTime.class, (Object)datetimeId);
            dt.setDate(null);
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT dt FROM DateTime dt WHERE dt.id = " + datetimeId);
            DateTime dt2 = (DateTime)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting java.sql.Date field to null", (dt2.getDate() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testNullifyLocalDate() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            DateTime dt = (DateTime)em.find(DateTime.class, (Object)datetimeId);
            dt.setLocalDate(null);
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT dt FROM DateTime dt WHERE dt.id = " + datetimeId);
            DateTime dt2 = (DateTime)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting java.time.LocalDateTime field to null", (dt2.getLocalDate() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testNullifyLocalTime() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            DateTime dt = (DateTime)em.find(DateTime.class, (Object)datetimeId);
            dt.setLocalTime(null);
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT dt FROM DateTime dt WHERE dt.id = " + datetimeId);
            DateTime dt2 = (DateTime)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting java.time.LocalDateTime field to null", (dt2.getLocalTime() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testNullifyLocalDateTime() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            DateTime dt = (DateTime)em.find(DateTime.class, (Object)datetimeId);
            dt.setLocalDateTime(null);
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT dt FROM DateTime dt WHERE dt.id = " + datetimeId);
            DateTime dt2 = (DateTime)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting java.time.LocalDateTime field to null", (dt2.getLocalDateTime() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testNullifyOffsetTime() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            DateTime dt = (DateTime)em.find(DateTime.class, (Object)datetimeId);
            dt.setOffsetTime(null);
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT dt FROM DateTime dt WHERE dt.id = " + datetimeId);
            DateTime dt2 = (DateTime)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting java.time.LocalDateTime field to null", (dt2.getOffsetTime() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testNullifyOffsetDateTime() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            DateTime dt = (DateTime)em.find(DateTime.class, (Object)datetimeId);
            dt.setOffsetDateTime(null);
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT dt FROM DateTime dt WHERE dt.id = " + datetimeId);
            DateTime dt2 = (DateTime)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting java.time.LocalDateTime field to null", (dt2.getOffsetDateTime() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testNullifyTime() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            DateTime dt = (DateTime)em.find(DateTime.class, (Object)datetimeId);
            dt.setTime(null);
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT dt FROM DateTime dt WHERE dt.id = " + datetimeId);
            DateTime dt2 = (DateTime)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting java.sql.Time field to null", (dt2.getTime() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testNullifyTimestamp() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            DateTime dt = (DateTime)em.find(DateTime.class, (Object)datetimeId);
            dt.setTimestamp(null);
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT dt FROM DateTime dt WHERE dt.id = " + datetimeId);
            DateTime dt2 = (DateTime)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting java.sql.Timestamp field to null", (dt2.getTimestamp() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testNullifyUtilDate() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            DateTime dt = (DateTime)em.find(DateTime.class, (Object)datetimeId);
            dt.setUtilDate(null);
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT dt FROM DateTime dt WHERE dt.id = " + datetimeId);
            DateTime dt2 = (DateTime)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting java.util.Date field to null", (dt2.getUtilDate() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testNullifyCalendar() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            DateTime dt = (DateTime)em.find(DateTime.class, (Object)datetimeId);
            dt.setCalendar(null);
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT dt FROM DateTime dt WHERE dt.id = " + datetimeId);
            DateTime dt2 = (DateTime)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting java.util.Calendar field to null", (dt2.getCalendar() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testDateTimeMap() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            DateTime dt = (DateTime)em.find(DateTime.class, (Object)datetimeId);
            NullBindingJUnitTestCase.assertNotNull((Object)dt);
            Map map = dt.getUniSelfMap();
            NullBindingJUnitTestCase.assertNotNull((Object)map);
            NullBindingJUnitTestCase.assertTrue((boolean)map.values().contains(dt));
            this.closeEntityManagerAndTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }
}

