/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.datatypes;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.datatypes.DataTypesTableCreator;
import org.eclipse.persistence.testing.models.jpa.datatypes.WrapperTypes;

public class BooleanJUnitTestCase
extends JUnitTestCase {
    public BooleanJUnitTestCase() {
    }

    public BooleanJUnitTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Boolean DataTypes");
        suite.addTest((Test)new BooleanJUnitTestCase("testSetup"));
        suite.addTest((Test)new BooleanJUnitTestCase("testCreateWrapperTypes"));
        suite.addTest((Test)new BooleanJUnitTestCase("testBoolean"));
        return suite;
    }

    public void testSetup() {
        new DataTypesTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public void testCreateWrapperTypes() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        WrapperTypes[] wrapperTypes = new WrapperTypes[]{new WrapperTypes(BigDecimal.ZERO, BigInteger.ZERO, Boolean.FALSE, new Byte("0"), Character.valueOf('A'), new Short("0"), Integer.valueOf(0), Long.valueOf(0L), new Float(0.0), Double.valueOf(0.0), "A String"), new WrapperTypes(BigDecimal.ONE, BigInteger.ONE, Boolean.TRUE, new Byte("1"), Character.valueOf('B'), new Short("1"), Integer.valueOf(1), Long.valueOf(1L), new Float(1.0), Double.valueOf(1.0), "B String"), new WrapperTypes(new BigDecimal(2), new BigInteger("2"), Boolean.FALSE, new Byte("2"), Character.valueOf('C'), new Short("2"), Integer.valueOf(2), Long.valueOf(2L), new Float(2.0), Double.valueOf(2.0), "C String"), new WrapperTypes(new BigDecimal(3), new BigInteger("3"), Boolean.TRUE, new Byte("3"), Character.valueOf('D'), new Short("3"), Integer.valueOf(3), Long.valueOf(3L), new Float(3.0), Double.valueOf(3.0), "D String")};
        for (WrapperTypes wrapperType : wrapperTypes) {
            em.persist((Object)wrapperType);
        }
        this.commitTransaction(em);
    }

    public void testBoolean() {
        EntityManager em = this.createEntityManager();
        try {
            Query q = em.createQuery("SELECT wt.booleanData FROM WrapperTypes wt");
            List result = q.getResultList();
            BooleanJUnitTestCase.assertTrue((String)"Not all boolean rows are selected", (result.size() == 4 ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            this.closeEntityManager(em);
            throw e;
        }
    }
}

