/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced.concurrency;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.sessions.RepeatableWriteUnitOfWork;
import org.eclipse.persistence.testing.models.jpa.advanced.ConcurrencyB;
import org.eclipse.persistence.testing.models.jpa.advanced.ConcurrencyC;

public class TransitionRunner1
implements Runnable {
    protected ConcurrencyB concB;
    protected ConcurrencyC concC;
    protected EntityManagerFactory emf;
    protected Object toWaitOn;

    public TransitionRunner1(Object toWaitOn, ConcurrencyB concB, ConcurrencyC concC, EntityManagerFactory emf) {
        this.concB = concB;
        this.concC = concC;
        this.emf = emf;
        this.toWaitOn = toWaitOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        EntityManager em = this.emf.createEntityManager();
        ConcurrencyB b = (ConcurrencyB)em.find(ConcurrencyB.class, (Object)this.concB.getId());
        ConcurrencyC c = (ConcurrencyC)em.find(ConcurrencyC.class, (Object)this.concC.getId());
        c.setName(System.currentTimeMillis() + "_C");
        b.setName(System.currentTimeMillis() + "_B");
        RepeatableWriteUnitOfWork uow = ((EntityManagerImpl)em).getActivePersistenceContext(null);
        try {
            Object object = this.toWaitOn;
            synchronized (object) {
                this.toWaitOn.wait(120000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        uow.issueSQLbeforeCompletion(true);
        try {
            Object e = this.toWaitOn;
            synchronized (e) {
                this.toWaitOn.notifyAll();
                this.toWaitOn.wait(6000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        uow.release();
    }
}

