/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.math.BigInteger;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.LargeProject;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.models.jpa.advanced.SmallProject;
import org.eclipse.persistence.testing.models.jpa.inheritance.Boat;
import org.eclipse.persistence.testing.models.jpa.inheritance.Bus;
import org.eclipse.persistence.testing.models.jpa.inheritance.Car;
import org.eclipse.persistence.testing.models.jpa.inheritance.Company;
import org.eclipse.persistence.testing.models.jpa.inheritance.InheritanceTableCreator;
import org.eclipse.persistence.testing.models.jpa.inheritance.Jalopy;
import org.eclipse.persistence.testing.models.jpa.inheritance.NonFueledVehicle;
import org.eclipse.persistence.testing.models.jpa.inheritance.OffRoadTireInfo;
import org.eclipse.persistence.testing.models.jpa.inheritance.PassengerPerformanceTireInfo;
import org.eclipse.persistence.testing.models.jpa.inheritance.PerformanceTireInfo;
import org.eclipse.persistence.testing.models.jpa.inheritance.Person;
import org.eclipse.persistence.testing.models.jpa.inheritance.SportsCar;
import org.eclipse.persistence.testing.models.jpa.inheritance.TireInfo;
import org.eclipse.persistence.testing.models.jpa.inheritance.Vehicle;
import org.eclipse.persistence.testing.models.jpa.inherited.BeerConsumer;
import org.eclipse.persistence.testing.models.jpa.inherited.Blue;
import org.eclipse.persistence.testing.models.jpa.inherited.BlueLight;
import org.eclipse.persistence.testing.models.jpa.inherited.InheritedTableManager;

public class QueryCastTestSuite
extends JUnitTestCase {
    public QueryCastTestSuite() {
    }

    public QueryCastTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("QueryCastTestSuite");
        suite.addTest((Test)new QueryCastTestSuite("testSetup"));
        suite.addTest((Test)new QueryCastTestSuite("testDowncastOneToManyLeafQueryKey"));
        suite.addTest((Test)new QueryCastTestSuite("testDowncastOneToManyMidHierarchyQueryKey"));
        suite.addTest((Test)new QueryCastTestSuite("testDowncastManyToManyQueryKey"));
        suite.addTest((Test)new QueryCastTestSuite("testDowncastOneToManyLeafExpressionBuilder"));
        suite.addTest((Test)new QueryCastTestSuite("testDowncastOneToManyMidHierarchyExpressionBuilder"));
        suite.addTest((Test)new QueryCastTestSuite("testDowncastManyToManyExpressionBuilder"));
        suite.addTest((Test)new QueryCastTestSuite("testDowncastInSelect"));
        suite.addTest((Test)new QueryCastTestSuite("testDowncastSingleTableQueryKey"));
        suite.addTest((Test)new QueryCastTestSuite("testDoubleDowncastOneToManyLeafQueryKey"));
        suite.addTest((Test)new QueryCastTestSuite("testDoubleDowncastSeparateClass"));
        suite.addTest((Test)new QueryCastTestSuite("testDowncastRelationshipTraversal"));
        suite.addTest((Test)new QueryCastTestSuite("testDoubleDowncastOneToOne"));
        suite.addTest((Test)new QueryCastTestSuite("testSelectCast"));
        suite.addTest((Test)new QueryCastTestSuite("testCastInSubselect"));
        suite.addTest((Test)new QueryCastTestSuite("testDowncastWithFetchJoin"));
        suite.addTest((Test)new QueryCastTestSuite("testDoubleTreatOnRoot"));
        suite.addTest((Test)new QueryCastTestSuite("testDoubleTreatOnRootSTI"));
        suite.addTest((Test)new QueryCastTestSuite("testTreatInSelect"));
        suite.addTest((Test)new QueryCastTestSuite("testTreatInSelectSTI"));
        suite.addTest((Test)new QueryCastTestSuite("testTreatInFrom"));
        suite.addTest((Test)new QueryCastTestSuite("testTreatInFromSTI"));
        suite.addTest((Test)new QueryCastTestSuite("testTreatInWhere"));
        suite.addTest((Test)new QueryCastTestSuite("testTreatInWhereSTI"));
        suite.addTest((Test)new QueryCastTestSuite("testTreatUsingAndOr"));
        suite.addTest((Test)new QueryCastTestSuite("testTreatUsingAndOrSTI"));
        suite.addTest((Test)new QueryCastTestSuite("testTreatUsingJoinOverDowncastRelationship"));
        suite.addTest((Test)new QueryCastTestSuite("testReturningTypeOnTreat"));
        suite.addTest((Test)new QueryCastTestSuite("testReturningTypeOnTreatSTI"));
        return suite;
    }

    public void testSetup() {
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        new InheritanceTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        new InheritedTableManager().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        if (QueryCastTestSuite.getServerSession().getPlatform().isPostgreSQL()) {
            QueryCastTestSuite.getServerSession().getLogin().setShouldForceFieldNamesToUpperCase(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDowncastOneToManyLeafQueryKey() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Company company = new Company();
            company.setName("Acme");
            em.persist((Object)company);
            Boat boat = new Boat();
            boat.setModel("speed");
            em.persist((Object)boat);
            Car car = new Car();
            car.setDescription("A car");
            em.persist((Object)car);
            company.getVehicles().add(boat);
            boat.setOwner(company);
            company.getVehicles().add(car);
            car.setOwner(company);
            company = new Company();
            company.setName("WidgetCo");
            em.persist((Object)company);
            boat = new Boat();
            boat.setModel("fishing");
            em.persist((Object)boat);
            company.getVehicles().add(boat);
            boat.setOwner(company);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select c from Company c join treat(c.vehicles as Boat) b where b.model = 'speed'");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)("Incorrect results returned, expected 1 but returned " + resultList.size()), (resultList.size() == 1 ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDowncastOneToManyMidHierarchyQueryKey() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Company company = new Company();
            company.setName("Acme");
            em.persist((Object)company);
            Boat boat = new Boat();
            boat.setModel("speed");
            em.persist((Object)boat);
            Car car = new Car();
            car.setDescription("A car");
            em.persist((Object)car);
            NonFueledVehicle nfv = new NonFueledVehicle();
            nfv.setColor("Blue");
            em.persist((Object)nfv);
            company.getVehicles().add(nfv);
            nfv.setOwner(company);
            company.getVehicles().add(boat);
            boat.setOwner(company);
            company.getVehicles().add(car);
            car.setOwner(company);
            company = new Company();
            company.setName("WidgetCo");
            em.persist((Object)company);
            nfv = new NonFueledVehicle();
            nfv.setColor("Red");
            em.persist((Object)nfv);
            company.getVehicles().add(nfv);
            nfv.setOwner(company);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select c from Company c join treat(c.vehicles as NonFueledVehicle) v where v.color = 'Blue'");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 1 ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDowncastManyToManyQueryKey() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            LargeProject proj = new LargeProject();
            proj.setBudget(1000.0);
            proj.setName("test1");
            em.persist((Object)proj);
            SmallProject sp = new SmallProject();
            sp.setName("sp1");
            em.persist((Object)sp);
            Employee emp = new Employee();
            emp.setFirstName("Reggie");
            emp.setLastName("Josephson");
            emp.addProject((Project)proj);
            proj.addTeamMember(emp);
            emp.addProject((Project)sp);
            sp.addTeamMember(emp);
            em.persist((Object)emp);
            emp = new Employee();
            emp.setFirstName("Ron");
            emp.setLastName("Josephson");
            emp.addProject((Project)sp);
            sp.addTeamMember(emp);
            em.persist((Object)emp);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select e from Employee e join treat(e.projects as LargeProject) p where p.budget > 100");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 1 ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDowncastOneToManyLeafExpressionBuilder() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Company company = new Company();
            company.setName("Acme");
            em.persist((Object)company);
            Boat boat = new Boat();
            boat.setModel("speed");
            em.persist((Object)boat);
            Car car = new Car();
            car.setDescription("A car");
            em.persist((Object)car);
            company.getVehicles().add(boat);
            boat.setOwner(company);
            company.getVehicles().add(car);
            car.setOwner(company);
            company = new Company();
            company.setName("WidgetCo");
            em.persist((Object)company);
            boat = new Boat();
            boat.setModel("fishing");
            em.persist((Object)boat);
            company.getVehicles().add(boat);
            boat.setOwner(company);
            em.flush();
            this.clearCache();
            em.clear();
            JpaQuery query = (JpaQuery)em.createQuery("Select v from Vehicle v");
            ReadAllQuery raq = new ReadAllQuery(Vehicle.class);
            query.setDatabaseQuery((DatabaseQuery)raq);
            ExpressionBuilder exp = raq.getExpressionBuilder();
            Expression criteria = exp.treat(Boat.class).get("model").equal((Object)"speed");
            raq.setSelectionCriteria(criteria);
            List resultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 1 ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDowncastOneToManyMidHierarchyExpressionBuilder() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Company company = new Company();
            company.setName("Acme");
            em.persist((Object)company);
            Boat boat = new Boat();
            boat.setModel("speed");
            boat.setColor("Blue");
            em.persist((Object)boat);
            Car car = new Car();
            car.setDescription("A car");
            em.persist((Object)car);
            NonFueledVehicle nfv = new NonFueledVehicle();
            nfv.setColor("Blue");
            em.persist((Object)nfv);
            company.getVehicles().add(nfv);
            nfv.setOwner(company);
            company.getVehicles().add(boat);
            boat.setOwner(company);
            company.getVehicles().add(car);
            car.setOwner(company);
            company = new Company();
            company.setName("WidgetCo");
            em.persist((Object)company);
            nfv = new NonFueledVehicle();
            nfv.setColor("Red");
            em.persist((Object)nfv);
            company.getVehicles().add(nfv);
            nfv.setOwner(company);
            em.flush();
            this.clearCache();
            em.clear();
            JpaQuery query = (JpaQuery)em.createQuery("Select v from Vehicle v");
            ReadAllQuery raq = new ReadAllQuery(Vehicle.class);
            query.setDatabaseQuery((DatabaseQuery)raq);
            ExpressionBuilder exp = raq.getExpressionBuilder();
            Expression criteria = exp.treat(NonFueledVehicle.class).get("color").equal((Object)"Blue");
            raq.setSelectionCriteria(criteria);
            List resultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 2 ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDowncastManyToManyExpressionBuilder() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            LargeProject proj = new LargeProject();
            proj.setBudget(1000.0);
            proj.setName("test1");
            em.persist((Object)proj);
            SmallProject sp = new SmallProject();
            sp.setName("sp1");
            em.persist((Object)sp);
            Employee emp = new Employee();
            emp.setFirstName("Reggie");
            emp.setLastName("Josephson");
            emp.addProject((Project)proj);
            proj.addTeamMember(emp);
            emp.addProject((Project)sp);
            sp.addTeamMember(emp);
            em.persist((Object)emp);
            emp = new Employee();
            emp.setFirstName("Ron");
            emp.setLastName("Josephson");
            emp.addProject((Project)sp);
            sp.addTeamMember(emp);
            em.persist((Object)emp);
            em.flush();
            this.clearCache();
            em.clear();
            JpaQuery query = (JpaQuery)em.createQuery("Select p from Project p");
            ReadAllQuery raq = new ReadAllQuery(Project.class);
            query.setDatabaseQuery((DatabaseQuery)raq);
            ExpressionBuilder exp = raq.getExpressionBuilder();
            Expression criteria = exp.treat(LargeProject.class).get("budget").greaterThan(100);
            raq.setSelectionCriteria(criteria);
            List resultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 1 ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDowncastInSelect() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            LargeProject proj = new LargeProject();
            proj.setBudget(1000.0);
            proj.setName("test1");
            em.persist((Object)proj);
            SmallProject sp = new SmallProject();
            sp.setName("sp1");
            em.persist((Object)sp);
            em.flush();
            this.clearCache();
            em.clear();
            ExpressionBuilder builder = new ExpressionBuilder(Project.class);
            ReportQuery rq = new ReportQuery(Project.class, builder);
            rq.addAttribute("project", builder.treat(LargeProject.class).get("budget"));
            rq.setSelectionCriteria(builder.type().equal(LargeProject.class));
            List resultList = (List)((JpaEntityManager)em.getDelegate()).getActiveSession().executeQuery((DatabaseQuery)rq);
            QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 1 ? 1 : 0) != 0);
            Query query = em.createQuery("Select treat(c as LargeProject).budget from Project c");
            List JPQLresultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (JPQLresultList.size() == 1 ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDowncastSingleTableQueryKey() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer consumer = new BeerConsumer();
            consumer.setName("John");
            em.persist((Object)consumer);
            Blue blue = new Blue();
            blue.setAlcoholContent((Object)Float.valueOf(5.0f));
            blue.setUniqueKey(new BigInteger("4531"));
            em.persist((Object)blue);
            BlueLight blueLight = new BlueLight();
            blueLight.setDiscount(10);
            blueLight.setUniqueKey(new BigInteger("4533"));
            em.persist((Object)blueLight);
            consumer.addBlueBeerToConsume((Blue)blueLight);
            blueLight.setBeerConsumer(consumer);
            consumer.addBlueBeerToConsume(blue);
            consumer.addBlueBeerToConsume((Blue)blueLight);
            consumer = new BeerConsumer();
            consumer.setName("Frank");
            em.persist((Object)consumer);
            blueLight = new BlueLight();
            blueLight.setDiscount(5);
            blueLight.setUniqueKey(new BigInteger("4532"));
            em.persist((Object)blueLight);
            consumer.addBlueBeerToConsume((Blue)blueLight);
            blueLight.setBeerConsumer(consumer);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select b from BeerConsumer b join treat(b.blueBeersToConsume as BlueLight) bl where bl.discount = 10");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 1 ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDoubleDowncastOneToManyLeafQueryKey() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Company company = new Company();
            company.setName("Acme");
            em.persist((Object)company);
            Boat boat = new Boat();
            boat.setModel("speed");
            em.persist((Object)boat);
            Car car = new Car();
            car.setDescription("A car");
            car.setFuelType("unleaded");
            em.persist((Object)car);
            company.getVehicles().add(boat);
            boat.setOwner(company);
            company.getVehicles().add(car);
            car.setOwner(company);
            company = new Company();
            company.setName("WidgetCo");
            em.persist((Object)company);
            boat = new Boat();
            boat.setModel("fishing");
            em.persist((Object)boat);
            company.getVehicles().add(boat);
            boat.setOwner(company);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select c from Company c join treat(c.vehicles as Boat) b where b.model = 'speed' or b.model = 'fishing'");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 2 ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDoubleDowncastSeparateClass() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Company company = new Company();
            company.setName("Acme");
            em.persist((Object)company);
            Boat boat = new Boat();
            boat.setModel("speed");
            em.persist((Object)boat);
            Car car = new Car();
            car.setDescription("A car");
            car.setFuelType("unleaded");
            em.persist((Object)car);
            company.getVehicles().add(boat);
            boat.setOwner(company);
            company.getVehicles().add(car);
            car.setOwner(company);
            company = new Company();
            company.setName("WidgetCo");
            em.persist((Object)company);
            boat = new Boat();
            boat.setModel("fishing");
            em.persist((Object)boat);
            company.getVehicles().add(boat);
            boat.setOwner(company);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select distinct c from Company c left join treat(c.vehicles as Boat) b left join treat(c.vehicles as FueledVehicle) f where b.model = 'fishing' or f.fuelType = 'unleaded'");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 2 ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDowncastRelationshipTraversal() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Company company = new Company();
            company.setName("Acme");
            em.persist((Object)company);
            Boat boat = new Boat();
            boat.setModel("speed");
            em.persist((Object)boat);
            Bus bus = new Bus();
            bus.setDescription("A bus");
            bus.setFuelType("unleaded");
            em.persist((Object)bus);
            Person person = new Person();
            person.setName("Driver");
            bus.setBusDriver(person);
            em.persist((Object)person);
            company.getVehicles().add(boat);
            boat.setOwner(company);
            company.getVehicles().add(bus);
            bus.setOwner(company);
            company = new Company();
            company.setName("WidgetCo");
            em.persist((Object)company);
            bus = new Bus();
            bus.setDescription("B bus");
            bus.setFuelType("unleaded");
            em.persist((Object)bus);
            person = new Person();
            person.setName("Driver2");
            bus.setBusDriver(person);
            em.persist((Object)person);
            company.getVehicles().add(boat);
            boat.setOwner(company);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select distinct c from Company c left join treat(c.vehicles as Bus) b where b.busDriver.name = 'Driver'");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 1 ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDoubleDowncastOneToOne() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Person rudy = new Person();
            rudy.setName("Rudy");
            em.persist((Object)rudy);
            SportsCar sportsCar = new SportsCar();
            sportsCar.setMaxSpeed(200);
            em.persist((Object)sportsCar);
            rudy.setCar((Car)sportsCar);
            Person theo = new Person();
            theo.setName("Theo");
            em.persist((Object)theo);
            Jalopy car = new Jalopy();
            car.setColor("Red");
            car.setPercentRust(20);
            em.persist((Object)car);
            theo.setCar((Car)car);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select distinct p from Person p left join treat(p.car as SportsCar) s left join treat(p.car as Jalopy) j where s.maxSpeed = 200 or j.percentRust = 20");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 2 ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSelectCast() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            LargeProject proj = new LargeProject();
            proj.setBudget(1000.0);
            proj.setName("test1");
            em.persist((Object)proj);
            LargeProject lp = new LargeProject();
            lp.setBudget(100.0);
            lp.setName("sp1");
            em.persist((Object)lp);
            Employee emp = new Employee();
            emp.setFirstName("Reggie");
            emp.setLastName("Josephson");
            emp.addProject((Project)proj);
            proj.addTeamMember(emp);
            emp.addProject((Project)lp);
            lp.addTeamMember(emp);
            em.persist((Object)emp);
            emp = new Employee();
            emp.setFirstName("Ron");
            emp.setLastName("Josephson");
            emp.addProject((Project)lp);
            lp.addTeamMember(emp);
            em.persist((Object)emp);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select max(l.budget) from Employee e join treat(e.projects as LargeProject) l");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)"Incorrect result size returned", (resultList.size() == 1 ? 1 : 0) != 0);
            QueryCastTestSuite.assertTrue((String)"Incorrect results returned", ((Double)resultList.get(0) == 1000.0 ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCastInSubselect() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            LargeProject proj = new LargeProject();
            proj.setBudget(1000.0);
            proj.setName("test1");
            em.persist((Object)proj);
            LargeProject lp = new LargeProject();
            lp.setBudget(100.0);
            lp.setName("sp1");
            em.persist((Object)lp);
            Employee emp = new Employee();
            emp.setFirstName("Reggie");
            emp.setLastName("Josephson");
            emp.addProject((Project)proj);
            proj.addTeamMember(emp);
            emp.addProject((Project)lp);
            lp.addTeamMember(emp);
            emp.setSalary(10000);
            em.persist((Object)emp);
            emp = new Employee();
            emp.setFirstName("Ron");
            emp.setLastName("Josephson");
            emp.addProject((Project)lp);
            lp.addTeamMember(emp);
            em.persist((Object)emp);
            emp.setSalary(100);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("select e from Employee e where e.salary > (Select max(l.budget) from Employee emp join treat(emp.projects as LargeProject) l)");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)"Incorrect result size returned", (resultList.size() == 1 ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDowncastWithFetchJoin() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Person rudy = new Person();
            rudy.setName("Rudy");
            em.persist((Object)rudy);
            SportsCar sportsCar = new SportsCar();
            sportsCar.setMaxSpeed(200);
            em.persist((Object)sportsCar);
            rudy.setCar((Car)sportsCar);
            Person theo = new Person();
            theo.setName("Theo");
            em.persist((Object)theo);
            Jalopy car = new Jalopy();
            car.setColor("Red");
            car.setPercentRust(20);
            em.persist((Object)car);
            theo.setCar((Car)car);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select p from Person p join fetch p.car join treat(p.car as SportsCar) s where s.maxSpeed = 200");
            List resultList = query.getResultList();
            Person person = (Person)resultList.get(0);
            QueryCastTestSuite.assertTrue((String)"Incorrect result size returned", (resultList.size() == 1 ? 1 : 0) != 0);
            QueryCastTestSuite.assertNotNull((String)"The car was not fetched.", (Object)person.car);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDoubleTreatOnRoot() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Person rudy = new Person();
            rudy.setName("Rudy");
            em.persist((Object)rudy);
            SportsCar sportsCar = new SportsCar();
            sportsCar.setMaxSpeed(200);
            em.persist((Object)sportsCar);
            rudy.setCar((Car)sportsCar);
            Person theo = new Person();
            theo.setName("Theo");
            em.persist((Object)theo);
            Jalopy car = new Jalopy();
            car.setColor("Red");
            car.setPercentRust(20);
            em.persist((Object)car);
            theo.setCar((Car)car);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select c from Car c where treat(c as SportsCar).maxSpeed = 200 or treat(c as Jalopy).percentRust = 20");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 2 ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDoubleTreatOnRootSTI() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            PerformanceTireInfo pti110 = new PerformanceTireInfo();
            pti110.setSpeedRating(Integer.valueOf(110));
            em.persist((Object)pti110);
            PerformanceTireInfo pti120 = new PerformanceTireInfo();
            pti120.setSpeedRating(Integer.valueOf(120));
            em.persist((Object)pti120);
            PassengerPerformanceTireInfo ppti = new PassengerPerformanceTireInfo();
            ppti.setSpeedRating(Integer.valueOf(120));
            em.persist((Object)ppti);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select t from TireInfo t where treat(t as PerformanceTireInfo).speedRating = 110 or treat(t as PassengerPerformanceTireInfo).speedRating = 120");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 2 ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTreatInSelect() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            LargeProject proj = new LargeProject();
            proj.setBudget(1000.0);
            proj.setName("test1");
            em.persist((Object)proj);
            SmallProject sp = new SmallProject();
            sp.setName("sp1");
            em.persist((Object)sp);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select treat(c as LargeProject).budget from Project c");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)("Incorrect results returned, expected 1, received: " + resultList.size()), (resultList.size() == 1 ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTreatInSelectSTI() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            PerformanceTireInfo pTire = new PerformanceTireInfo();
            pTire.setSpeedRating(Integer.valueOf(100));
            pTire.setPressure(Integer.valueOf(32));
            em.persist((Object)pTire);
            TireInfo tire = new TireInfo();
            tire.setPressure(Integer.valueOf(28));
            em.persist((Object)tire);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select treat(c as PerformanceTireInfo).speedRating from TireInfo c");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)("Incorrect results returned, expected 1, received: " + resultList.size()), (resultList.size() == 1 ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTreatInFrom() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Person rudy = new Person();
            rudy.setName("Rudy");
            em.persist((Object)rudy);
            SportsCar sportsCar = new SportsCar();
            sportsCar.setMaxSpeed(200);
            em.persist((Object)sportsCar);
            rudy.setCar((Car)sportsCar);
            sportsCar.setUser(rudy);
            Company c = new Company();
            c.setName("test");
            em.persist((Object)c);
            sportsCar.setOwner(c);
            c.getVehicles().add(sportsCar);
            Person theo = new Person();
            theo.setName("Theo");
            em.persist((Object)theo);
            Jalopy car = new Jalopy();
            car.setColor("Red");
            car.setPercentRust(20);
            em.persist((Object)car);
            theo.setCar((Car)car);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select b.maxSpeed from Person o join treat(o.car as SportsCar) b");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)("Incorrect results returned, expected 1 received:" + resultList.size()), (resultList.size() == 1 ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTreatInFromSTI() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Bus bus1 = new Bus();
            em.persist((Object)bus1);
            PerformanceTireInfo pTire = new PerformanceTireInfo();
            pTire.setSpeedRating(Integer.valueOf(110));
            pTire.setPressure(Integer.valueOf(32));
            em.persist((Object)pTire);
            bus1.getTires().add(pTire);
            Bus bus2 = new Bus();
            em.persist((Object)bus2);
            TireInfo tire = new TireInfo();
            tire.setPressure(Integer.valueOf(28));
            em.persist((Object)tire);
            bus2.getTires().add(tire);
            PassengerPerformanceTireInfo otherTire = new PassengerPerformanceTireInfo();
            otherTire.setSpeedRating(Integer.valueOf(100));
            otherTire.setPressure(Integer.valueOf(31));
            em.persist((Object)otherTire);
            bus2.getTires().add(otherTire);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select b.speedRating from Bus o join treat(o.tires as PerformanceTireInfo) b");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)("Incorrect results returned, expected 2 received:" + resultList.size()), (resultList.size() == 2 ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTreatInWhere() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Person rudy = new Person();
            rudy.setName("Rudy");
            em.persist((Object)rudy);
            SportsCar sportsCar = new SportsCar();
            sportsCar.setMaxSpeed(200);
            em.persist((Object)sportsCar);
            rudy.setCar((Car)sportsCar);
            sportsCar.setUser(rudy);
            Company c = new Company();
            c.setName("test");
            em.persist((Object)c);
            sportsCar.setOwner(c);
            c.getVehicles().add(sportsCar);
            Person theo = new Person();
            theo.setName("Theo");
            em.persist((Object)theo);
            Jalopy car = new Jalopy();
            car.setColor("Red");
            car.setPercentRust(20);
            em.persist((Object)car);
            theo.setCar((Car)car);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select o from Person o where treat(o.car as SportsCar).maxSpeed = 200");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)("Incorrect results returned, expected 1 received:" + resultList.size()), (resultList.size() == 1 ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTreatInWhereSTI() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Bus bus1 = new Bus();
            em.persist((Object)bus1);
            PerformanceTireInfo pTire = new PerformanceTireInfo();
            pTire.setSpeedRating(Integer.valueOf(110));
            pTire.setPressure(Integer.valueOf(32));
            em.persist((Object)pTire);
            bus1.getTires().add(pTire);
            Bus bus2 = new Bus();
            em.persist((Object)bus2);
            TireInfo tire = new TireInfo();
            tire.setPressure(Integer.valueOf(28));
            em.persist((Object)tire);
            bus2.getTires().add(tire);
            PassengerPerformanceTireInfo otherTire = new PassengerPerformanceTireInfo();
            otherTire.setSpeedRating(Integer.valueOf(100));
            otherTire.setPressure(Integer.valueOf(31));
            em.persist((Object)otherTire);
            bus2.getTires().add(otherTire);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select b from Bus b where treat(b.tires as PerformanceTireInfo).speedRating >100");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)("Incorrect results returned, expected 1 received:" + resultList.size()), (resultList.size() == 1 ? 1 : 0) != 0);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTreatUsingAndOr() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Person rudy = new Person();
            rudy.setName("Rudy");
            em.persist((Object)rudy);
            SportsCar sportsCar = new SportsCar();
            sportsCar.setMaxSpeed(200);
            sportsCar.setColor("Red");
            em.persist((Object)sportsCar);
            rudy.setCar((Car)sportsCar);
            sportsCar.setUser(rudy);
            Company c = new Company();
            c.setName("test");
            em.persist((Object)c);
            sportsCar.setOwner(c);
            c.getVehicles().add(sportsCar);
            Person theo = new Person();
            theo.setName("Theo");
            em.persist((Object)theo);
            Jalopy jalopy = new Jalopy();
            jalopy.setColor("Red");
            jalopy.setPercentRust(20);
            em.persist((Object)jalopy);
            theo.setCar((Car)jalopy);
            Person daisy = new Person();
            daisy.setName("Daisy");
            em.persist((Object)daisy);
            Car car = new Car();
            car.setColor("Red");
            em.persist((Object)car);
            daisy.setCar(car);
            OffRoadTireInfo orti = new OffRoadTireInfo();
            orti.setName("IThinkThereforIAm");
            em.persist((Object)orti);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select p from Person p left join p.car c where (c.color = 'Red') AND (treat(c as SportsCar).maxSpeed = 200 OR treat(c as Jalopy).percentRust = 20)");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertEquals((String)("Incorrect results returned, expected 2 received:" + resultList.size()), (int)resultList.size(), (int)2);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTreatUsingAndOrSTI() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Bus bus1 = new Bus();
            em.persist((Object)bus1);
            PerformanceTireInfo pTire = new PerformanceTireInfo();
            pTire.setSpeedRating(Integer.valueOf(150));
            pTire.setPressure(Integer.valueOf(32));
            em.persist((Object)pTire);
            bus1.getTires().add(pTire);
            Bus bus2 = new Bus();
            em.persist((Object)bus2);
            TireInfo tire = new TireInfo();
            tire.setPressure(Integer.valueOf(28));
            em.persist((Object)tire);
            bus2.getTires().add(tire);
            PassengerPerformanceTireInfo otherTire = new PassengerPerformanceTireInfo();
            otherTire.setSpeedRating(Integer.valueOf(130));
            otherTire.setPressure(Integer.valueOf(31));
            em.persist((Object)otherTire);
            bus2.getTires().add(otherTire);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select b from Bus b join b.tires t where (t.pressure > 0) AND (treat(t as PassengerPerformanceTireInfo).speedRating > 100 OR treat(t as OffRoadTireInfo).name = 'notExist')");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertEquals((String)("Incorrect results returned, expected 1 received:" + resultList.size()), (int)1, (int)resultList.size());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReturningTypeOnTreat() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            SportsCar sportsCar = new SportsCar();
            sportsCar.setMaxSpeed(200);
            sportsCar.setColor("Red");
            em.persist((Object)sportsCar);
            Company c = new Company();
            c.setName("test");
            em.persist((Object)c);
            sportsCar.setOwner(c);
            c.getVehicles().add(sportsCar);
            Jalopy jalopy = new Jalopy();
            jalopy.setColor("Red");
            jalopy.setPercentRust(20);
            em.persist((Object)jalopy);
            Car car = new Car();
            car.setColor("Red");
            em.persist((Object)car);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select TYPE(treat(c as Car)) from Vehicle c");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertEquals((String)("Incorrect results returned, expected 3 received:" + resultList.size()), (int)3, (int)resultList.size());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReturningTypeOnTreatSTI() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Bus bus1 = new Bus();
            em.persist((Object)bus1);
            PerformanceTireInfo pTire = new PerformanceTireInfo();
            pTire.setSpeedRating(Integer.valueOf(150));
            pTire.setPressure(Integer.valueOf(32));
            em.persist((Object)pTire);
            bus1.getTires().add(pTire);
            Bus bus2 = new Bus();
            em.persist((Object)bus2);
            TireInfo tire = new TireInfo();
            tire.setPressure(Integer.valueOf(28));
            em.persist((Object)tire);
            bus2.getTires().add(tire);
            PassengerPerformanceTireInfo otherTire = new PassengerPerformanceTireInfo();
            otherTire.setSpeedRating(Integer.valueOf(130));
            otherTire.setPressure(Integer.valueOf(31));
            em.persist((Object)otherTire);
            bus2.getTires().add(otherTire);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select TYPE(treat(t as PerformanceTireInfo)) from TireInfo t");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertEquals((String)("Incorrect results returned, expected 2 received:" + resultList.size()), (int)2, (int)resultList.size());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTreatUsingJoinOverDowncastRelationship() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Person rudy = new Person();
            rudy.setName("Rudy");
            em.persist((Object)rudy);
            SportsCar sportsCar = new SportsCar();
            sportsCar.setMaxSpeed(200);
            em.persist((Object)sportsCar);
            rudy.setCar((Car)sportsCar);
            sportsCar.setUser(rudy);
            Company c = new Company();
            c.setName("test");
            em.persist((Object)c);
            sportsCar.setOwner(c);
            c.getVehicles().add(sportsCar);
            Person theo = new Person();
            theo.setName("Theo");
            em.persist((Object)theo);
            Jalopy car = new Jalopy();
            car.setColor("Red");
            car.setPercentRust(20);
            em.persist((Object)car);
            theo.setCar((Car)car);
            em.flush();
            this.clearCache();
            em.clear();
            Query query = em.createQuery("Select o from Person p join treat(p.car as SportsCar) s join s.owner o");
            List resultList = query.getResultList();
            for (Object result : resultList) {
                QueryCastTestSuite.assertTrue((String)("query did not return intances of Company, instead it returned :" + result), (boolean)(result instanceof Company));
            }
            QueryCastTestSuite.assertEquals((String)("Incorrect results returned, expected 1 received:" + resultList.size()), (int)resultList.size(), (int)1);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }
}

