/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;

public class ExtendedPersistenceContextJUnitTestSuite
extends JUnitTestCase {
    public ExtendedPersistenceContextJUnitTestSuite() {
    }

    public ExtendedPersistenceContextJUnitTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("ExtendedPersistenceContextJUnitTestSuite");
        suite.addTest((Test)new ExtendedPersistenceContextJUnitTestSuite("testSetup"));
        suite.addTest((Test)new ExtendedPersistenceContextJUnitTestSuite("testExtendedPersistenceContext"));
        return suite;
    }

    public void testSetup() {
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        EmployeePopulator employeePopulator = new EmployeePopulator();
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public void testExtendedPersistenceContext() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Query query = em.createQuery("select e from Employee e");
        List result = query.getResultList();
        if (result.isEmpty()) {
            ExtendedPersistenceContextJUnitTestSuite.fail((String)"Database not setup correctly");
        }
        Object obj = result.get(0);
        this.commitTransaction(em);
        if (ExtendedPersistenceContextJUnitTestSuite.isOnServer()) {
            ExtendedPersistenceContextJUnitTestSuite.assertFalse((String)"Extended PersistenceContext did not continue to maintain object after commit.", (boolean)em.contains(obj));
        } else {
            ExtendedPersistenceContextJUnitTestSuite.assertTrue((String)"Extended PersistenceContext did not continue to maintain object after commit.", (boolean)em.contains(obj));
        }
        this.closeEntityManager(em);
    }
}

