/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.io.OutputStream;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.schema.model.Any;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.oxm.schema.model.Sequence;
import org.eclipse.persistence.internal.xr.Operation;
import org.eclipse.persistence.internal.xr.QNameTransformer;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.XRServiceModel;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaURLReference;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.NamingConventionTransformer;
import org.eclipse.persistence.tools.dbws.XRPackager;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentType;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentTypeDirection;
import org.eclipse.persistence.tools.oracleddl.metadata.BinaryType;
import org.eclipse.persistence.tools.oracleddl.metadata.BlobType;
import org.eclipse.persistence.tools.oracleddl.metadata.CharType;
import org.eclipse.persistence.tools.oracleddl.metadata.ClobType;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.DecimalType;
import org.eclipse.persistence.tools.oracleddl.metadata.DoubleType;
import org.eclipse.persistence.tools.oracleddl.metadata.FloatType;
import org.eclipse.persistence.tools.oracleddl.metadata.FunctionType;
import org.eclipse.persistence.tools.oracleddl.metadata.LongRawType;
import org.eclipse.persistence.tools.oracleddl.metadata.NCharType;
import org.eclipse.persistence.tools.oracleddl.metadata.NClobType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLCursorType;
import org.eclipse.persistence.tools.oracleddl.metadata.ProcedureType;
import org.eclipse.persistence.tools.oracleddl.metadata.RawType;
import org.eclipse.persistence.tools.oracleddl.metadata.RealType;
import org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum;
import org.eclipse.persistence.tools.oracleddl.metadata.TimeStampType;
import org.eclipse.persistence.tools.oracleddl.metadata.VarChar2Type;

public class Util {
    public static final String TOPLEVEL = "TOPLEVEL";
    public static final String CLASSES = "classes";
    public static final String DEFAULT_WSDL_LOCATION_URI = "REPLACE_WITH_ENDPOINT_ADDRESS";
    public static final String SWAREF_FILENAME;
    public static final String WSI_SWAREF_XSD_FILE;
    public static final String WEB_XML_FILENAME = "web.xml";
    public static final String DEFAULT_PLATFORM_CLASSNAME = "org.eclipse.persistence.platform.database.OraclePlatform";
    public static final String DOM_PLATFORM_CLASSNAME = "org.eclipse.persistence.oxm.platform.DOMPlatform";
    public static final String UNDER_DBWS = "_dbws";
    public static final String OX_PRJ_SUFFIX = "-dbws-ox";
    public static final String OR_PRJ_SUFFIX = "-dbws-or";
    public static final String XML_BINDINGS = "xml-bindings";
    public static final String XML_MIME_PREFIX = "xmime";
    public static final String WSI_SWAREF = "swaRef";
    public static final String WSI_SWAREF_PREFIX = "ref";
    public static final String WSI_SWAREF_URI = "http://ws-i.org/profiles/basic/1.1/xsd";
    public static final String WSI_SWAREF_XSD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<xsd:schema targetNamespace=\"http://ws-i.org/profiles/basic/1.1/xsd\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"> \n  <xsd:simpleType name=\"swaRef\"> \n    <xsd:restriction base=\"xsd:anyURI\"/> \n  </xsd:simpleType> \n</xsd:schema>";
    public static final String THE_INSTANCE_NAME = "theInstance";
    public static final String FINDALL_QUERYNAME = "findAll";
    public static final String CREATE_OPERATION_NAME = "create";
    public static final String UPDATE_OPERATION_NAME = "update";
    public static final String REMOVE_OPERATION_NAME = "delete";
    public static final String DBWS_PROVIDER_PACKAGE = "_dbws";
    public static final String DBWS_PROVIDER_NAME = "DBWSProvider";
    public static final String DOT_CLASS = ".class";
    static final String DOT_JAVA = ".java";
    public static final String DBWS_PROVIDER_CLASS_FILE = "DBWSProvider.class";
    public static final String DBWS_PROVIDER_SOURCE_FILE = "DBWSProvider.java";
    static final String PROVIDER_LISTENER = "ProviderListener";
    public static final String PROVIDER_LISTENER_CLASS_FILE = "ProviderListener.class";
    public static final String PROVIDER_LISTENER_SOURCE_FILE = "ProviderListener.java";
    public static final String AT_SIGN = "@";
    public static final String COMMA = ",";
    public static final String SEMICOLON = ";";
    public static final String SINGLE_SPACE = " ";
    public static final String PERCENT = "%";
    public static final String UNDERSCORE = "_";
    public static final String BUILDING_QUERYOP_FOR = "Building QueryOperation for ";
    public static final String APP_OCTET_STREAM = "application/octet-stream";
    public static final String TYPE_STR = "Type";
    public static final String CURSOR_STR = "CURSOR";
    public static final String CURSOR_OF_STR = "cursor of ";
    public static final String OPEN_PAREN = "{";
    public static final String CLOSE_PAREN = "}";
    public static final String SLASH = "/";
    public static final String DOT = ".";
    public static final String OPEN_BRACKET = "(";
    public static final String CLOSE_BRACKET = ")";
    public static final String OPEN_SQUARE_BRACKET = "[";
    public static final String CLOSE_SQUARE_BRACKET = "]";
    public static final String SLASH_TEXT = "/text()";
    public static final String ARRAY_STR = "ARRAY";
    public static final String BIGINT_STR = "BIGINT";
    public static final String BINARY_STR = "BINARY";
    public static final String BLOB_STR = "BLOB";
    public static final String BOOLEAN_STR = "BOOLEAN";
    public static final String CHAR_STR = "CHAR";
    public static final String CLOB_STR = "CLOB";
    public static final String DATE_STR = "DATE";
    public static final String DECIMAL_STR = "DECIMAL";
    public static final String DOUBLE_STR = "DOUBLE";
    public static final String FLOAT_STR = "FLOAT";
    public static final String INTEGER_STR = "INTEGER";
    public static final String LONG_STR = "LONG";
    public static final String LONGRAW_STR = "LONG RAW";
    public static final String LONGVARBINARY_STR = "LONGVARBINARY";
    public static final String NCHAR_STR = "NCHAR";
    public static final String NCLOB_STR = "NCLOB";
    public static final String NUMBER_STR = "NUMBER";
    public static final String NUMERIC_STR = "NUMERIC";
    public static final String NVARCHAR_STR = "NVARCHAR";
    public static final String NVARCHAR2_STR = "NVARCHAR2";
    public static final String OTHER_STR = "OTHER";
    public static final String RAW_STR = "RAW";
    public static final String REAL_STR = "REAL";
    public static final String ROWID_STR = "ROWID";
    public static final String ROWTYPE_STR = "%ROWTYPE";
    public static final String SMALLINT_STR = "SMALLINT";
    public static final String STRUCT_STR = "STRUCT";
    public static final String TIME_STR = "TIME";
    public static final String TIMESTAMP_STR = "TIMESTAMP";
    public static final String TINYINT_STR = "TINYINT";
    public static final String UROWID_STR = "UROWID";
    public static final String VARBINARY_STR = "VARBINARY";
    public static final String VARCHAR_STR = "VARCHAR";
    public static final String VARCHAR2_STR = "VARCHAR2";
    public static final String BINARY_INTEGER_STR = "BINARY_INTEGER";
    public static final String PLS_INTEGER_STR = "PLS_INTEGER";
    public static final String NATURAL_STR = "NATURAL";
    public static final String POSITIVE_STR = "POSITIVE";
    public static final String SIGNTYPE_STR = "SIGNTYPE";
    public static final String BINARY_INTEGER_TYPE_STR = "BinaryInteger";
    public static final String PLS_BOOLEAN_TYPE_STR = "PLSQLBoolean";
    public static final String PLS_INTEGER_TYPE_STR = "PLSQLInteger";
    public static final String NATURAL_TYPE_STR = "Natural";
    public static final String POSITIVE_TYPE_STR = "Positive";
    public static final String SIGNTYPE_TYPE_STR = "SignType";
    public static final String SYS_XMLTYPE_STR = "SYS.XMLTYPE";
    public static final String XMLTYPE_STR = "XMLTYPE";
    public static final String _TYPE_STR = "_TYPE";
    public static final String ARRAY_CLS_STR = "java.sql.Array";
    public static final String OPAQUE_CLS_STR = "java.sql.Struct";
    public static final String ROWID_CLS_STR = "java.sql.RowId";
    public static final String STRUCT_CLS_STR = "oracle.sql.OPAQUE";
    public static final QName SXF_QNAME_CURSOR;

    public static int getJDBCTypeFromTypeName(String typeName) {
        int jdbcType = 1111;
        if (typeName.equals(NUMERIC_STR)) {
            jdbcType = 2;
        } else if (typeName.equals(VARCHAR_STR)) {
            jdbcType = 12;
        } else if (typeName.equals(VARCHAR2_STR)) {
            jdbcType = 12;
        } else if (typeName.equals(NVARCHAR_STR)) {
            jdbcType = -9;
        } else if (typeName.equals(NVARCHAR2_STR)) {
            jdbcType = -9;
        } else if (typeName.equals(DATE_STR)) {
            jdbcType = 91;
        } else if (typeName.equals(TIME_STR)) {
            jdbcType = 92;
        } else if (typeName.equals(TIMESTAMP_STR)) {
            jdbcType = 93;
        } else if (typeName.equals(DECIMAL_STR)) {
            jdbcType = 3;
        } else if (typeName.equals(INTEGER_STR)) {
            jdbcType = 4;
        } else if (typeName.equals(CHAR_STR)) {
            jdbcType = 1;
        } else if (typeName.equals(NCHAR_STR)) {
            jdbcType = -15;
        } else if (typeName.equals(FLOAT_STR)) {
            jdbcType = 6;
        } else if (typeName.equals(REAL_STR)) {
            jdbcType = 7;
        } else if (typeName.equals(DOUBLE_STR)) {
            jdbcType = 8;
        } else if (typeName.equals(BINARY_STR)) {
            jdbcType = -2;
        } else if (typeName.equals(BLOB_STR)) {
            jdbcType = 2004;
        } else if (typeName.equals(CLOB_STR) || typeName.equals(LONG_STR)) {
            jdbcType = 2005;
        } else if (typeName.equals(NCLOB_STR)) {
            jdbcType = 2011;
        } else if (typeName.equals(RAW_STR)) {
            jdbcType = -3;
        } else if (typeName.equals(LONGRAW_STR)) {
            jdbcType = -4;
        } else if (typeName.equals(ROWID_STR)) {
            jdbcType = 12;
        } else if (typeName.equals(UROWID_STR)) {
            jdbcType = 12;
        } else if (typeName.equals(BIGINT_STR)) {
            jdbcType = -5;
        } else if (typeName.equals(STRUCT_STR)) {
            jdbcType = 2002;
        } else if (typeName.equals(ARRAY_STR)) {
            jdbcType = 2003;
        } else if (typeName.equals(ROWID_STR)) {
            jdbcType = -8;
        } else if (typeName.equalsIgnoreCase(XMLTYPE_STR) || typeName.equalsIgnoreCase(SYS_XMLTYPE_STR)) {
            jdbcType = 12;
        } else if (typeName.equals(BOOLEAN_STR) || typeName.equals(INTEGER_STR) || typeName.equals(SMALLINT_STR) || typeName.equals(TINYINT_STR)) {
            jdbcType = 4;
        }
        return jdbcType;
    }

    public static String getJDBCTypeNameFromType(int jdbcType) {
        String typeName = null;
        switch (jdbcType) {
            case 2: {
                typeName = NUMERIC_STR;
                break;
            }
            case 12: {
                typeName = VARCHAR_STR;
                break;
            }
            case -9: {
                typeName = NVARCHAR_STR;
                break;
            }
            case 3: {
                typeName = DECIMAL_STR;
                break;
            }
            case 1: {
                typeName = CHAR_STR;
                break;
            }
            case -15: {
                typeName = NCHAR_STR;
                break;
            }
            case 6: {
                typeName = FLOAT_STR;
                break;
            }
            case 7: {
                typeName = REAL_STR;
                break;
            }
            case 8: {
                typeName = DOUBLE_STR;
                break;
            }
            case -2: {
                typeName = BINARY_STR;
                break;
            }
            case 2004: {
                typeName = BLOB_STR;
                break;
            }
            case 2005: {
                typeName = CLOB_STR;
                break;
            }
            case 2011: {
                typeName = NCLOB_STR;
                break;
            }
            case -3: {
                typeName = VARBINARY_STR;
                break;
            }
            case -4: {
                typeName = LONGVARBINARY_STR;
                break;
            }
            case 91: {
                typeName = DATE_STR;
                break;
            }
            case 92: {
                typeName = TIME_STR;
                break;
            }
            case 93: {
                typeName = TIMESTAMP_STR;
                break;
            }
            case -5: {
                typeName = BIGINT_STR;
                break;
            }
            case 2003: {
                typeName = ARRAY_STR;
                break;
            }
            case 2002: {
                typeName = STRUCT_STR;
                break;
            }
            case -8: {
                typeName = ROWID_STR;
                break;
            }
            default: {
                typeName = OTHER_STR;
            }
        }
        return typeName;
    }

    public static String getJDBCEnumNameFromTypeName(String typeName) {
        if (Util.getJDBCTypeFromTypeName(typeName) != 1111) {
            typeName = typeName + _TYPE_STR;
        }
        return typeName;
    }

    public static QName getXMLTypeFromJDBCTypeName(String jdbcTypeName) {
        return Util.getXMLTypeFromJDBCType(Util.getJDBCTypeFromTypeName(jdbcTypeName));
    }

    public static QName getXMLTypeFromJDBCType(Short jdbcType) {
        return Util.getXMLTypeFromJDBCType(jdbcType.intValue());
    }

    public static QName getXMLTypeFromJDBCType(int jdbcType) {
        switch (jdbcType) {
            case -15: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                return Constants.STRING_QNAME;
            }
            case -5: {
                return Constants.INTEGER_QNAME;
            }
            case -6: 
            case 4: 
            case 5: {
                return Constants.INT_QNAME;
            }
            case 2: 
            case 3: {
                return Constants.DECIMAL_QNAME;
            }
            case 6: 
            case 7: 
            case 8: {
                return Constants.DOUBLE_QNAME;
            }
            case 91: {
                return Constants.DATE_QNAME;
            }
            case 92: {
                return Constants.TIME_QNAME;
            }
            case 93: {
                return Constants.DATE_TIME_QNAME;
            }
        }
        return Constants.BASE_64_BINARY_QNAME;
    }

    public static QName qNameFromString(String qNameAsString, Schema schema) {
        QName qName = null;
        String nsURI = null;
        String prefix = null;
        String localPart = null;
        if (qNameAsString != null) {
            if (qNameAsString.charAt(0) == '{') {
                int endOfNamespaceURI = qNameAsString.indexOf(125);
                if (endOfNamespaceURI == -1) {
                    throw new IllegalArgumentException("cannot create QName from \"" + qNameAsString + "\", missing closing \"}\"");
                }
                nsURI = qNameAsString.substring(1, endOfNamespaceURI);
                localPart = qNameAsString.substring(endOfNamespaceURI + 1);
            } else {
                int colonIdx = qNameAsString.indexOf(58);
                if (colonIdx > 0) {
                    prefix = qNameAsString.substring(0, colonIdx);
                    localPart = qNameAsString.substring(colonIdx + 1);
                    nsURI = schema.getNamespaceResolver().resolveNamespacePrefix(prefix);
                    if (nsURI == null) {
                        nsURI = prefix.equalsIgnoreCase("xsd") ? "http://www.w3.org/2001/XMLSchema" : "";
                    }
                } else {
                    localPart = qNameAsString;
                }
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(nsURI)) {
                qName = (QName)QNameTransformer.SCHEMA_QNAMES.get(localPart);
                if (qName == null) {
                    qName = new QName("http://www.w3.org/2001/XMLSchema", localPart, prefix == null ? "" : prefix);
                }
            } else {
                qName = new QName(nsURI == null ? "" : nsURI, localPart, prefix == null ? "" : prefix);
            }
        }
        return qName;
    }

    public static String getClassNameForType(int jdbcType) {
        String typeName = null;
        switch (jdbcType) {
            case 2: {
                typeName = ClassConstants.NUMBER.getName();
                break;
            }
            case 3: {
                typeName = ClassConstants.BIGDECIMAL.getName();
                break;
            }
            case 1: {
                typeName = ClassConstants.CHAR.getName();
                break;
            }
            case 6: {
                typeName = ClassConstants.FLOAT.getName();
                break;
            }
            case 7: 
            case 8: {
                typeName = ClassConstants.DOUBLE.getName();
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                typeName = ClassConstants.ABYTE.getName();
                break;
            }
            case 2004: {
                typeName = ClassConstants.BLOB.getName();
                break;
            }
            case 2005: {
                typeName = ClassConstants.CLOB.getName();
                break;
            }
            case 2011: {
                typeName = "java.sql.NClob";
                break;
            }
            case 91: {
                typeName = ClassConstants.SQLDATE.getName();
                break;
            }
            case 92: {
                typeName = ClassConstants.TIME.getName();
                break;
            }
            case 93: {
                typeName = ClassConstants.TIMESTAMP.getName();
                break;
            }
            case -5: {
                typeName = ClassConstants.BIGINTEGER.getName();
                break;
            }
            case 2003: {
                typeName = ARRAY_CLS_STR;
                break;
            }
            case 2002: {
                typeName = STRUCT_CLS_STR;
                break;
            }
            case -8: {
                typeName = ROWID_CLS_STR;
                break;
            }
            case 2007: {
                typeName = OPAQUE_CLS_STR;
                break;
            }
            default: {
                typeName = ClassConstants.STRING.getName();
            }
        }
        return typeName;
    }

    public static DatabaseType buildTypeForJDBCType(int jdbcType, int precision, int scale) {
        ScalarDatabaseTypeEnum type = null;
        switch (jdbcType) {
            case -2: {
                type = new BinaryType();
                break;
            }
            case 2004: {
                type = new BlobType();
                break;
            }
            case 1: {
                type = new CharType();
                break;
            }
            case 2005: {
                type = new ClobType();
                break;
            }
            case 91: {
                type = ScalarDatabaseTypeEnum.DATE_TYPE;
                break;
            }
            case -5: {
                type = ScalarDatabaseTypeEnum.BIGINT_TYPE;
                break;
            }
            case 2: 
            case 3: {
                type = new DecimalType((long)precision, (long)scale);
                break;
            }
            case 8: {
                type = new DoubleType((long)precision, (long)scale);
                break;
            }
            case 6: {
                type = new FloatType((long)precision, (long)scale);
                break;
            }
            case -4: {
                type = new LongRawType();
                break;
            }
            case -15: {
                type = new NCharType();
                break;
            }
            case 2011: {
                type = new NClobType();
                break;
            }
            case 7: {
                type = new RealType((long)precision, (long)scale);
                break;
            }
            case 92: {
                type = ScalarDatabaseTypeEnum.TIME_TYPE;
                break;
            }
            case 93: {
                type = new TimeStampType();
                break;
            }
            case -3: {
                type = new RawType();
                break;
            }
            default: {
                type = new VarChar2Type();
            }
        }
        return type;
    }

    public static Class<?> getAttributeClassForDatabaseType(DatabaseType dbType) {
        if (!dbType.isComposite()) {
            String typeName = dbType.getTypeName();
            if (NUMBER_STR.equals(typeName) || NUMERIC_STR.equals(typeName)) {
                return ClassConstants.BIGDECIMAL;
            }
            if (INTEGER_STR.equals(typeName)) {
                return ClassConstants.INTEGER;
            }
            if (BOOLEAN_STR.equals(typeName)) {
                return ClassConstants.BOOLEAN;
            }
            if (DATE_STR.equals(typeName)) {
                return ClassConstants.JavaSqlDate_Class;
            }
            if (TIMESTAMP_STR.equals(typeName)) {
                return ClassConstants.JavaSqlTimestamp_Class;
            }
        }
        return ClassConstants.STRING;
    }

    public static void addSimpleXMLFormat(Schema schema) {
        ComplexType anyType = new ComplexType();
        anyType.setName("simple-xml-format");
        Sequence anySequence = new Sequence();
        Any any = new Any();
        any.setMinOccurs("0");
        anySequence.addAny(any);
        anyType.setSequence(anySequence);
        schema.addTopLevelComplexTypes(anyType);
    }

    public static boolean noOutArguments(ProcedureType storedProcedure) {
        boolean noOutArguments = true;
        if (storedProcedure.getArguments() != null && storedProcedure.getArguments().size() > 0) {
            for (ArgumentType arg : storedProcedure.getArguments()) {
                if (arg.getDirection() != ArgumentTypeDirection.INOUT && arg.getDirection() != ArgumentTypeDirection.OUT) continue;
                noOutArguments = false;
                break;
            }
        }
        return noOutArguments;
    }

    public static String escapePunctuation(String originalName) {
        if (originalName == null || originalName.length() == 0) {
            return originalName;
        }
        return originalName.trim().replaceAll("[\\p{Punct}&&[^_%]]", "\\\\$0");
    }

    public static boolean isNullStream(OutputStream outputStream) {
        return outputStream == null | outputStream == XRPackager.__nullStream;
    }

    public static String getGeneratedJavaClassName(String name, String projectName) {
        String first = name.substring(0, 1).toUpperCase();
        String rest = name.toLowerCase().substring(1);
        return projectName.toLowerCase() + DOT + first + rest;
    }

    public static String getGeneratedAlias(String tableName) {
        String first = tableName.substring(0, 1).toUpperCase();
        String rest = tableName.toLowerCase().substring(1);
        return first.concat(rest);
    }

    public static String getGeneratedWrapperClassName(String name, String projectName) {
        return Util.getGeneratedJavaClassName(name, projectName) + "_CollectionWrapper";
    }

    public static RelationalDescriptor buildORDescriptor(String tableName, String projectName, List<String> requireCRUDOperations, NamingConventionTransformer nct) {
        RelationalDescriptor desc = new RelationalDescriptor();
        desc.addTableName(tableName);
        String tableAlias = Util.getGeneratedAlias(tableName);
        desc.setAlias(tableAlias);
        desc.setJavaClassName(Util.getGeneratedJavaClassName(tableName, projectName));
        desc.useWeakIdentityMap();
        if (requireCRUDOperations != null) {
            requireCRUDOperations.add(tableAlias);
        }
        return desc;
    }

    public static XMLDescriptor buildOXDescriptor(String tableName, String projectName, String targetNamespace, NamingConventionTransformer nct) {
        return Util.buildOXDescriptor(Util.getGeneratedAlias(tableName), nct.generateSchemaAlias(tableName), Util.getGeneratedJavaClassName(tableName, projectName), targetNamespace);
    }

    public static XMLDescriptor buildOXDescriptor(String tableAlias, String schemaAlias, String generatedJavaClassName, String targetNamespace) {
        XMLDescriptor xdesc = new XMLDescriptor();
        xdesc.setAlias(tableAlias);
        xdesc.setJavaClassName(generatedJavaClassName);
        NamespaceResolver nr = new NamespaceResolver();
        nr.setDefaultNamespaceURI(targetNamespace);
        xdesc.setNamespaceResolver(nr);
        xdesc.setDefaultRootElement(schemaAlias);
        XMLSchemaURLReference schemaReference = new XMLSchemaURLReference("");
        schemaReference.setSchemaContext(SLASH + schemaAlias);
        schemaReference.setType(1);
        xdesc.setSchemaReference((XMLSchemaReference)schemaReference);
        return xdesc;
    }

    public static QName buildCustomQName(String typeString, DBWSBuilder builder) {
        if (typeString.contains(PERCENT)) {
            typeString = typeString.replace(PERCENT, UNDERSCORE);
        }
        QName qName = null;
        String nsURI = null;
        String prefix = null;
        String localPart = null;
        int colonIdx = typeString.indexOf(58);
        if (colonIdx > 0) {
            prefix = typeString.substring(0, colonIdx);
            nsURI = builder.schema.getNamespaceResolver().resolveNamespacePrefix(prefix);
            nsURI = prefix.equalsIgnoreCase("xsd") ? "http://www.w3.org/2001/XMLSchema" : "";
            localPart = typeString.substring(colonIdx + 1);
            if ("http://www.w3.org/2001/XMLSchema".equals(nsURI)) {
                qName = (QName)QNameTransformer.SCHEMA_QNAMES.get(localPart);
                if (qName == null) {
                    qName = new QName("http://www.w3.org/2001/XMLSchema", localPart, prefix == null ? "" : prefix);
                }
            } else {
                qName = new QName(nsURI, localPart, prefix);
            }
        } else {
            qName = Util.qNameFromString(OPEN_PAREN + builder.getTargetNamespace() + CLOSE_PAREN + typeString, builder.schema);
        }
        return qName;
    }

    public static boolean requiresSimpleXMLFormat(XRServiceModel serviceModel) {
        boolean requiresSimpleXMLFormat = false;
        for (Operation operation : serviceModel.getOperationsList()) {
            QueryOperation qo;
            if (!(operation instanceof QueryOperation) || !(qo = (QueryOperation)operation).getResult().isSimpleXMLFormat()) continue;
            requiresSimpleXMLFormat = true;
            break;
        }
        return requiresSimpleXMLFormat;
    }

    public static boolean sqlMatch(String pattern, String input) {
        if (pattern != null && pattern.length() > 0) {
            String tmp = "\\A\\Z|" + pattern.replace('_', '.').replace(PERCENT, ".*");
            Pattern p = Pattern.compile(tmp, 66);
            return p.matcher(input == null ? "" : input).matches();
        }
        return false;
    }

    public static boolean isTypeComplex(DatabaseType dbType) {
        return dbType.isPLSQLType() || dbType.isPLSQLCursorType() && !((PLSQLCursorType)dbType).isWeaklyTyped() || dbType.isVArrayType() || dbType.isObjectType() || dbType.isBlobType() || dbType.isObjectTableType();
    }

    public static boolean isArgComplex(ArgumentType argument) {
        return Util.isTypeComplex(argument.getEnclosedType());
    }

    public static boolean isArgPLSQL(ArgumentType argument) {
        DatabaseType argType = argument.getEnclosedType();
        return argType.isPLSQLType() || Util.isArgPLSQLScalar(argument);
    }

    public static boolean isArgPLSQLScalar(ArgumentType argument) {
        DatabaseType argType = argument.getEnclosedType();
        return argType == ScalarDatabaseTypeEnum.BINARY_INTEGER_TYPE || argType == ScalarDatabaseTypeEnum.BOOLEAN_TYPE || argType == ScalarDatabaseTypeEnum.NATURAL_TYPE || argType == ScalarDatabaseTypeEnum.PLS_INTEGER_TYPE || argType == ScalarDatabaseTypeEnum.POSITIVE_TYPE || argType == ScalarDatabaseTypeEnum.SIGN_TYPE;
    }

    public static boolean isArgPLSQLScalar(String argTypeName) {
        return argTypeName.equals(BOOLEAN_STR) || argTypeName.equals(PLS_INTEGER_STR) || argTypeName.equals(BINARY_INTEGER_STR) || argTypeName.equals(NATURAL_STR) || argTypeName.equals(POSITIVE_STR) || argTypeName.equals(SIGNTYPE_STR);
    }

    public static String getOraclePLSQLTypeForName(String typeName) {
        if (typeName.equals(BINARY_INTEGER_STR)) {
            return BINARY_INTEGER_TYPE_STR;
        }
        if (typeName.equals(BOOLEAN_STR)) {
            return PLS_BOOLEAN_TYPE_STR;
        }
        if (typeName.equals(PLS_INTEGER_STR)) {
            return PLS_INTEGER_TYPE_STR;
        }
        if (typeName.equals(NATURAL_STR)) {
            return NATURAL_TYPE_STR;
        }
        if (typeName.equals(POSITIVE_STR)) {
            return POSITIVE_TYPE_STR;
        }
        if (typeName.equals(SIGNTYPE_STR)) {
            return SIGNTYPE_TYPE_STR;
        }
        return null;
    }

    public static boolean hasComplexArgs(ProcedureType storedProcedure) {
        for (ArgumentType arg : storedProcedure.getArguments()) {
            if (!Util.isArgComplex(arg)) continue;
            return true;
        }
        return storedProcedure.isFunctionType() && Util.isArgComplex(((FunctionType)storedProcedure).getReturnArgument());
    }

    public static boolean hasPLSQLArgs(ProcedureType storedProcedure) {
        for (ArgumentType arg : storedProcedure.getArguments()) {
            if (!Util.isArgPLSQL(arg)) continue;
            return true;
        }
        return storedProcedure.isFunctionType() && Util.isArgPLSQL(((FunctionType)storedProcedure).getReturnArgument());
    }

    public static boolean hasPLSQLArgs(List<ArgumentType> arguments) {
        for (ArgumentType arg : arguments) {
            if (!Util.isArgPLSQL(arg) && !arg.optional()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasComplexArgs(List<ArgumentType> arguments) {
        for (ArgumentType arg : arguments) {
            if (!Util.isArgComplex(arg)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPLSQLScalarArgs(List<ArgumentType> arguments) {
        for (ArgumentType arg : arguments) {
            if (!Util.isArgPLSQLScalar(arg)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPLSQLCursorArg(List<ArgumentType> arguments) {
        for (ArgumentType arg : arguments) {
            if (!arg.isPLSQLCursorType()) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldSetJavaType(String typeName) {
        return !typeName.equals(ClassConstants.STRING.getName());
    }

    static {
        WSI_SWAREF_XSD_FILE = SWAREF_FILENAME = WSI_SWAREF.toLowerCase() + ".xsd";
        SXF_QNAME_CURSOR = new QName("", "cursor of simple-xml-format");
    }

    public static enum InOut {
        IN,
        OUT,
        INOUT,
        RETURN;

    }
}

