/*
 * Copyright (c) 1998, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     Oracle - initial API and implementation from Oracle TopLink
package org.eclipse.persistence.testing.models.readonly;

import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.*;
import org.eclipse.persistence.testing.models.readonly.Address;

public class Studio {
    public String name;
    public String owner;
    public Address address;

    // Studio descriptor
    public static RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();

        descriptor.setJavaClass(org.eclipse.persistence.testing.models.readonly.Studio.class);
        descriptor.setTableName("RO_MOVIE");

        descriptor.descriptorIsAggregate();

        descriptor.addDirectMapping("name", "STD_NAME");
        descriptor.addDirectMapping("owner", "STD_OWN");

        OneToOneMapping addressMapping = new OneToOneMapping();
        addressMapping.setAttributeName("address");
        addressMapping.setReferenceClass(Address.class);
        addressMapping.setForeignKeyFieldName("STD_ADD");
        addressMapping.privateOwnedRelationship();
        addressMapping.dontUseIndirection();
        descriptor.addMapping(addressMapping);

        return descriptor;
    }

    public static Studio example1() {
        Studio example = new Studio();

        example.setName("Lucasfilm, Ltd.");
        example.setOwner("George Lucas");
        example.setAddress(Address.example1());

        return example;
    }

    public static Studio example2() {
        Studio example = new Studio();

        example.setName("Columbia Pictures Corporation");
        example.setOwner("Christopher Columbus");
        example.setAddress(Address.example2());

        return example;
    }

    public static Studio example3() {
        Studio example = new Studio();

        example.setName("DreamWorks SKG");
        example.setOwner("Steven Speilberg");
        example.setAddress(Address.example3());

        return example;
    }

    public static Studio example4() {
        Studio example = new Studio();

        example.setName("Tall & Short Studio");
        example.setOwner("Mutt & Jeff");
        example.setAddress(Address.example4());

        return example;
    }

    public static Studio example5() {
        Studio example = new Studio();

        example.setName("FFC Productions");
        example.setOwner("Francis Ford Coppola");
        example.setAddress(Address.example5());

        return example;
    }

    public Address getAddress() {
        return address;
    }

    public String getName() {
        return name;
    }

    public String getOwner() {
        return owner;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String toString() {
        return new String("Studio: " + getName());
    }
}
