/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.inmemory;

import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class MemoryQueryReturnConformedOnIndirection
extends TestCase {
    protected Employee employee;
    protected ReadAllQuery queryAll;
    protected ReadObjectQuery queryObject;
    protected Vector allEmployees;
    protected Vector inMemoryResult;

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.allEmployees = new Vector();
        this.queryAll = new ReadAllQuery();
        this.queryAll.setReferenceClass(Employee.class);
        this.queryAll.setSelectionCriteria(new ExpressionBuilder().get("address").get("city").notEqual((Object)"Montreal"));
        this.allEmployees = (Vector)this.getSession().executeQuery((DatabaseQuery)this.queryAll);
        this.queryObject = new ReadObjectQuery(Employee.class);
        this.queryObject.setSelectionCriteria(new ExpressionBuilder().get("address").get("city").equal((Object)"Montreal"));
        Employee employee = (Employee)this.getSession().executeQuery((DatabaseQuery)this.queryObject);
        if (employee != null) {
            employee.getAddress();
        }
    }

    public void test() {
        this.queryAll.checkCacheOnly();
        this.queryAll.getInMemoryQueryIndirectionPolicy().ignoreIndirectionExceptionReturnConformed();
        this.inMemoryResult = (Vector)this.getSession().executeQuery((DatabaseQuery)this.queryAll);
    }

    public void verify() {
        if (this.inMemoryResult.size() != this.allEmployees.size()) {
            throw new TestErrorException("In Memory Query did not return all objects because of indirection.  TopLink is not returning indirection relationships as conformed when the policy is set to do so.");
        }
    }
}

