/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.junit.identitymaps;

import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.junit.Assert;
import org.junit.Test;

public class CacheIdTest {
    @Test
    public void compareToForByteArrays() {
        this.equal("many primaryKeys - equal", this.newCacheId(new byte[]{1, 2}, new byte[]{2, 3}), this.newCacheId(new byte[]{1, 2}, new byte[]{2, 3}));
        this.equal("one primaryKey - equal", this.newCacheId(new Object[]{new byte[]{1, 2}}), this.newCacheId(new Object[]{new byte[]{1, 2}}));
        this.smaller("one primaryKey - smaller on first element", this.newCacheId(new Object[]{new byte[]{1, 2}}), this.newCacheId(new Object[]{new byte[]{2, 3}}));
        this.greater("one primaryKey - greater on first element", this.newCacheId(new Object[]{new byte[]{2, 3}}), this.newCacheId(new Object[]{new byte[]{1, 3}}));
        this.smaller("one primaryKey - smaller on last element", this.newCacheId(new Object[]{new byte[]{2, 1, 2}}), this.newCacheId(new Object[]{new byte[]{2, 1, 3}}));
        this.greater("one primaryKey - greater  on last element", this.newCacheId(new Object[]{new byte[]{0, 0, 3}}), this.newCacheId(new Object[]{new byte[]{0, 0, 2}}));
        this.smaller("many primaryKey - smaller", this.newCacheId(new byte[]{1, 2}, new byte[]{2, 2}), this.newCacheId(new byte[]{1, 2}, new byte[]{2, 3}));
        this.greater("many primaryKey - greater", this.newCacheId(new byte[]{2, 3}, new byte[]{1, 4}), this.newCacheId(new byte[]{2, 3}, new byte[]{1, 3}));
        this.greater("one primaryKey - smaller by different size", this.newCacheId(new Object[]{new byte[]{1, 2}}), this.newCacheId(new Object[]{new byte[]{1}}));
        this.smaller("one primaryKey - greater by different size", this.newCacheId(new Object[]{new byte[]{2}}), this.newCacheId(new Object[]{new byte[]{2, 1}}));
    }

    @Test
    public void compareToForCharArrays() {
        this.equal("many primaryKeys - equal", this.newCacheId(new char[]{'a', 'b'}, new char[]{'b', 'c'}), this.newCacheId(new char[]{'a', 'b'}, new char[]{'b', 'c'}));
        this.equal("one primaryKey - equal", this.newCacheId(new Object[]{new char[]{'a', 'b'}}), this.newCacheId(new Object[]{new char[]{'a', 'b'}}));
        this.smaller("one primaryKey - smaller on first element", this.newCacheId(new Object[]{new char[]{'a', 'b'}}), this.newCacheId(new Object[]{new char[]{'b', 'c'}}));
        this.greater("one primaryKey - greater on first element", this.newCacheId(new Object[]{new char[]{'b', 'c'}}), this.newCacheId(new Object[]{new char[]{'a', 'c'}}));
        this.smaller("one primaryKey - smaller on last element", this.newCacheId(new Object[]{new char[]{'b', 'a', 'b'}}), this.newCacheId(new Object[]{new char[]{'b', 'a', 'c'}}));
        this.greater("one primaryKey - greater  on last element", this.newCacheId(new Object[]{new char[]{'0', '0', 'c'}}), this.newCacheId(new Object[]{new char[]{'0', '0', 'b'}}));
        this.smaller("many primaryKey - smaller", this.newCacheId(new char[]{'a', 'b'}, new char[]{'b', 'b'}), this.newCacheId(new char[]{'a', 'b'}, new char[]{'b', 'c'}));
        this.greater("many primaryKey - greater", this.newCacheId(new char[]{'b', 'c'}, new char[]{'a', 'd'}), this.newCacheId(new char[]{'b', 'c'}, new char[]{'a', 'c'}));
        this.greater("one primaryKey - smaller by different size", this.newCacheId(new Object[]{new char[]{'a', 'b'}}), this.newCacheId(new Object[]{new char[]{'a'}}));
        this.smaller("one primaryKey - greater by different size", this.newCacheId(new Object[]{new char[]{'b'}}), this.newCacheId(new Object[]{new char[]{'b', 'a'}}));
    }

    @Test
    public void compareToForStringArrays() {
        this.equal("many primaryKeys - equal", this.newCacheId(new Object[]{"a", "b"}, new Object[]{"b", "c"}), this.newCacheId(new Object[]{"a", "b"}, new Object[]{"b", "c"}));
        this.equal("one primaryKey - equal", this.newCacheId("a", "b"), this.newCacheId("a", "b"));
        this.smaller("one primaryKey - smaller on first element", this.newCacheId("a", "b"), this.newCacheId("b", "c"));
        this.greater("one primaryKey - greater on first element", this.newCacheId("b", "c"), this.newCacheId("a", "c"));
        this.smaller("one primaryKey - smaller on last element", this.newCacheId("b", "a", "b"), this.newCacheId("b", "a", "c"));
        this.greater("one primaryKey - greater  on last element", this.newCacheId("0", "0", "c"), this.newCacheId("0", "0", "b"));
        this.smaller("many primaryKey - smaller", this.newCacheId(new Object[]{"a", "b"}, new Object[]{"b", "b"}), this.newCacheId(new Object[]{"a", "b"}, new Object[]{"b", "c"}));
        this.greater("many primaryKey - greater", this.newCacheId(new Object[]{"b", "c"}, new Object[]{"a", "d"}), this.newCacheId(new Object[]{"b", "c"}, new Object[]{"a", "c"}));
        this.greater("one primaryKey - smaller by different size", this.newCacheId("a", "b"), this.newCacheId("a"));
        this.smaller("one primaryKey - greater by different size", this.newCacheId("b"), this.newCacheId("b", "a"));
    }

    @Test
    public void compareToForString() {
        this.equal("many primaryKeys - equal", this.newCacheId("a", "b"), this.newCacheId("a", "b"));
        this.equal("one primaryKey - equal", this.newCacheId("ab"), this.newCacheId("ab"));
        this.smaller("one primaryKey - smaller", this.newCacheId("ab"), this.newCacheId("bc"));
        this.greater("one primaryKey - greater", this.newCacheId("bc"), this.newCacheId("ac"));
        this.smaller("many primaryKey - smaller", this.newCacheId("ab", "bb"), this.newCacheId("ab", "bc"));
        this.greater("many primaryKey - greater", this.newCacheId("bc", "ad"), this.newCacheId("bc", "ac"));
        this.greater("one primaryKey - smaller by different size", this.newCacheId("ab"), this.newCacheId("a"));
        this.smaller("one primaryKey - greater by different size", this.newCacheId("b"), this.newCacheId("ba"));
    }

    @Test
    public void compareToForNulls() {
        this.equal("many primaryKeys - equal", this.newCacheId("a", null), this.newCacheId("a", null));
        this.equal("one primaryKey - equal", this.newCacheId(new Object[]{null}), this.newCacheId(new Object[]{null}));
        this.equal("null on first element - equal", this.newCacheId(null, "a"), this.newCacheId(null, "a"));
        this.greater("null on first element - greater", this.newCacheId(null, "b"), this.newCacheId(null, "a"));
        this.smaller("one primaryKey - smaller", this.newCacheId(new Object[]{null}), this.newCacheId("any"));
        this.greater("one primaryKey - greater", this.newCacheId("any"), this.newCacheId(new Object[]{null}));
        this.smaller("many primaryKey - smaller", this.newCacheId("ab", null), this.newCacheId("ab", "any"));
        this.greater("many primaryKey - greater", this.newCacheId("bc", "any"), this.newCacheId("bc", null));
    }

    @Test
    public void compareToForDifferentSize() {
        this.smaller("smaller number of primary keys", this.newCacheId("a"), this.newCacheId("a", "b"));
        this.greater("greater number of primary keys", this.newCacheId("a", "b"), this.newCacheId("a"));
    }

    @Test
    public void compareToForNotComparable() {
        this.equal("NotComparable on both sides - equal", this.newCacheId(new NotComparable(1)), this.newCacheId(new NotComparable(1)));
        this.greater("NotComparable on both sides - greater based on hashcode", this.newCacheId(new NotComparable(2)), this.newCacheId(new NotComparable(1)));
        this.smaller("NotComparable on both sides - smaller based on hashcode", this.newCacheId(new NotComparable(1)), this.newCacheId(new NotComparable(2)));
        this.smaller("not comparable on left side - result based on hashcode", this.newCacheId(new NotComparable(1)), this.newCacheId("a"));
        this.greater("not comparable on right side - result based on hashcode", this.newCacheId("b"), this.newCacheId(new NotComparable(1)));
    }

    private CacheId newCacheId(Object ... objects) {
        return new CacheId(objects);
    }

    private void equal(String description, CacheId id1, CacheId id2) {
        Assert.assertEquals((String)description, (long)0L, (long)id1.compareTo(id2));
        Assert.assertEquals((String)(description + " (equals consistency)"), (Object)id1, (Object)id2);
    }

    private void smaller(String description, CacheId id1, CacheId id2) {
        Assert.assertEquals((String)description, (long)-1L, (long)id1.compareTo(id2));
        Assert.assertNotEquals((String)(description + " (equals consistency)"), (Object)id1, (Object)id2);
    }

    private void greater(String description, CacheId id1, CacheId id2) {
        Assert.assertEquals((String)description, (long)1L, (long)id1.compareTo(id2));
        Assert.assertNotEquals((String)(description + " (equals consistency)"), (Object)id1, (Object)id2);
    }

    private static class NotComparable {
        private int code;

        private NotComparable(int code) {
            this.code = code;
        }

        public int hashCode() {
            return this.code;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NotComparable other = (NotComparable)obj;
            return this.code == other.code;
        }
    }
}

