/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.performance.writing;

import jakarta.persistence.EntityManager;
import java.sql.Date;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.framework.PerformanceRegressionTestCase;
import org.eclipse.persistence.testing.models.jpa.performance.Address;
import org.eclipse.persistence.testing.models.jpa.performance.Employee;
import org.eclipse.persistence.testing.models.jpa.performance.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.performance.PhoneNumber;

public class JPAInsertEmployeePerformanceComparisonTest
extends PerformanceRegressionTestCase {
    public JPAInsertEmployeePerformanceComparisonTest() {
        this.setDescription("This test compares the performance of insert Employee.");
    }

    public void reset() {
        EntityManager manager = this.createEntityManager();
        manager.getTransaction().begin();
        manager.createQuery("Delete from PhoneNumber where number = '9991111'").executeUpdate();
        manager.createQuery("Delete from Employee where firstName = 'NewGuy'").executeUpdate();
        manager.createQuery("Delete from Address where street = 'Hasting Perf'").executeUpdate();
        manager.getTransaction().commit();
        manager.close();
    }

    public void test() throws Exception {
        EntityManager manager = this.createEntityManager();
        manager.getTransaction().begin();
        Employee employee = new Employee();
        employee.setFirstName("NewGuy");
        employee.setLastName("Smith");
        EmploymentPeriod employmentPeriod = new EmploymentPeriod();
        Date startDate = Helper.dateFromString((String)"1901-12-31");
        Date endDate = Helper.dateFromString((String)"1970-01-01");
        employmentPeriod.setEndDate(startDate);
        employmentPeriod.setStartDate(endDate);
        employee.setPeriod(employmentPeriod);
        Address address = new Address();
        address.setCity("Ottawa");
        address.setStreet("Hastings Perf");
        address.setProvince("ONT");
        employee.setAddress(address);
        PhoneNumber phone = new PhoneNumber();
        phone.setType("home");
        phone.setAreaCode("613");
        phone.setNumber("9991111");
        employee.addPhoneNumber(phone);
        phone = new PhoneNumber();
        phone.setType("fax");
        phone.setAreaCode("613");
        phone.setNumber("9991111");
        employee.addPhoneNumber(phone);
        manager.persist((Object)employee);
        manager.getTransaction().commit();
        manager.close();
    }
}

