/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.criteria;

import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.compositepk.CompositePKTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.compositepk.Department;
import org.eclipse.persistence.testing.models.jpa.advanced.compositepk.DepartmentPK;
import org.eclipse.persistence.testing.models.jpa.advanced.compositepk.Scientist;
import org.eclipse.persistence.testing.models.jpa.advanced.compositepk.ScientistPK;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.MasterCorporal;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.MasterCorporalId;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.Sargeant;

public class AdvancedCompositePKJunitTest
extends JUnitTestCase {
    private static DepartmentPK m_departmentPK;
    private static ScientistPK m_scientist1PK;
    private static ScientistPK m_scientist2PK;
    private static ScientistPK m_scientist3PK;
    private static ScientistPK m_jScientistPK;

    public AdvancedCompositePKJunitTest() {
    }

    public AdvancedCompositePKJunitTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("AdvancedCompositePKJunitTest");
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testSetup"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testAnyAndAll"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testMappedByIdExample1"));
        return suite;
    }

    public void testSetup() {
        new CompositePKTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnyAndAll() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Scientist.class);
            Subquery sq = cq.subquery(Scientist.class);
            Root from_scientist = cq.from(Scientist.class);
            cq.where((Expression)qb.equal((Expression)from_scientist, qb.any(sq)));
            TypedQuery query1 = em.createQuery(cq);
            List results1 = query1.getResultList();
            qb = em.getCriteriaBuilder();
            cq = qb.createQuery(Scientist.class);
            sq = cq.subquery(Scientist.class);
            from_scientist = cq.from(Scientist.class);
            cq.where((Expression)qb.equal((Expression)from_scientist, qb.all(sq)));
            TypedQuery query2 = em.createQuery(cq);
            List results2 = query2.getResultList();
            qb = em.getCriteriaBuilder();
            cq = qb.createQuery(Scientist.class);
            sq = cq.subquery(Department.class);
            sq.distinct(true);
            Root from_department = sq.from(Department.class);
            sq.where((Expression)qb.and((Expression)qb.and((Expression)qb.equal((Expression)from_department.get("name"), (Object)"DEPT A"), (Expression)qb.equal((Expression)from_department.get("role"), (Object)"ROLE A")), (Expression)qb.equal((Expression)from_department.get("location"), (Object)"LOCATION A")));
            from_scientist = cq.from(Scientist.class);
            cq.where((Expression)qb.equal((Expression)from_scientist.get("department"), qb.all(sq)));
            TypedQuery query3 = em.createQuery(cq);
            List results3 = query3.getResultList();
            qb = em.getCriteriaBuilder();
            cq = qb.createQuery(Scientist.class);
            sq = cq.subquery(Department.class);
            sq.distinct(true);
            from_department = sq.from(Department.class);
            Join c = from_department.join("scientists").join("cubicle");
            sq.where((Expression)qb.equal((Expression)c.get("code"), (Object)"G"));
            from_scientist = cq.from(Scientist.class);
            cq.where((Expression)qb.equal((Expression)from_scientist.get("department"), qb.any(sq)));
            TypedQuery query4 = em.createQuery(cq);
            List results4 = query4.getResultList();
            TypedQuery controlQuery1 = em.createQuery(em.getCriteriaBuilder().createQuery(Scientist.class));
            ArrayList controlResults1 = controlQuery1.getResultList();
            ArrayList controlResults2 = controlResults1.size() == 1 ? controlResults1 : new ArrayList();
            qb = em.getCriteriaBuilder();
            cq = qb.createQuery(Scientist.class);
            from_scientist = cq.from(Scientist.class);
            Join d = from_scientist.join("department");
            cq.where((Expression)qb.and((Expression)qb.and((Expression)qb.equal((Expression)d.get("name"), (Object)"DEPT A"), (Expression)qb.equal((Expression)d.get("role"), (Object)"ROLE A")), (Expression)qb.equal((Expression)d.get("location"), (Object)"LOCATION A")));
            TypedQuery controlQuery3 = em.createQuery(cq);
            List controlResults3 = controlQuery3.getResultList();
            qb = em.getCriteriaBuilder();
            cq = qb.createQuery(Scientist.class);
            sq = cq.subquery(Department.class);
            sq.distinct(true);
            from_department = sq.from(Department.class);
            from_scientist = cq.from(Scientist.class);
            c = from_department.join("scientists").join("cubicle");
            sq.where((Expression)qb.and((Expression)qb.equal((Expression)c.get("code"), (Object)"G"), (Expression)qb.equal((Expression)from_department, (Expression)from_scientist.get("department"))));
            cq.where((Expression)qb.exists(sq));
            TypedQuery controlQuery4 = em.createQuery(cq);
            List controlResults4 = controlQuery4.getResultList();
            this.compareResults(results1, controlResults1, "query1");
            this.compareResults(results2, controlResults2, "query2");
            this.compareResults(results3, controlResults3, "query3");
            this.compareResults(results4, controlResults4, "query4");
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    protected void compareResults(List results, List controlResults, String testName) {
        if (results.size() != controlResults.size()) {
            AdvancedCompositePKJunitTest.fail((String)(testName + ": results.size() = " + results.size() + "; controlResults.size() = " + controlResults.size()));
        }
        for (Object s : results) {
            if (controlResults.contains(s)) continue;
            AdvancedCompositePKJunitTest.fail((String)(testName + ": " + s + "contained in results but not in controlResults"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMappedByIdExample1() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Sargeant sargeant = new Sargeant();
        MasterCorporal masterCorporal = new MasterCorporal();
        MasterCorporalId masterCorporalId = new MasterCorporalId();
        try {
            sargeant.setName("Sarge");
            em.persist((Object)sargeant);
            masterCorporalId.setName("Corpie");
            masterCorporal.setId(masterCorporalId);
            masterCorporal.setSargeant(sargeant);
            em.persist((Object)masterCorporal);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(MasterCorporal.class);
            Root from = cq.from(MasterCorporal.class);
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)from.get("id").get("name"), (Object)"Corpie"), (Expression)qb.equal((Expression)from.get("sargeant").get("sargeantId"), (Object)sargeant.getSargeantId())));
            TypedQuery query1 = em.createQuery(cq);
            MasterCorporal results1 = (MasterCorporal)query1.getSingleResult();
            qb = em.getCriteriaBuilder();
            cq = qb.createQuery(MasterCorporal.class);
            from = cq.from(MasterCorporal.class);
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)from.get("id").get("name"), (Object)"Corpie"), (Expression)qb.equal((Expression)from.get("id").get("sargeantPK"), (Object)sargeant.getSargeantId())));
            TypedQuery query2 = em.createQuery(cq);
            MasterCorporal results2 = (MasterCorporal)query2.getSingleResult();
            MasterCorporal refreshedMasterCorporal = (MasterCorporal)em.find(MasterCorporal.class, (Object)masterCorporalId);
            AdvancedCompositePKJunitTest.assertTrue((String)"The master corporal read back did not match the original", (boolean)AdvancedCompositePKJunitTest.getServerSession().compareObjects((Object)masterCorporal, (Object)refreshedMasterCorporal));
            AdvancedCompositePKJunitTest.assertTrue((String)"The master corporal read using criteria expression1 is not the same instance as returned by the finder", (refreshedMasterCorporal == results1 ? 1 : 0) != 0);
            AdvancedCompositePKJunitTest.assertTrue((String)"The master corporal read using criteria expression2 is not the same instance as returned by the finder", (refreshedMasterCorporal == results2 ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }
}

