/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fieldaccess.advanced;

import jakarta.persistence.EntityManager;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.EmployeeListener;

public class CallbackEventJUnitTestSuite
extends JUnitTestCase {
    protected boolean m_reset = false;
    protected Employee new_emp = null;
    protected int m_beforeEvent;
    protected int m_afterEvent;

    public CallbackEventJUnitTestSuite() {
    }

    public CallbackEventJUnitTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("CallbackEventJUnitTestSuite");
        suite.addTest((Test)new CallbackEventJUnitTestSuite("testSetup"));
        suite.addTest((Test)new CallbackEventJUnitTestSuite("testPersistThenRemoveCalls"));
        suite.addTest((Test)new CallbackEventJUnitTestSuite("testRemoveUnmanagedNewEntity"));
        suite.addTest((Test)new CallbackEventJUnitTestSuite("testPersistOnRegisteredObject"));
        suite.addTest((Test)new CallbackEventJUnitTestSuite("testPreUpdateEvent_UpdateAltered"));
        suite.addTest((Test)new CallbackEventJUnitTestSuite("testPreUpdateEvent_UpdateReverted"));
        return suite;
    }

    public void testSetup() {
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession((String)"fieldaccess"));
        CallbackEventJUnitTestSuite.clearCache((String)"fieldaccess");
    }

    public void setUp() {
        this.m_reset = true;
        super.setUp();
        EntityManager em = CallbackEventJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            this.new_emp = new Employee();
            this.new_emp.setFirstName("New");
            this.new_emp.setLastName("Guy");
            em.persist((Object)this.new_emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        CallbackEventJUnitTestSuite.clearCache((String)"fieldaccess");
    }

    public void testPersistThenRemoveCalls() throws Exception {
        CallbackEventJUnitTestSuite.clearCache((String)"fieldaccess");
        this.m_beforeEvent = EmployeeListener.PRE_REMOVE_COUNT;
        int m_beforePrePersistEvent = EmployeeListener.PRE_PERSIST_COUNT;
        EntityManager em = CallbackEventJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        Employee employee = new Employee();
        try {
            employee = new Employee();
            em.persist((Object)employee);
            em.remove((Object)employee);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.m_afterEvent = EmployeeListener.PRE_REMOVE_COUNT;
        int m_afterPrePersistEvent = EmployeeListener.PRE_PERSIST_COUNT;
        if (em.find(Employee.class, (Object)employee.getId()) != null) {
            CallbackEventJUnitTestSuite.fail((String)"Employee was inserted.");
        }
        this.closeEntityManager(em);
        CallbackEventJUnitTestSuite.assertTrue((String)"The prePersist callback method was not called.", (m_beforePrePersistEvent != m_afterPrePersistEvent ? 1 : 0) != 0);
        CallbackEventJUnitTestSuite.assertTrue((String)"The preRemove callback method was not called.", (this.m_beforeEvent != this.m_afterEvent ? 1 : 0) != 0);
    }

    public void testRemoveUnmanagedNewEntity() throws Exception {
        this.m_beforeEvent = EmployeeListener.PRE_REMOVE_COUNT;
        CallbackEventJUnitTestSuite.clearCache((String)"fieldaccess");
        EntityManager em = CallbackEventJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            Employee newEmp = new Employee();
            newEmp.setFirstName("new");
            newEmp.setLastName("guy2");
            em.remove((Object)newEmp);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.m_afterEvent = EmployeeListener.PRE_REMOVE_COUNT;
        this.closeEntityManager(em);
        CallbackEventJUnitTestSuite.assertTrue((String)"The preRemove callback method was called, remove should have been ignored.", (this.m_beforeEvent == this.m_afterEvent ? 1 : 0) != 0);
    }

    public void testPersistOnRegisteredObject() {
        CallbackEventJUnitTestSuite.clearCache((String)"fieldaccess");
        EntityManager em = CallbackEventJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            Employee newEmp = new Employee();
            newEmp.setFirstName("new2");
            newEmp.setLastName("guy2");
            em.persist((Object)newEmp);
            this.m_beforeEvent = EmployeeListener.POST_PERSIST_COUNT;
            em.persist((Object)newEmp);
            this.m_afterEvent = EmployeeListener.POST_PERSIST_COUNT;
            this.rollbackTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        CallbackEventJUnitTestSuite.assertTrue((String)"Calling persist on a managed object should be ignored", (this.m_beforeEvent == this.m_afterEvent ? 1 : 0) != 0);
    }

    public void testPreUpdateEvent_UpdateAltered() {
        this.internalTestPreUpdateEvent(false);
    }

    public void testPreUpdateEvent_UpdateReverted() {
        this.internalTestPreUpdateEvent(true);
    }

    protected void internalTestPreUpdateEvent(boolean shouldUseOriginalName) {
        EntityManager em = CallbackEventJUnitTestSuite.createEntityManager((String)"fieldaccess");
        Employee emp = null;
        int originalVersion = 0;
        String firstNameExpectedAfterCommit = "";
        this.beginTransaction(em);
        try {
            emp = (Employee)em.find(Employee.class, (Object)this.new_emp.getId());
            originalVersion = this.getVersion(emp);
            firstNameExpectedAfterCommit = shouldUseOriginalName ? emp.getFirstName() : "Updated" + emp.getFirstName();
            String firstNameAssigned = EmployeeListener.PRE_UPDATE_NAME_PREFIX + firstNameExpectedAfterCommit;
            emp.setFirstName(firstNameAssigned);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        emp = (Employee)em.find(Employee.class, (Object)this.new_emp.getId());
        if (!emp.getFirstName().equals(firstNameExpectedAfterCommit)) {
            CallbackEventJUnitTestSuite.fail((String)("In cache: wrong firstName = " + emp.getFirstName() + "; " + firstNameExpectedAfterCommit + " was expected"));
        }
        int version = this.getVersion(emp);
        if (!shouldUseOriginalName && originalVersion >= version) {
            CallbackEventJUnitTestSuite.fail((String)("In cache: wrong version = " + version + "; version > " + originalVersion + " was expected"));
        }
        if (!(emp = (Employee)em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.id = " + this.new_emp.getId()).setHint("eclipselink.refresh", (Object)Boolean.TRUE).getSingleResult()).getFirstName().equals(firstNameExpectedAfterCommit)) {
            CallbackEventJUnitTestSuite.fail((String)("In DB: wrong firstName = " + emp.getFirstName() + "; " + firstNameExpectedAfterCommit + " was expected"));
        }
        version = this.getVersion(emp);
        if (!shouldUseOriginalName && originalVersion >= version) {
            CallbackEventJUnitTestSuite.fail((String)("In DB: wrong version = " + version + "; version > " + originalVersion + " was expected"));
        }
    }

    protected int getVersion(Employee emp) {
        Vector<Integer> pk = new Vector<Integer>();
        pk.add(emp.getId());
        return (Integer)CallbackEventJUnitTestSuite.getServerSession((String)"fieldaccess").getDescriptor(Employee.class).getOptimisticLockingPolicy().getWriteLockValue((Object)emp, pk, (AbstractSession)CallbackEventJUnitTestSuite.getServerSession((String)"fieldaccess"));
    }
}

