/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.cascadepersist.CascadePersistTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.cascadepersist.EntityX;
import org.eclipse.persistence.testing.models.jpa.advanced.cascadepersist.EntityY;
import org.eclipse.persistence.testing.models.jpa.advanced.cascadepersist.EntityZ;

public class CascadePersistJUnitTestSuite
extends JUnitTestCase {
    public CascadePersistJUnitTestSuite() {
    }

    public CascadePersistJUnitTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("CascadePersistJUnitTestSuite");
        suite.addTest((Test)new CascadePersistJUnitTestSuite("testSetup"));
        suite.addTest((Test)new CascadePersistJUnitTestSuite("testCascadePersistForUnregisteredObjects"));
        return suite;
    }

    public void testSetup() {
        new CascadePersistTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public void testCascadePersistForUnregisteredObjects() {
        ArrayList<Throwable> errorList = new ArrayList<Throwable>();
        for (int i = 0; i < 10; ++i) {
            try {
                this.persistObjects(i);
                continue;
            }
            catch (Throwable t) {
                errorList.add(t);
            }
        }
        String errorMsg = new String();
        if (!errorList.isEmpty()) {
            errorMsg = ((Throwable)errorList.get(0)).getMessage();
        }
        Assert.assertTrue((String)(errorList.size() + " tests failed out of 10 tests with exception " + errorMsg), (errorList.size() == 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistObjects(int id) throws Exception {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            EntityX x = new EntityX();
            x.setId(id);
            x.setXname("Bob" + id);
            EntityY y = new EntityY();
            y.setId(100 + id);
            y.setYname("Smith" + id);
            EntityZ z = new EntityZ();
            z.setId(1000 + id);
            z.setZname("Robin" + id);
            em.persist((Object)z);
            em.persist((Object)x);
            x.setEntityY(y);
            y.setEntityX(x);
            z.addYToList(y);
            y.setYzEntityRelation(z);
            em.flush();
        }
        finally {
            this.rollbackTransaction(em);
            if (em != null && em.isOpen()) {
                this.closeEntityManager(em);
            }
        }
    }
}

