/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.simultaneous;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.QueryResultsCachePolicy;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ConcurrentQueryCacheQueryResultsTest
extends TestCase {
    protected static final int CACHE_SIZE = 5;
    protected static final int CONCURRENT_THREADS = 7;
    protected static final int TESTDATA_INSTANCES = 100;
    protected static final int NUMBER_OF_EXECUTIONS = 20000;
    protected static final int TIMEOUT_IN_SECONDS = 60;
    protected static final String QUERY_NAME = "findEmployeeByFirstName";
    protected List<Employee> testEmployees;
    protected List<Boolean> testResults;
    protected boolean terminatedNormally;

    public ConcurrentQueryCacheQueryResultsTest() {
        this.setDescription("Test invoking many queries from multiple threads against a QueryCache");
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        ExpressionBuilder builder = query.getExpressionBuilder();
        query.setSelectionCriteria(builder.get("firstName").equal(builder.getParameter("firstName")));
        query.addArgument("firstName");
        query.setQueryResultsCachePolicy(new QueryResultsCachePolicy(5));
        this.getSession().addQuery(QUERY_NAME, (DatabaseQuery)query);
        this.testEmployees = new ArrayList<Employee>(100);
        this.testResults = new ArrayList<Boolean>(20000);
        for (int i = 0; i < 20000; ++i) {
            this.testResults.add(i, Boolean.FALSE);
        }
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        for (int i = 0; i < 100; ++i) {
            Employee emp = new Employee();
            emp.setFirstName(String.valueOf(UUID.randomUUID()).substring(0, 8));
            emp.setLastName(String.valueOf(UUID.randomUUID()).substring(0, 8));
            uow.registerObject((Object)emp);
            this.testEmployees.add(emp);
        }
        uow.commit();
    }

    public void test() throws Throwable {
        ExecutorService executor = Executors.newFixedThreadPool(7);
        for (int resultId = 0; resultId < 20000; ++resultId) {
            executor.execute(new QueryWorkerThread(resultId));
        }
        executor.shutdown();
        this.terminatedNormally = executor.awaitTermination(60L, TimeUnit.SECONDS);
    }

    public void verify() {
        if (!this.terminatedNormally) {
            ConcurrentQueryCacheQueryResultsTest.fail((String)(((Object)((Object)this)).getClass().getSimpleName() + " timed out whilst executing, after " + 60 + " seconds"));
        }
        for (int resultId = 0; resultId < 20000; ++resultId) {
            if (this.testResults.get(resultId) != Boolean.FALSE) continue;
            ConcurrentQueryCacheQueryResultsTest.fail((String)("Test result failed (false) for test result id: " + resultId));
        }
    }

    public void reset() {
        this.getSession().removeQuery(QUERY_NAME);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.deleteAllObjects(this.testEmployees);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected class QueryWorkerThread
    implements Runnable {
        protected int resultId;

        public QueryWorkerThread(int resultId) {
            this.resultId = resultId;
        }

        @Override
        public void run() {
            int randomNumber = new Random().nextInt(100);
            Employee randomEmployee = ConcurrentQueryCacheQueryResultsTest.this.testEmployees.get(randomNumber);
            Vector<String> args = new Vector<String>();
            args.add(randomEmployee.getFirstName());
            Employee employeeFound = (Employee)ConcurrentQueryCacheQueryResultsTest.this.getSession().executeQuery(ConcurrentQueryCacheQueryResultsTest.QUERY_NAME, args);
            junit.framework.TestCase.assertEquals((Object)randomEmployee.getId(), (Object)employeeFound.getId());
            junit.framework.TestCase.assertEquals((String)randomEmployee.getFirstName(), (String)employeeFound.getFirstName());
            junit.framework.TestCase.assertEquals((String)randomEmployee.getLastName(), (String)employeeFound.getLastName());
            ConcurrentQueryCacheQueryResultsTest.this.testResults.set(this.resultId, Boolean.TRUE);
        }
    }
}

