/*
 * Copyright (c) 1998, 2019 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     Mike Norman - Aug 2008, created DBWS JDev(Boxer) packager

package org.eclipse.persistence.tools.dbws;

import static org.eclipse.persistence.tools.dbws.DBWSPackager.ArchiveUse.noArchive;

//javase imports
import java.io.OutputStream;

//EclipseLink imports
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.internal.sessions.factories.model.session.DatabaseSessionConfig;

/**
 * <p>
 * <b>PUBLIC:</b> JDevPackager extends {@link IDEPackager}. It is responsible for generating<br>
 * the source code of the DBWS Provider (instead of a <code>.class</code> file) and packaging in a<br>
 * JDev-friendly directory structure all the other DBWS files produced by its parent:
 * <pre>
 * \--- JDev <b>Projectnnn</b> root directory
 *    |   dbws-builder.xml
 *    |
 *    +---<b>public_html</b>
 *    |   \---WEB-INF
 *    |       |   <b>web.xml</b>
 *    |       |
 *    |       \---wsdl
 *    |               <b><i>swaref.xsd</i></b>
 *    |               <b>eclipselink-dbws-schema.xsd</b>
 *    |               <b>eclipselink-dbws.wsdl</b>
 *    |
 *    \---<b>src</b>
 *        |   <b>eclipselink-dbws-or.xml</b>
 *        |   <b>eclipselink-dbws-ox.xml</b>
 *        |   <b>eclipselink-dbws-sessions.xml</b>
 *        |   <b>eclipselink-dbws.xml</b>
 *        |
 *        \---_dbws
 *                <b>DBWSProvider.java</b>  -- generated by this Packager
 * </pre>
 *
 * @author Mike Norman - michael.norman@oracle.com
 * @since EclipseLink 1.x
 */
public class JDevPackager extends IDEPackager {

    public static final String PUBLIC_HTML_DIR = "public_html";

    public JDevPackager() {
        this(null, "jdev", noArchive);
        srcDirname = SRC_DIR;
        publicHTMLDirname = PUBLIC_HTML_DIR;
    }
    protected JDevPackager(Archiver archiver, String packagerLabel, ArchiveUse useJavaArchive) {
        super(archiver, packagerLabel, useJavaArchive);
    }

    @Override
    public SessionConfigs buildSessionsXML(OutputStream dbwsSessionsStream, DBWSBuilder builder) {
        SessionConfigs ts = super.buildSessionsXML(dbwsSessionsStream, builder);
        String dataSource = builder.getDataSource();
        if (dataSource != null) {
            DatabaseSessionConfig tmpConfig =
                (DatabaseSessionConfig)ts.getSessionConfigs().firstElement();
            WeblogicPackager.buildDatabaseSessionConfig(ts, tmpConfig, builder);
        }
        return ts;
    }

}
