/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.xml.advanced;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCaseHelper;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.multitenant.AdvancedMultiTenantTableCreator;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.multitenant.Boss;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.multitenant.Candidate;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.multitenant.Capo;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.multitenant.Contract;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.multitenant.MafiaFamily;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.multitenant.Mafioso;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.multitenant.Mason;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.multitenant.Party;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.multitenant.Riding;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.multitenant.Soldier;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.multitenant.Supporter;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.multitenant.Trowel;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.multitenant.Underboss;

public class EntityMappingsMultitenantJUnitTestCase
extends JUnitTestCase {
    public static final String MULTI_TENANT_PU = "extended-multi-tenant-shared-emf";
    public static final String MULTI_TENANT_PU_123 = "extended-multi-tenant-123";
    public static final String MULTI_TENANT_TABLE_PER_TENANT_PU = "extended-multi-tenant-table-per-tenant";
    public static final String MULTI_TENANT_TABLE_PER_TENANT_C_PU = "extended-multi-tenant-table-per-tenant-C";
    private static final String MULTI_TENANT_TABLE_PER_TENANT = null;
    public static long candidateAId;
    public static long supporter1Id;
    public static long supporter2Id;
    public static int ridingId;
    public static int partyId;
    public static int masonId;
    public static int family707;
    public static int family007;
    public static int family123;
    public static List<Integer> family707Mafiosos;
    public static List<Integer> family707Contracts;
    public static List<Integer> family007Mafiosos;
    public static List<Integer> family007Contracts;
    public static List<Integer> family123Mafiosos;
    public static List<Integer> family123Contracts;

    public EntityMappingsMultitenantJUnitTestCase() {
    }

    public EntityMappingsMultitenantJUnitTestCase(String name) {
        super(name);
    }

    public void setUp() {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Extended Advanced Multitenant Test Suite");
        suite.addTest((Test)new EntityMappingsMultitenantJUnitTestCase("testSetup"));
        suite.addTest((Test)new EntityMappingsMultitenantJUnitTestCase("testCreateMafiaFamily707"));
        suite.addTest((Test)new EntityMappingsMultitenantJUnitTestCase("testCreateMafiaFamily007"));
        suite.addTest((Test)new EntityMappingsMultitenantJUnitTestCase("testCreateMafiaFamily123"));
        suite.addTest((Test)new EntityMappingsMultitenantJUnitTestCase("testValidateMafiaFamily707"));
        suite.addTest((Test)new EntityMappingsMultitenantJUnitTestCase("testValidateMafiaFamily007"));
        suite.addTest((Test)new EntityMappingsMultitenantJUnitTestCase("testValidateMafiaFamily707and007WithSameEM"));
        suite.addTest((Test)new EntityMappingsMultitenantJUnitTestCase("testValidateMafiaFamily123"));
        suite.addTest((Test)new EntityMappingsMultitenantJUnitTestCase("testTablePerTenantA"));
        suite.addTest((Test)new EntityMappingsMultitenantJUnitTestCase("testTablePerTenantB"));
        suite.addTest((Test)new EntityMappingsMultitenantJUnitTestCase("testTablePerTenantC"));
        return suite;
    }

    public void testSetup() {
        new AdvancedMultiTenantTableCreator().replaceTables((DatabaseSession)((JpaEntityManager)EntityMappingsMultitenantJUnitTestCase.createEntityManager((String)MULTI_TENANT_PU)).getServerSession());
    }

    public void testCreateMafiaFamily707() {
        EntityManager em = EntityMappingsMultitenantJUnitTestCase.createEntityManager((String)MULTI_TENANT_PU);
        try {
            this.beginTransaction(em);
            em.setProperty("tenant.id", (Object)"707");
            em.setProperty("eclipselink.tenant-id", (Object)"707");
            MafiaFamily family = new MafiaFamily();
            family.setName("Gonzo");
            family.setRevenue(Double.valueOf(1.0E7));
            family.addTag("firstTag");
            family.addTag("secondTag");
            family.addTag("thirdTag");
            Boss boss = new Boss();
            boss.setFirstName("707");
            boss.setLastName("Boss");
            boss.setGender(Mafioso.Gender.Male);
            Underboss underboss = new Underboss();
            underboss.setFirstName("Under");
            underboss.setLastName("Boss");
            underboss.setGender(Mafioso.Gender.Male);
            Capo capo1 = new Capo();
            capo1.setFirstName("Capo");
            capo1.setLastName("Giggaloo");
            capo1.setGender(Mafioso.Gender.Female);
            Capo capo2 = new Capo();
            capo2.setFirstName("Capo");
            capo2.setLastName("CrazyGlue");
            capo2.setGender(Mafioso.Gender.Male);
            Soldier soldier1 = new Soldier();
            soldier1.setFirstName("Soldier");
            soldier1.setLastName("One");
            soldier1.setGender(Mafioso.Gender.Female);
            Soldier soldier2 = new Soldier();
            soldier2.setFirstName("Soldier");
            soldier2.setLastName("Two");
            soldier2.setGender(Mafioso.Gender.Male);
            Soldier soldier3 = new Soldier();
            soldier3.setFirstName("Soldier");
            soldier3.setLastName("Three");
            soldier3.setGender(Mafioso.Gender.Male);
            Soldier soldier4 = new Soldier();
            soldier4.setFirstName("Soldier");
            soldier4.setLastName("Four");
            soldier4.setGender(Mafioso.Gender.Male);
            Soldier soldier5 = new Soldier();
            soldier5.setFirstName("Soldier");
            soldier5.setLastName("Four");
            soldier5.setGender(Mafioso.Gender.Female);
            Contract contract1 = new Contract();
            contract1.setDescription("Whack 007 family boss");
            Contract contract2 = new Contract();
            contract2.setDescription("Acquire fully-automatic guns");
            Contract contract3 = new Contract();
            contract3.setDescription("Steal some money");
            contract1.addSoldier(soldier1);
            contract1.addSoldier(soldier5);
            contract2.addSoldier(soldier1);
            contract2.addSoldier(soldier3);
            contract2.addSoldier(soldier5);
            contract3.addSoldier(soldier2);
            contract3.addSoldier(soldier3);
            contract3.addSoldier(soldier4);
            contract3.addSoldier(soldier5);
            boss.setUnderboss(underboss);
            capo1.setUnderboss(underboss);
            capo2.setUnderboss(underboss);
            capo1.addSoldier(soldier1);
            capo1.addSoldier(soldier2);
            capo2.addSoldier(soldier3);
            capo2.addSoldier(soldier4);
            capo2.addSoldier(soldier5);
            underboss.addCapo(capo1);
            underboss.addCapo(capo2);
            family.addMafioso((Mafioso)boss);
            family.addMafioso((Mafioso)underboss);
            family.addMafioso((Mafioso)capo1);
            family.addMafioso((Mafioso)capo2);
            family.addMafioso((Mafioso)soldier1);
            family.addMafioso((Mafioso)soldier2);
            family.addMafioso((Mafioso)soldier3);
            family.addMafioso((Mafioso)soldier4);
            family.addMafioso((Mafioso)soldier5);
            em.persist((Object)family);
            family707 = family.getId();
            family707Mafiosos.add(boss.getId());
            family707Mafiosos.add(underboss.getId());
            family707Mafiosos.add(capo1.getId());
            family707Mafiosos.add(capo2.getId());
            family707Mafiosos.add(soldier1.getId());
            family707Mafiosos.add(soldier2.getId());
            family707Mafiosos.add(soldier3.getId());
            family707Mafiosos.add(soldier4.getId());
            family707Mafiosos.add(soldier5.getId());
            family707Contracts.add(contract1.getId());
            family707Contracts.add(contract2.getId());
            family707Contracts.add(contract3.getId());
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testCreateMafiaFamily007() {
        EntityManager em = EntityMappingsMultitenantJUnitTestCase.createEntityManager((String)MULTI_TENANT_PU);
        try {
            this.beginTransaction(em);
            em.setProperty("tenant.id", (Object)"007");
            em.setProperty("eclipselink.tenant-id", (Object)"007");
            MafiaFamily family = new MafiaFamily();
            family.setName("Bond");
            family.setRevenue(Double.valueOf(9.8765432103E8));
            family.addTag("tag1");
            family.addTag("tag2");
            family.addTag("tag3");
            family.addTag("tag4");
            family.addTag("tag5");
            Boss boss = new Boss();
            boss.setFirstName("007");
            boss.setLastName("Boss");
            boss.setGender(Mafioso.Gender.Female);
            Underboss underboss = new Underboss();
            underboss.setFirstName("Second");
            underboss.setLastName("InCommand");
            underboss.setGender(Mafioso.Gender.Female);
            Capo capo1 = new Capo();
            capo1.setFirstName("Capo");
            capo1.setLastName("Lubey");
            capo1.setGender(Mafioso.Gender.Male);
            Capo capo2 = new Capo();
            capo2.setFirstName("Capo");
            capo2.setLastName("Greasy");
            capo2.setGender(Mafioso.Gender.Female);
            Soldier soldier1 = new Soldier();
            soldier1.setFirstName("First");
            soldier1.setLastName("Grunt");
            soldier1.setGender(Mafioso.Gender.Male);
            Soldier soldier2 = new Soldier();
            soldier2.setFirstName("Second");
            soldier2.setLastName("Grunt");
            soldier2.setGender(Mafioso.Gender.Female);
            Soldier soldier3 = new Soldier();
            soldier3.setFirstName("Third");
            soldier3.setLastName("Grunt");
            soldier3.setGender(Mafioso.Gender.Female);
            Soldier soldier4 = new Soldier();
            soldier4.setFirstName("Fourth");
            soldier4.setLastName("Grunt");
            soldier4.setGender(Mafioso.Gender.Female);
            Soldier soldier5 = new Soldier();
            soldier5.setFirstName("Fifth");
            soldier5.setLastName("Grunt");
            soldier5.setGender(Mafioso.Gender.Male);
            Soldier soldier6 = new Soldier();
            soldier6.setFirstName("Sixth");
            soldier6.setLastName("Grunt");
            soldier6.setGender(Mafioso.Gender.Male);
            Soldier soldier7 = new Soldier();
            soldier7.setFirstName("Seventh");
            soldier7.setLastName("Grunt");
            soldier7.setGender(Mafioso.Gender.Male);
            Contract contract1 = new Contract();
            contract1.setDescription("Whack 707 family boss");
            Contract contract2 = new Contract();
            contract2.setDescription("Acquire semi-automatic guns");
            Contract contract3 = new Contract();
            contract3.setDescription("Set up new financing deals");
            contract1.addSoldier(soldier1);
            contract1.addSoldier(soldier5);
            contract2.addSoldier(soldier1);
            contract2.addSoldier(soldier3);
            contract2.addSoldier(soldier7);
            contract3.addSoldier(soldier2);
            contract3.addSoldier(soldier3);
            contract3.addSoldier(soldier4);
            contract3.addSoldier(soldier5);
            boss.setUnderboss(underboss);
            capo1.setUnderboss(underboss);
            capo2.setUnderboss(underboss);
            capo1.addSoldier(soldier1);
            capo1.addSoldier(soldier2);
            capo2.addSoldier(soldier3);
            capo2.addSoldier(soldier4);
            capo2.addSoldier(soldier5);
            capo2.addSoldier(soldier6);
            capo2.addSoldier(soldier7);
            underboss.addCapo(capo1);
            underboss.addCapo(capo2);
            family.addMafioso((Mafioso)boss);
            family.addMafioso((Mafioso)underboss);
            family.addMafioso((Mafioso)capo1);
            family.addMafioso((Mafioso)capo2);
            family.addMafioso((Mafioso)soldier1);
            family.addMafioso((Mafioso)soldier2);
            family.addMafioso((Mafioso)soldier3);
            family.addMafioso((Mafioso)soldier4);
            family.addMafioso((Mafioso)soldier5);
            family.addMafioso((Mafioso)soldier6);
            family.addMafioso((Mafioso)soldier7);
            em.persist((Object)family);
            family007 = family.getId();
            family007Mafiosos.add(boss.getId());
            family007Mafiosos.add(underboss.getId());
            family007Mafiosos.add(capo1.getId());
            family007Mafiosos.add(capo2.getId());
            family007Mafiosos.add(soldier1.getId());
            family007Mafiosos.add(soldier2.getId());
            family007Mafiosos.add(soldier3.getId());
            family007Mafiosos.add(soldier4.getId());
            family007Mafiosos.add(soldier5.getId());
            family007Mafiosos.add(soldier6.getId());
            family007Mafiosos.add(soldier7.getId());
            family007Contracts.add(contract1.getId());
            family007Contracts.add(contract2.getId());
            family007Contracts.add(contract3.getId());
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testCreateMafiaFamily123() {
        EntityManager em = EntityMappingsMultitenantJUnitTestCase.createEntityManager((String)MULTI_TENANT_PU_123);
        try {
            this.beginTransaction(em);
            MafiaFamily family = new MafiaFamily();
            family.setName("Galore");
            family.setRevenue(Double.valueOf(4321.03));
            family.addTag("newtag1");
            Boss boss = new Boss();
            boss.setFirstName("Kitty");
            boss.setLastName("Galore");
            boss.setGender(Mafioso.Gender.Female);
            Underboss underboss = new Underboss();
            underboss.setFirstName("Number2");
            underboss.setLastName("Galore");
            underboss.setGender(Mafioso.Gender.Male);
            Capo capo1 = new Capo();
            capo1.setFirstName("Capo");
            capo1.setLastName("Galore");
            capo1.setGender(Mafioso.Gender.Male);
            Soldier soldier1 = new Soldier();
            soldier1.setFirstName("Grunt");
            soldier1.setLastName("Galore");
            soldier1.setGender(Mafioso.Gender.Male);
            Contract contract1 = new Contract();
            contract1.setDescription("Whack all other family boss");
            Contract contract2 = new Contract();
            contract2.setDescription("Pillage, pillage, pillage!");
            contract1.addSoldier(soldier1);
            contract2.addSoldier(soldier1);
            boss.setUnderboss(underboss);
            capo1.setUnderboss(underboss);
            capo1.addSoldier(soldier1);
            underboss.addCapo(capo1);
            family.addMafioso((Mafioso)boss);
            family.addMafioso((Mafioso)underboss);
            family.addMafioso((Mafioso)capo1);
            family.addMafioso((Mafioso)soldier1);
            em.persist((Object)family);
            family123 = family.getId();
            family123Mafiosos.add(boss.getId());
            family123Mafiosos.add(underboss.getId());
            family123Mafiosos.add(capo1.getId());
            family123Mafiosos.add(soldier1.getId());
            family123Contracts.add(contract1.getId());
            family123Contracts.add(contract2.getId());
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testValidateMafiaFamily707() {
        EntityManager em = EntityMappingsMultitenantJUnitTestCase.createEntityManager((String)MULTI_TENANT_PU);
        try {
            this.validateMafiaFamily707(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testValidateMafiaFamily007() {
        EntityManager em = EntityMappingsMultitenantJUnitTestCase.createEntityManager((String)MULTI_TENANT_PU);
        try {
            this.validateMafiaFamily007(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testValidateMafiaFamily707and007WithSameEM() {
        EntityManager em = EntityMappingsMultitenantJUnitTestCase.createEntityManager((String)MULTI_TENANT_PU);
        try {
            this.validateMafiaFamily707(em);
            this.validateMafiaFamily007(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testValidateMafiaFamily123() {
        EntityManager em = EntityMappingsMultitenantJUnitTestCase.createEntityManager((String)MULTI_TENANT_PU_123);
        try {
            EntityMappingsMultitenantJUnitTestCase.clearCache((String)MULTI_TENANT_PU_123);
            em.clear();
            MafiaFamily family = (MafiaFamily)em.find(MafiaFamily.class, (Object)family123);
            EntityMappingsMultitenantJUnitTestCase.assertNotNull((String)("The Mafia Family with id: " + family123 + ", was not found"), (Object)family);
            EntityMappingsMultitenantJUnitTestCase.assertTrue((String)("The Mafia Family had an incorrect number of tags [" + family.getTags().size() + "], expected [1]"), (family.getTags().size() == 1 ? 1 : 0) != 0);
            EntityMappingsMultitenantJUnitTestCase.assertNull((String)("The Mafia Family with id: " + family707 + ", was found (when it should not have been)"), (Object)em.find(MafiaFamily.class, (Object)family707));
            EntityMappingsMultitenantJUnitTestCase.assertNull((String)("The Mafia Family with id: " + family007 + ", was found (when it should not have been)"), (Object)em.find(MafiaFamily.class, (Object)family007));
            EntityMappingsMultitenantJUnitTestCase.assertFalse((String)"No mafiosos part of 123 family", (boolean)family.getMafiosos().isEmpty());
            for (Integer id : family707Mafiosos) {
                EntityMappingsMultitenantJUnitTestCase.assertNull((String)"Found family 707 mafioso.", (Object)em.find(Mafioso.class, (Object)id));
            }
            boolean exceptionCaught = false;
            List mafiaFamilies = null;
            try {
                mafiaFamilies = em.createNativeQuery("select * from XML_MAFIA_FAMILY").getResultList();
            }
            catch (Exception e) {
                exceptionCaught = true;
            }
            EntityMappingsMultitenantJUnitTestCase.assertTrue((String)"No exception was caught from issuing a native query.", (boolean)exceptionCaught);
            Boss otherBoss = (Boss)em.find(Boss.class, (Object)family707Mafiosos.get(0));
            EntityMappingsMultitenantJUnitTestCase.assertNull((String)"Found family 707 boss.", (Object)otherBoss);
            for (Integer id : family707Contracts) {
                EntityMappingsMultitenantJUnitTestCase.assertNull((String)"Found family 707 contract. ", (Object)em.find(Contract.class, (Object)id));
            }
            List families = em.createNamedQuery("findJPQLXMLMafiaFamilies").getResultList();
            EntityMappingsMultitenantJUnitTestCase.assertTrue((String)("Incorrect number of families were returned [" + families.size() + "], expected [1]"), (families.size() == 1 ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    protected void validateMafiaFamily007(EntityManager em) {
        EntityMappingsMultitenantJUnitTestCase.clearCache((String)MULTI_TENANT_PU);
        em.clear();
        this.beginTransaction(em);
        em.setProperty("tenant.id", (Object)"007");
        em.setProperty("eclipselink.tenant-id", (Object)"007");
        MafiaFamily family = (MafiaFamily)em.find(MafiaFamily.class, (Object)family007);
        EntityMappingsMultitenantJUnitTestCase.assertNotNull((String)("The Mafia Family with id: " + family007 + ", was not found"), (Object)family);
        EntityMappingsMultitenantJUnitTestCase.assertTrue((String)("The Mafia Family had an incorrect number of tags [" + family.getTags().size() + "], expected [5]"), (family.getTags().size() == 5 ? 1 : 0) != 0);
        EntityMappingsMultitenantJUnitTestCase.assertNull((String)("The Mafia Family with id: " + family707 + ", was found (when it should not have been)"), (Object)em.find(MafiaFamily.class, (Object)family707));
        EntityMappingsMultitenantJUnitTestCase.assertNull((String)("The Mafia Family with id: " + family123 + ", was found (when it should not have been)"), (Object)em.find(MafiaFamily.class, (Object)family123));
        EntityMappingsMultitenantJUnitTestCase.assertFalse((String)"No mafiosos part of 007 family", (boolean)family.getMafiosos().isEmpty());
        for (Integer n : family707Mafiosos) {
            EntityMappingsMultitenantJUnitTestCase.assertNull((String)"Found family 707 mafioso.", (Object)em.find(Mafioso.class, (Object)n));
        }
        Boss otherBoss = (Boss)em.find(Boss.class, (Object)family707Mafiosos.get(0));
        EntityMappingsMultitenantJUnitTestCase.assertNull((String)"Found family 707 boss.", (Object)otherBoss);
        for (Integer n : family707Contracts) {
            EntityMappingsMultitenantJUnitTestCase.assertNull((String)"Found family 707 contract.", (Object)em.find(Contract.class, (Object)n));
        }
        List list = em.createNamedQuery("FindAllXmlContracts").getResultList();
        EntityMappingsMultitenantJUnitTestCase.assertTrue((String)("Incorrect number of contracts were returned [" + list.size() + "], expected[3]"), (list.size() == 3 ? 1 : 0) != 0);
        for (Contract contract : list) {
            EntityMappingsMultitenantJUnitTestCase.assertFalse((String)"Contract description was voided.", (boolean)contract.getDescription().equals("voided"));
        }
        List list2 = em.createNamedQuery("findJPQLXMLMafiaFamilies").getResultList();
        EntityMappingsMultitenantJUnitTestCase.assertTrue((String)("Incorrect number of families were returned [" + list2.size() + "], expected [1]"), (list2.size() == 1 ? 1 : 0) != 0);
        Boss boss = (Boss)em.find(Boss.class, (Object)family007Mafiosos.get(0));
        EntityMappingsMultitenantJUnitTestCase.assertFalse((String)"The Boss name has been compromised", (boolean)boss.getFirstName().equals("Compromised"));
        List result = em.createNativeQuery("SELECT GENDER FROM XML_MAFIOSO WHERE ID = " + boss.getId()).getResultList();
        EntityMappingsMultitenantJUnitTestCase.assertTrue((String)("Boss with id = " + boss.getId() + " not found"), (result.size() == 1 ? 1 : 0) != 0);
        String genderFieldExpected = boss.getGender() == Mafioso.Gender.Female ? "F" : "M";
        EntityMappingsMultitenantJUnitTestCase.assertTrue((String)("Gender value conversion failed, expected [" + genderFieldExpected + "] but got [" + result.get(0) + "]"), (boolean)genderFieldExpected.equals(result.get(0)));
        this.commitTransaction(em);
    }

    protected void validateMafiaFamily707(EntityManager em) {
        EntityMappingsMultitenantJUnitTestCase.clearCache((String)MULTI_TENANT_PU);
        em.clear();
        this.beginTransaction(em);
        em.setProperty("tenant.id", (Object)"707");
        em.setProperty("eclipselink.tenant-id", (Object)"707");
        MafiaFamily family = (MafiaFamily)em.find(MafiaFamily.class, (Object)family707);
        EntityMappingsMultitenantJUnitTestCase.assertNotNull((String)("The Mafia Family with id: " + family707 + ", was not found"), (Object)family);
        EntityMappingsMultitenantJUnitTestCase.assertTrue((String)("The Mafia Family had an incorrect number of tags [" + family.getTags().size() + "], expected [3]"), (family.getTags().size() == 3 ? 1 : 0) != 0);
        EntityMappingsMultitenantJUnitTestCase.assertNull((String)("The Mafia Family with id: " + family007 + ", was found (when it should not have been)"), (Object)em.find(MafiaFamily.class, (Object)family007));
        EntityMappingsMultitenantJUnitTestCase.assertNull((String)("The Mafia Family with id: " + family123 + ", was found (when it should not have been)"), (Object)em.find(MafiaFamily.class, (Object)family123));
        EntityMappingsMultitenantJUnitTestCase.assertFalse((String)"No mafiosos part of 707 family", (boolean)family.getMafiosos().isEmpty());
        for (Integer n : family007Mafiosos) {
            EntityMappingsMultitenantJUnitTestCase.assertNull((String)"Found family 007 mafioso.", (Object)em.find(Mafioso.class, (Object)n));
        }
        Boss otherBoss = (Boss)em.find(Boss.class, (Object)family007Mafiosos.get(0));
        EntityMappingsMultitenantJUnitTestCase.assertNull((String)"Found family 007 boss.", (Object)otherBoss);
        for (Integer id : family007Contracts) {
            EntityMappingsMultitenantJUnitTestCase.assertNull((String)"Found family 007 contract. ", (Object)em.find(Contract.class, (Object)id));
        }
        em.createNamedQuery("UpdateAllXmlContractDescriptions").executeUpdate();
        List list = em.createNamedQuery("FindAllXmlContracts").getResultList();
        EntityMappingsMultitenantJUnitTestCase.assertTrue((String)("Incorrect number of contracts were returned [" + list.size() + "], expected[3]"), (list.size() == 3 ? 1 : 0) != 0);
        List soldiers = em.createQuery("SELECT s from XMLSoldier s").getResultList();
        EntityMappingsMultitenantJUnitTestCase.assertTrue((String)("Incorrect number of soldiers were returned [" + soldiers.size() + "], expected [5]"), (soldiers.size() == 5 ? 1 : 0) != 0);
        if (EntityMappingsMultitenantJUnitTestCase.getServerSession((String)MULTI_TENANT_PU).getPlatform().isSymfoware()) {
            EntityMappingsMultitenantJUnitTestCase.getServerSession((String)MULTI_TENANT_PU).logMessage("Test EntityMappingsMultiTenantJUnitTestCase partially skipped for this platform, which uses UpdateAll internally to check tenant-id when updating an entity using JOINED inheritance strategy. Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            this.commitTransaction(em);
            return;
        }
        Query query = em.createNamedQuery("UpdateXMLBossName");
        query.setParameter("name", (Object)"Compromised");
        query.setParameter("id", (Object)family007Mafiosos.get(0));
        query.executeUpdate();
        this.commitTransaction(em);
    }

    public void testTablePerTenantA() {
        EntityManager em = EntityMappingsMultitenantJUnitTestCase.createEntityManager((String)MULTI_TENANT_TABLE_PER_TENANT_PU);
        try {
            this.beginTransaction(em);
            em.setProperty("eclipselink.tenant-id", (Object)"A");
            Candidate candidateA = new Candidate();
            candidateA.setName("CA");
            candidateA.addHonor("Raised most money");
            candidateA.addHonor("Highest win margin");
            candidateA.setSalary(9999999);
            Supporter supporter1 = new Supporter();
            supporter1.setName("Supporter1");
            candidateA.addSupporter(supporter1);
            Supporter supporter2 = new Supporter();
            supporter2.setName("Supporter2");
            candidateA.addSupporter(supporter2);
            Party party = new Party();
            party.setName("Conservatives");
            party.addCandidate(candidateA);
            Riding riding = new Riding();
            riding.setName("Ottawa");
            candidateA.setRiding(riding);
            em.persist((Object)party);
            em.persist((Object)candidateA);
            em.persist((Object)supporter2);
            em.persist((Object)supporter1);
            em.persist((Object)riding);
            Mason mason = new Mason();
            mason.setName("FromTenantA");
            mason.addAward((Date)Helper.timestampFromDate((Date)Helper.dateFromYearMonthDate((int)2009, (int)1, (int)1)), "Concrete float master");
            mason.addAward((Date)Helper.timestampFromDate((Date)Helper.dateFromYearMonthDate((int)2010, (int)5, (int)9)), "Form stake out expert");
            Trowel trowel = new Trowel();
            trowel.setType("Concrete");
            mason.setTrowel(trowel);
            trowel.setMason(mason);
            em.persist((Object)mason);
            em.persist((Object)trowel);
            candidateAId = candidateA.getId();
            ridingId = riding.getId();
            partyId = party.getId();
            supporter1Id = supporter1.getId();
            supporter2Id = supporter2.getId();
            masonId = mason.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testTablePerTenantB() {
        EntityManager em = EntityMappingsMultitenantJUnitTestCase.createEntityManager((String)MULTI_TENANT_TABLE_PER_TENANT_PU);
        try {
            this.beginTransaction(em);
            em.setProperty("eclipselink.tenant-id", (Object)"B");
            EntityMappingsMultitenantJUnitTestCase.assertNull((String)"CandidateA was found from tenant B.", (Object)em.find(Candidate.class, (Object)candidateAId));
            EntityMappingsMultitenantJUnitTestCase.assertNull((String)"Supporter1 was found from tenant B.", (Object)em.find(Supporter.class, (Object)supporter1Id));
            EntityMappingsMultitenantJUnitTestCase.assertNull((String)"Supporter2 was found from tenant B.", (Object)em.find(Supporter.class, (Object)supporter2Id));
            EntityMappingsMultitenantJUnitTestCase.assertNull((String)"Mason was found from tenant B.", (Object)em.find(Mason.class, (Object)masonId));
            Riding riding = (Riding)em.find(Riding.class, (Object)ridingId);
            EntityMappingsMultitenantJUnitTestCase.assertNotNull((String)"Riding was not found from tenant B", (Object)riding);
            Party party = (Party)em.find(Party.class, (Object)partyId);
            EntityMappingsMultitenantJUnitTestCase.assertNotNull((String)"Party was not found from tenant B", (Object)party);
            Candidate candidateB = new Candidate();
            candidateB.setName("CB");
            candidateB.setSalary(100);
            em.persist((Object)candidateB);
            this.commitTransaction(em);
            em.clear();
            EntityMappingsMultitenantJUnitTestCase.clearCache((String)MULTI_TENANT_TABLE_PER_TENANT_PU);
            this.beginTransaction(em);
            em.setProperty("eclipselink.tenant-id", (Object)"B");
            Candidate candidateBRefreshed = (Candidate)em.find(Candidate.class, (Object)candidateB.getId());
            EntityMappingsMultitenantJUnitTestCase.assertNull((String)"Candidate B has a Party when he shouldn't have.", (Object)candidateBRefreshed.getParty());
            EntityMappingsMultitenantJUnitTestCase.assertNull((String)"Candidate B has a Riding when he shouldn't have.", (Object)candidateBRefreshed.getRiding());
            EntityMappingsMultitenantJUnitTestCase.assertTrue((String)"Candidate B had supporters when he shouldn't have.", (boolean)candidateBRefreshed.getSupporters().isEmpty());
            EntityMappingsMultitenantJUnitTestCase.assertTrue((String)"Candidate B had honors when he shouldn't have.", (boolean)candidateBRefreshed.getHonors().isEmpty());
            EntityMappingsMultitenantJUnitTestCase.assertTrue((String)"Candidate B had the incorrect salary.", (candidateBRefreshed.getSalary() == 100 ? 1 : 0) != 0);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testTablePerTenantC() {
        Map properties = JUnitTestCaseHelper.getDatabaseProperties();
        properties.put("eclipselink.exclude-eclipselink-orm", "true");
        properties.put("eclipselink.multitenant.tenants-share-emf", "false");
        properties.put("eclipselink.session-name", "extended-multi-tenant-C");
        properties.put("eclipselink.tenant-id", "C");
        properties.put("eclipselink.jdbc.allow-native-sql-queries", "true");
        EntityManager em = EntityMappingsMultitenantJUnitTestCase.createEntityManager((String)MULTI_TENANT_TABLE_PER_TENANT_C_PU, (Map)properties);
        try {
            this.beginTransaction(em);
            Candidate candidate = new Candidate();
            candidate.setName("C");
            candidate.addHonor("Raised most money");
            candidate.addHonor("Highest win margin");
            candidate.setSalary(9999999);
            Supporter supporter1 = new Supporter();
            supporter1.setName("Supporter1");
            candidate.addSupporter(supporter1);
            Supporter supporter2 = new Supporter();
            supporter2.setName("Supporter2");
            candidate.addSupporter(supporter2);
            Party party = new Party();
            party.setName("Conservatives");
            party.addCandidate(candidate);
            Riding riding = new Riding();
            riding.setName("Ottawa");
            candidate.setRiding(riding);
            em.persist((Object)party);
            em.persist((Object)candidate);
            em.persist((Object)supporter2);
            em.persist((Object)supporter1);
            em.persist((Object)riding);
            Mason mason = new Mason();
            mason.setName("FromTenantC");
            mason.addAward((Date)Helper.timestampFromDate((Date)Helper.dateFromYearMonthDate((int)2009, (int)1, (int)1)), "Best pointer");
            mason.addAward((Date)Helper.timestampFromDate((Date)Helper.dateFromYearMonthDate((int)2010, (int)5, (int)9)), "Least screw-ups");
            Trowel trowel = new Trowel();
            trowel.setType("Pointing");
            mason.setTrowel(trowel);
            trowel.setMason(mason);
            em.persist((Object)mason);
            em.persist((Object)trowel);
            candidateAId = candidate.getId();
            ridingId = riding.getId();
            partyId = party.getId();
            supporter1Id = supporter1.getId();
            supporter2Id = supporter2.getId();
            masonId = mason.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    static {
        family707Mafiosos = new ArrayList<Integer>();
        family707Contracts = new ArrayList<Integer>();
        family007Mafiosos = new ArrayList<Integer>();
        family007Contracts = new ArrayList<Integer>();
        family123Mafiosos = new ArrayList<Integer>();
        family123Contracts = new ArrayList<Integer>();
    }
}

