/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class NoValidationWithInitIdentityMaps
extends TransactionalTestCase {
    protected String existenceCheck;
    protected Employee objectToBeWritten;
    SessionEventListener listener;

    public NoValidationWithInitIdentityMaps() {
        this.setDescription("Test using no validation.");
    }

    public void setup() {
        if (this.getSession().isClientSession()) {
            this.listener = this.checkTransactionIsolation();
        }
        super.setup();
        this.existenceCheck = this.getSession().getDescriptor(Employee.class).getQueryManager().getExistenceCheck();
        if (this.getSession() instanceof RemoteSession) {
            throw new TestWarningException("This test uses functionality that does not work over remote sessions.");
        }
    }

    public void reset() {
        super.reset();
        this.getSession().getDescriptor(Employee.class).setExistenceChecking(this.existenceCheck);
        if (this.listener != null) {
            this.getAbstractSession().getParent().getEventManager().removeListener(this.listener);
            this.listener = null;
        }
    }

    public void test() {
        this.testNoneCheckDatabaseNewObject();
        this.testNoneAssumeNonExistenceNewObject();
        this.testNoneCheckDatabase();
        this.testNoneAssumeExistence();
        this.testNoneAssumeNonExistence();
    }

    public void testNoneCheckDatabaseNewObject() {
        Employee newObject;
        Employee employeeFromCache = new Employee();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getSession().getDescriptor(Employee.class).setExistenceChecking("Check database");
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.objectToBeWritten = newObject = (Employee)uow.newInstance(Employee.class);
        uow.dontPerformValidation();
        newObject.setManager(employeeFromCache);
        uow.commit();
    }

    public void testNoneAssumeNonExistenceNewObject() {
        Employee newObject;
        Employee employeeFromCache = new Employee();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getSession().getDescriptor(Employee.class).setExistenceChecking("Assume non-existence");
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.objectToBeWritten = newObject = (Employee)uow.newInstance(Employee.class);
        uow.dontPerformValidation();
        newObject.setManager(employeeFromCache);
        uow.commit();
    }

    public void testNoneCheckDatabase() {
        Employee newObject;
        Employee employeeFromCache = (Employee)this.getSession().readObject(Employee.class);
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getSession().getDescriptor(Employee.class).setExistenceChecking("Check database");
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.objectToBeWritten = newObject = (Employee)uow.newInstance(Employee.class);
        uow.dontPerformValidation();
        newObject.setManager(employeeFromCache);
        uow.commit();
    }

    public void testNoneAssumeExistence() {
        Employee newObject;
        Employee employeeFromCache = (Employee)this.getSession().readObject(Employee.class);
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getSession().getDescriptor(Employee.class).setExistenceChecking("Assume existence");
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.objectToBeWritten = newObject = (Employee)uow.newInstance(Employee.class);
        uow.dontPerformValidation();
        newObject.setManager(employeeFromCache);
        uow.commit();
    }

    public void testNoneAssumeNonExistence() {
        Employee newObject;
        Employee employeeFromCache = (Employee)this.getSession().readObject(Employee.class);
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getSession().getDescriptor(Employee.class).setExistenceChecking("Assume non-existence");
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.objectToBeWritten = newObject = (Employee)uow.newInstance(Employee.class);
        uow.dontPerformValidation();
        uow.commit();
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Object objectFromDatabase = this.getSession().readObject((Object)this.objectToBeWritten);
        if (!this.compareObjects(this.objectToBeWritten, objectFromDatabase)) {
            throw new TestErrorException("The object inserted into the database, '" + objectFromDatabase + "' does not match the original, '" + this.objectToBeWritten + ".");
        }
    }
}

