/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpql;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.jpql.JPQLTestCase;

public class OneToManyJoinOptimizationTest
extends JPQLTestCase {
    public OneToManyJoinOptimizationTest() {
        this.setDescription("Test the SQL statement generation for one-to-many relationships");
    }

    @Override
    public void setup() {
        this.setEjbqlString("SELECT DISTINCT OBJECT(emp) FROM Employee emp, IN(emp.phoneNumbers) pn WHERE emp.firstName = 'Jill' AND pn.type = 'Work' AND pn.areaCode = '613'");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.get("firstName").equalsIgnoreCase("Jill");
        exp = exp.and(builder.anyOf("phoneNumbers").get("type").equalsIgnoreCase("Work"));
        exp = exp.and(builder.anyOf("phoneNumbers").get("areaCode").equalsIgnoreCase("613"));
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(Employee.class);
        query.setSelectionCriteria(exp);
        this.setOriginalOject(this.getSession().executeQuery((DatabaseQuery)query));
        super.setup();
    }

    @Override
    public void verify() throws Exception {
        super.verify();
        String sqlString = this.getQuery().getSQLString();
        if (sqlString.indexOf(" t3") > -1) {
            throw new TestErrorException("Too many tables generated in SQL. Found extra PHONE table");
        }
    }
}

