/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.sessions.ExternalTransactionController;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.transaction.JTATransactionController;

public class ClientSessionConstructorValidationTest
extends AutoVerifyTestCase {
    private ServerSession server;
    private ClientSession client;

    public ClientSessionConstructorValidationTest() {
        this.setDescription("Verifies that the Client Session is constructed properly");
    }

    public void test() {
        this.server = new ServerSession((Login)this.getSession().getLogin(), 1, 1);
        this.server.setExternalTransactionController((ExternalTransactionController)new JTATransactionController());
        this.server.login();
        this.client = this.server.acquireClientSession();
    }

    public void verify() {
        if (!this.server.getExternalTransactionController().equals(this.client.getExternalTransactionController())) {
            throw new TestErrorException("ExternalTransactionController not copied from parent session to client session");
        }
    }

    public void reset() {
        if (this.server != null) {
            this.server.logout();
            this.server = null;
        }
    }
}

