/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.clientserver.Server;

public class ClientLoginTest
extends TestCase {
    protected DatabaseLogin login;
    protected Server server;
    protected ClientSession clientSession;

    public void reset() {
        this.server.logout();
        this.getDatabaseSession().logout();
        this.getDatabaseSession().login();
    }

    public void setup() {
        this.login = (DatabaseLogin)this.getSession().getLogin().clone();
        this.server = new Server(this.login);
        this.server.serverSession.setSessionLog(this.getSession().getSessionLog());
        this.server.login();
    }

    public void test() {
        DatabaseLogin newLogin = (DatabaseLogin)this.login.clone();
        newLogin.setUserName("xFredyFlinstonez");
        newLogin.setPassword("abcWindex");
        try {
            this.clientSession = this.server.serverSession.acquireClientSession((Login)newLogin);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void verify() {
        if (this.clientSession != null && this.clientSession.isConnected()) {
            throw new TestErrorException("The client's login value was ignored.  Test failed");
        }
    }
}

