/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fieldaccess.advanced;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.ModelExamples;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Project;

public class OptimisticConcurrencyJUnitTestSuite
extends JUnitTestCase {
    public OptimisticConcurrencyJUnitTestSuite() {
    }

    public OptimisticConcurrencyJUnitTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Optimistic Concurrency (fieldaccess)");
        suite.addTest((Test)new OptimisticConcurrencyJUnitTestSuite("testSetup"));
        suite.addTest((Test)new OptimisticConcurrencyJUnitTestSuite("testCreateProjects"));
        suite.addTest((Test)new OptimisticConcurrencyJUnitTestSuite("testCreateEmployeeWithFlush"));
        suite.addTest((Test)new OptimisticConcurrencyJUnitTestSuite("testVersionUpdateWithCorrectValue"));
        suite.addTest((Test)new OptimisticConcurrencyJUnitTestSuite("testVersionUpdateWithIncorrectValue"));
        suite.addTest((Test)new OptimisticConcurrencyJUnitTestSuite("testVersionUpdateWithNullValue"));
        return suite;
    }

    public void testSetup() {
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession((String)"fieldaccess"));
        OptimisticConcurrencyJUnitTestSuite.clearCache((String)"fieldaccess");
    }

    public void testCreateProjects() {
        EntityManager em = OptimisticConcurrencyJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        Project project1 = ModelExamples.projectExample1();
        Project project2 = ModelExamples.projectExample2();
        em.persist((Object)project1);
        em.persist((Object)project2);
        this.commitTransaction(em);
    }

    public void testCreateEmployeeWithFlush() {
        EntityManager em = OptimisticConcurrencyJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Employee employee = ModelExamples.employeeExample1();
            em.persist((Object)employee);
            Query query = em.createNamedQuery("findFieldAccessProjectByName");
            query.setParameter("name", (Object)"Farmer effecency evaluations");
            Project project1 = (Project)query.getSingleResult();
            employee.getProjects().add(project1);
            query = em.createNamedQuery("findFieldAccessProjectByName");
            query.setParameter("name", (Object)"Feline Demographics Assesment");
            Project project2 = (Project)query.getSingleResult();
            employee.getProjects().add(project2);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testVersionUpdateWithCorrectValue() {
        EntityManager em = OptimisticConcurrencyJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Employee employee = ModelExamples.employeeExample1();
            em.persist((Object)employee);
            this.commitTransaction(em);
            this.beginTransaction(em);
            employee.setVersion(Integer.valueOf(1));
            this.commitTransaction(em);
        }
        catch (RuntimeException re) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw re;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersionUpdateWithIncorrectValue() {
        EntityManager em = OptimisticConcurrencyJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Employee employee = ModelExamples.employeeExample1();
            em.persist((Object)employee);
            this.commitTransaction(em);
            this.beginTransaction(em);
            Employee employee1 = (Employee)em.find(Employee.class, (Object)employee.getId());
            employee1.setVersion(Integer.valueOf(2));
            this.commitTransaction(em);
            OptimisticConcurrencyJUnitTestSuite.fail((String)"updating object version with wrong value didn't throw exception");
        }
        catch (PersistenceException employee1) {
        }
        catch (Exception exception) {
            Throwable persistenceException;
            for (persistenceException = exception; persistenceException != null && !(persistenceException instanceof OptimisticLockException); persistenceException = persistenceException.getCause()) {
            }
            if (persistenceException instanceof OptimisticLockException) {
                return;
            }
            OptimisticConcurrencyJUnitTestSuite.fail((String)("updating object version with wrong value threw a wrong exception: " + exception.getMessage()));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersionUpdateWithNullValue() {
        EntityManager em = OptimisticConcurrencyJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Employee employee = ModelExamples.employeeExample1();
            em.persist((Object)employee);
            this.commitTransaction(em);
            this.beginTransaction(em);
            Employee employee2 = (Employee)em.find(Employee.class, (Object)employee.getId());
            employee2.setVersion(null);
            this.commitTransaction(em);
            OptimisticConcurrencyJUnitTestSuite.fail((String)"employee2.setVersion(null) didn't throw exception");
        }
        catch (PersistenceException employee2) {
        }
        catch (Exception exception) {
            Throwable persistenceException;
            for (persistenceException = exception; persistenceException != null && !(persistenceException instanceof OptimisticLockException); persistenceException = persistenceException.getCause()) {
            }
            if (persistenceException instanceof OptimisticLockException) {
                return;
            }
            OptimisticConcurrencyJUnitTestSuite.fail((String)("employee2.setVersion(null) threw a wrong exception: " + exception.getMessage()));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }
}

