/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import java.io.IOException;
import junit.framework.Test;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.tests.feature.CacheStatementBatchWritingTest;
import org.eclipse.persistence.testing.tests.feature.TopLinkBatchUpdatesTestModel;

public class ParameterizedBatchUpdatesTestModel
extends TopLinkBatchUpdatesTestModel {
    public Boolean wasBinding;
    public Boolean wasStatementCaching;

    @Override
    public void addForcedRequiredSystems() {
        DatabasePlatform platform = this.getSession().getPlatform();
        this.wasBatchWriting = platform.usesBatchWriting();
        this.wasJDBCBatchWriting = platform.usesJDBCBatchWriting();
        this.wasBinding = platform.shouldBindAllParameters();
        this.wasStatementCaching = platform.shouldCacheAllStatements();
        try {
            this.getSession().getLog().write("WARNING, some JDBC drivers may fail BatchUpdates.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        platform.setUsesBatchWriting(true);
        platform.setShouldBindAllParameters(true);
        platform.setShouldCacheAllStatements(true);
        platform.setUsesJDBCBatchWriting(true);
        platform.setMaxBatchWritingSize(100);
        this.getExecutor().removeConfigureSystem((TestSystem)new EmployeeSystem());
        this.addForcedRequiredSystem(new EmployeeSystem());
    }

    @Override
    public void reset() {
        super.reset();
        DatabasePlatform platform = this.getSession().getPlatform();
        if (this.wasBinding != null) {
            platform.setShouldBindAllParameters(this.wasBinding.booleanValue());
        }
        if (this.wasStatementCaching != null) {
            platform.setShouldCacheAllStatements(this.wasStatementCaching.booleanValue());
        }
    }

    @Override
    public void addTests() {
        super.addTests();
        this.addTest((Test)new CacheStatementBatchWritingTest());
    }
}

