/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers.rcm;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServer;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServersModel;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.ConfigurableCacheSyncDistributedTest;

public class RelatedNewObjectCacheSyncTest
extends ConfigurableCacheSyncDistributedTest {
    protected Employee employee = null;
    protected Employee manager = null;
    protected Expression expression = null;

    public RelatedNewObjectCacheSyncTest() {
        this.cacheSyncConfigValues.put(Employee.class, new Integer(3));
    }

    @Override
    public void setup() {
        super.setup();
        ExpressionBuilder employees = new ExpressionBuilder();
        this.expression = employees.get("firstName").equal((Object)"Charles");
        this.expression = this.expression.and(employees.get("lastName").equal((Object)"Chanley"));
        DistributedServer server = (DistributedServer)DistributedServersModel.getDistributedServers().get(0);
        Object result = server.getDistributedSession().readObject(Employee.class, this.expression);
        ((Employee)result).getManagedEmployees();
        ((Employee)result).getPhoneNumbers();
        ((Employee)result).getAddress();
        ((Employee)result).getManager();
        ((Employee)result).getProjects();
        ((Employee)result).getResponsibilitiesList();
    }

    public void test() {
        this.employee = (Employee)this.getSession().readObject(Employee.class, this.expression);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee employeeClone = (Employee)uow.registerObject((Object)this.employee);
        employeeClone.setSalary(employeeClone.getSalary() + 1);
        this.manager = new Employee();
        this.manager.setFirstName("Fred");
        this.manager.setLastName("Fenster");
        Employee managerClone = (Employee)uow.registerObject((Object)this.manager);
        employeeClone.setManager(managerClone);
        uow.commit();
    }

    public void verify() {
        if (this.getObjectFromDistributedCache(this.manager) == null) {
            throw new TestErrorException("New employee was not added to distributed cache with  SEND_NEW_OBJECTS_WITH_CHANGES descriptor CacheSynchronizationTypeSetting.");
        }
        Employee distributedEmployee = (Employee)this.getObjectFromDistributedCache(this.employee);
        Employee distributedManager = (Employee)this.getObjectFromDistributedCache(this.manager);
        if (distributedEmployee.getSalary() != this.employee.getSalary()) {
            throw new TestErrorException("Changes for existing employee were not sent to the distributed cache.");
        }
        if (!((AbstractSession)this.getSession()).compareObjects((Object)distributedEmployee.getManager(), (Object)this.manager)) {
            throw new TestErrorException("Relationship between employee and manager was not properly maintained in distributed cache.");
        }
    }
}

