/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.reading;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;

public class ReadObjectPreparedvsDynamicTest
extends PerformanceComparisonTestCase {
    protected ReadObjectQuery query;
    protected ReadObjectQuery ejbQuery;

    public ReadObjectPreparedvsDynamicTest() {
        this.setDescription("Compares the performance between a prepared and dynamic query.");
        this.addTest((TestCase)this.buildPreparedTest());
        this.addTest((TestCase)this.buildPreparedEJBQLTest());
        this.addTest((TestCase)this.buildDynamicEJBQLTest());
        this.addTest((TestCase)this.buildDynamicNoParseCacheEJBQLTest());
        this.addTest((TestCase)this.buildDynamicExpressionCachedExpressionTest());
    }

    public void setup() {
        this.query = new ReadObjectQuery(Employee.class);
        this.query.setSelectionCriteria(this.query.getExpressionBuilder().get("firstName").equal(this.query.getExpressionBuilder().getParameter("name")));
        this.query.addArgument("name");
        this.ejbQuery = new ReadObjectQuery(Employee.class);
        this.ejbQuery.setEJBQLString("Select Object(employee) from Employee employee where employee.firstName = :name");
        this.ejbQuery.addArgument("name");
        Vector<String> args = new Vector<String>();
        args.add("Bob");
        this.getSession().executeQuery((DatabaseQuery)this.query, args);
        this.getSession().executeQuery((DatabaseQuery)this.ejbQuery, args);
    }

    public void test() throws Exception {
        ClassDescriptor descriptor = this.getSession().getClassDescriptor(Employee.class);
        int size = descriptor.getQueryManager().getExpressionQueryCacheMaxSize();
        descriptor.getQueryManager().setExpressionQueryCacheMaxSize(0);
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("firstName").equal((Object)"Bob"));
        Object result = this.getSession().executeQuery((DatabaseQuery)query);
        descriptor.getQueryManager().setExpressionQueryCacheMaxSize(size);
    }

    public PerformanceComparisonTestCase buildPreparedTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                Vector<String> args = new Vector<String>();
                args.add("Bob");
                Object result = this.getSession().executeQuery((DatabaseQuery)ReadObjectPreparedvsDynamicTest.this.query, args);
            }
        };
        test.setName("PreparedReadObjectTest");
        test.setAllowableDecrease(5.0);
        return test;
    }

    public PerformanceComparisonTestCase buildPreparedEJBQLTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                Vector<String> args = new Vector<String>();
                args.add("Bob");
                Object result = this.getSession().executeQuery((DatabaseQuery)ReadObjectPreparedvsDynamicTest.this.ejbQuery, args);
            }
        };
        test.setName("PreparedEJBQLReadObjectTest");
        test.setAllowableDecrease(5.0);
        return test;
    }

    public PerformanceComparisonTestCase buildDynamicEJBQLTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                ReadObjectQuery ejbQuery = new ReadObjectQuery(Employee.class);
                ejbQuery.setEJBQLString("Select Object(employee) from Employee employee where employee.firstName = :name");
                ejbQuery.addArgument("name");
                Vector<String> args = new Vector<String>();
                args.add("Bob");
                Object result = this.getSession().executeQuery((DatabaseQuery)ejbQuery, args);
            }
        };
        test.setName("DynamicParseCachedEJBQLReadObjectTest");
        test.setAllowableDecrease(5.0);
        return test;
    }

    public PerformanceComparisonTestCase buildDynamicNoParseCacheEJBQLTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                int size = this.getSession().getProject().getJPQLParseCacheMaxSize();
                this.getSession().getProject().setJPQLParseCacheMaxSize(0);
                ReadObjectQuery ejbQuery = new ReadObjectQuery(Employee.class);
                ejbQuery.setEJBQLString("Select Object(employee) from Employee employee where employee.firstName = :name");
                ejbQuery.addArgument("name");
                Vector<String> args = new Vector<String>();
                args.add("Bob");
                Object result = this.getSession().executeQuery((DatabaseQuery)ejbQuery, args);
                this.getSession().getProject().setJPQLParseCacheMaxSize(size);
            }
        };
        test.setName("DynamicDisabledParseCacheEJBQLReadObjectTest");
        test.setAllowableDecrease(-25.0);
        return test;
    }

    public PerformanceComparisonTestCase buildDynamicExpressionCachedExpressionTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                ReadObjectQuery query = new ReadObjectQuery(Employee.class);
                query.setSelectionCriteria(query.getExpressionBuilder().get("firstName").equal((Object)"Bob"));
                Object result = this.getSession().executeQuery((DatabaseQuery)query);
            }
        };
        test.setName("DynamicExpressionCachedExpressionReadObjectTest");
        test.setAllowableDecrease(5.0);
        return test;
    }
}

