package org.eclipse.persistence.jpa.rs.util.metadatasources;

import java.util.Map;

import org.eclipse.persistence.jaxb.metadata.MetadataSource;
import org.eclipse.persistence.jaxb.xmlmodel.JavaType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings.JavaTypes;
import org.eclipse.persistence.jpa.rs.exceptions.ErrorResponse;

/**
 * Makes the ErrorResponse class available to JAXB context.
 *
 */
public class ErrorResponseMetadataSource implements MetadataSource {
    private XmlBindings xmlBindings;

    public ErrorResponseMetadataSource() {
        xmlBindings = new XmlBindings();
        xmlBindings.setPackageName(ErrorResponse.class.getPackage().getName());
        JavaTypes javaTypes = new JavaTypes();
        xmlBindings.setJavaTypes(javaTypes);
        JavaType javaType = new JavaType();
        javaType.setName(ErrorResponse.class.getSimpleName());
        javaTypes.getJavaType().add(javaType);
    }

    public XmlBindings getXmlBindings(Map<String, ?> properties, ClassLoader classLoader) {
        return this.xmlBindings;
    }
}
